/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _RTABLE4_H_RPCGEN
#define	_RTABLE4_H_RPCGEN

#include <rpc/rpc.h>

typedef char *Buffer;

enum Transaction {
	add = 0,
	cm_remove = 1
};
typedef enum Transaction Transaction;

enum Interval {
	single = 0,
	daily = 1,
	weekly = 2,
	biweekly = 3,
	monthly = 4,
	yearly = 5,
	nthWeekday = 6,
	everyNthDay = 7,
	everyNthWeek = 8,
	everyNthMonth = 9,
	otherPeriod = 10,
	monThruFri = 11,
	monWedFri = 12,
	tueThur = 13,
	daysOfWeek = 14
};
typedef enum Interval Interval;

struct Period {
	Interval period;
	int nth;
	long enddate;
};
typedef struct Period Period;

enum Event_Type {
	appointment = 0,
	reminder = 1,
	otherTag = 2,
	holiday = 3,
	toDo = 4
};
typedef enum Event_Type Event_Type;

enum Options {
	do_all = 0,
	do_one = 1,
	do_forward = 2
};
typedef enum Options Options;

struct Tag {
	Event_Type tag;
	int showtime;
	struct Tag *next;
};
typedef struct Tag Tag;

enum Privacy_Level {
	public = 0,
	private = 1,
	semiprivate = 2
};
typedef enum Privacy_Level Privacy_Level;

struct Attribute {
	struct Attribute *next;
	Buffer attr;
	Buffer value;
	Buffer clientdata;
};
typedef struct Attribute Attribute;

typedef Attribute *Attr;

struct Except {
	int ordinal;
	struct Except *next;
};
typedef struct Except Except;

typedef Except *Exception;

struct Id {
	long tick;
	long key;
};
typedef struct Id Id;

struct Uid {
	struct Id appt_id;
	struct Uid *next;
};
typedef struct Uid Uid;

enum Appt_Status {
	active = 0,
	pendingAdd = 1,
	pendingDelete = 2,
	committed = 3,
	cancelled = 4,
	completed = 5
};
typedef enum Appt_Status Appt_Status;

struct Appt {
	struct Id appt_id;
	struct Tag *tag;
	int duration;
	int ntimes;
	Buffer what;
	struct Period period;
	Buffer author;
	Buffer client_data;
	struct Except *exception;
	struct Attribute *attr;
	Appt_Status appt_status;
	Privacy_Level privacy;
	struct Appt *next;
};
typedef struct Appt Appt;

struct Abb_Appt {
	struct Id appt_id;
	struct Tag *tag;
	Buffer what;
	int duration;
	struct Period period;
	struct Abb_Appt *next;
	Appt_Status appt_status;
	Privacy_Level privacy;
};
typedef struct Abb_Appt Abb_Appt;

struct Apptid {
	struct Id *oid;
	struct Appt *new_appt;
	Options option;
};
typedef struct Apptid Apptid;

struct Reminder {
	struct Id appt_id;
	long tick;
	Attribute attr;
	struct Reminder *next;
};
typedef struct Reminder Reminder;

enum Table_Res_Type {
	AP = 0,
	RM = 1,
	AB = 2,
	ID = 3
};
typedef enum Table_Res_Type Table_Res_Type;

struct Table_Res_List {
	Table_Res_Type tag;
	union {
		Appt *a;
		Reminder *r;
		Abb_Appt *b;
		Uid *i;
	} Table_Res_List_u;
};
typedef struct Table_Res_List Table_Res_List;

enum Access_Status {
	access_ok = 0,
	access_added = 1,
	access_removed = 2,
	access_failed = 3,
	access_exists = 4,
	access_partial = 5,
	access_other = 6,
	access_notable = 7,
	access_notsupported = 8,
	access_incomplete = 9
};
typedef enum Access_Status Access_Status;

struct Table_Res {
	Access_Status status;
	Table_Res_List res;
};
typedef struct Table_Res Table_Res;
#define access_none   0x0     /* owner only */
#define access_read   0x1
#define access_write  0x2
#define access_delete 0x4
#define access_exec   0x8     /* execution permission is a hack! */
#define WORLD "world"	/* special user */

struct Access_Entry {
	Buffer who;
	int access_type;
	struct Access_Entry *next;
};
typedef struct Access_Entry Access_Entry;

struct Access_Args {
	Buffer target;
	Access_Entry *access_list;
};
typedef struct Access_Args Access_Args;

struct Range {
	long key1;
	long key2;
	struct Range *next;
};
typedef struct Range Range;

struct Keyrange {
	long key;
	long tick1;
	long tick2;
	struct Keyrange *next;
};
typedef struct Keyrange Keyrange;

struct Uidopt {
	struct Id appt_id;
	Options option;
	struct Uidopt *next;
};
typedef struct Uidopt Uidopt;

enum Table_Args_Type {
	TICK_4 = 0,
	APPTID = 1,
	UID = 2,
	APPT = 3,
	RANGE = 4,
	KEYRANGE = 5,
	UIDOPT = 6
};
typedef enum Table_Args_Type Table_Args_Type;

struct Args {
	Table_Args_Type tag;
	union {
		long tick;
		Apptid apptid;
		Uid *key;
		Appt *appt;
		Range *range;
		Keyrange *keyrange;
		Uidopt *uidopt;
	} Args_u;
};
typedef struct Args Args;

struct Table_Args {
	Buffer target;
	Args args;
	int pid;
};
typedef struct Table_Args Table_Args;

struct Registration {
	Buffer target;
	u_long prognum;
	u_long versnum;
	u_long procnum;
	struct Registration *next;
	int pid;
};
typedef struct Registration Registration;

struct Table_Op_Args {
	Buffer target;
	Buffer new_target;
};
typedef struct Table_Op_Args Table_Op_Args;

enum Table_Status {
	ok = 0,
	duplicate = 1,
	badtable = 2,
	notable = 3,
	denied = 4,
	other = 5,
	tbl_not_owner = 6,
	tbl_exist = 7,
	tbl_notsupported = 8
};
typedef enum Table_Status Table_Status;

enum Registration_Status {
	registered = 0,
	failed = 1,
	deregistered = 2,
	confused = 3,
	reg_notable = 4
};
typedef enum Registration_Status Registration_Status;

/*
 * rtable_delete and rtable_change take over the functionality of
 * rtable_delete_instance and rtable_change_instance repectively.
 * rtable_delete_instance and rtable_change_instance are now dummy
 * routines exist for backward compatibility purpose and return
 * access_notsupported.
 */

extern Appt* make_appt();
extern void destroy_appt();
extern void destroy_list();
extern Appt *copy_appt();
extern Appt *copy_semiprivate_appt();
extern Abb_Appt *make_abbrev_appt();
extern void destroy_abbrev_appt();
extern Abb_Appt *copy_abbrev_appt();
extern Abb_Appt *appt_to_abbrev();
extern Abb_Appt *appt_to_semiprivate_abbrev();
extern Reminder* make_reminder();
extern void destroy_reminder();
extern Reminder* copy_reminder();
extern Uid* make_keyentry();
extern void destroy_keyentry();
extern Uid* copy_keyentry();
extern Access_Entry* make_access_entry();
extern Access_Entry* copy_access_list();
extern void destroy_access_list();
extern Abb_Appt *copy_single_abbrev_appt();
extern Attribute *make_attr();

#define	TABLEPROG ((unsigned long)(100068))
#define	TABLEVERS ((unsigned long)(4))
#define	rtable_ping ((unsigned long)(0))
extern  void * rtable_ping_4();
#define	rtable_lookup ((unsigned long)(1))
extern  Table_Res * rtable_lookup_4();
#define	rtable_lookup_next_larger ((unsigned long)(2))
extern  Table_Res * rtable_lookup_next_larger_4();
#define	rtable_lookup_next_smaller ((unsigned long)(3))
extern  Table_Res * rtable_lookup_next_smaller_4();
#define	rtable_lookup_range ((unsigned long)(4))
extern  Table_Res * rtable_lookup_range_4();
#define	rtable_abbreviated_lookup_range ((unsigned long)(5))
extern  Table_Res * rtable_abbreviated_lookup_range_4();
#define	rtable_insert ((unsigned long)(6))
extern  Table_Res * rtable_insert_4();
#define	rtable_delete ((unsigned long)(7))
extern  Table_Res * rtable_delete_4();
#define	rtable_delete_instance ((unsigned long)(8))
extern  Table_Res * rtable_delete_instance_4();
#define	rtable_change ((unsigned long)(9))
extern  Table_Res * rtable_change_4();
#define	rtable_change_instance ((unsigned long)(10))
extern  Table_Res * rtable_change_instance_4();
#define	rtable_lookup_next_reminder ((unsigned long)(11))
extern  Table_Res * rtable_lookup_next_reminder_4();
#define	rtable_check ((unsigned long)(12))
extern  Table_Status * rtable_check_4();
#define	rtable_flush_table ((unsigned long)(13))
extern  Table_Status * rtable_flush_table_4();
#define	rtable_size ((unsigned long)(14))
extern  int * rtable_size_4();
#define	register_callback ((unsigned long)(15))
extern  Registration_Status * register_callback_4();
#define	deregister_callback ((unsigned long)(16))
extern  Registration_Status * deregister_callback_4();
#define	rtable_set_access ((unsigned long)(17))
extern  Access_Status * rtable_set_access_4();
#define	rtable_get_access ((unsigned long)(18))
extern  Access_Args * rtable_get_access_4();
#define	rtable_abbreviated_lookup_key_range ((unsigned long)(19))
extern  Table_Res * rtable_abbreviated_lookup_key_range_4();
#define	rtable_gmtoff ((unsigned long)(20))
extern  long * rtable_gmtoff_4();
#define	rtable_create ((unsigned long)(21))
extern  Table_Status * rtable_create_4();
#define	rtable_remove ((unsigned long)(22))
extern  Table_Status * rtable_remove_4();
#define	rtable_rename ((unsigned long)(23))
extern  Table_Status * rtable_rename_4();
extern int tableprog_4_freeresult();

/* the xdr functions */
extern bool_t xdr_Buffer();
extern bool_t xdr_Transaction();
extern bool_t xdr_Interval();
extern bool_t xdr_Period();
extern bool_t xdr_Event_Type();
extern bool_t xdr_Options();
extern bool_t xdr_Tag();
extern bool_t xdr_Privacy_Level();
extern bool_t xdr_Attribute();
extern bool_t xdr_Attr();
extern bool_t xdr_Except();
extern bool_t xdr_Exception();
extern bool_t xdr_Id();
extern bool_t xdr_Uid();
extern bool_t xdr_Appt_Status();
extern bool_t xdr_Appt();
extern bool_t xdr_Abb_Appt();
extern bool_t xdr_Apptid();
extern bool_t xdr_Reminder();
extern bool_t xdr_Table_Res_Type();
extern bool_t xdr_Table_Res_List();
extern bool_t xdr_Access_Status();
extern bool_t xdr_Table_Res();
extern bool_t xdr_Access_Entry();
extern bool_t xdr_Access_Args();
extern bool_t xdr_Range();
extern bool_t xdr_Keyrange();
extern bool_t xdr_Uidopt();
extern bool_t xdr_Table_Args_Type();
extern bool_t xdr_Args();
extern bool_t xdr_Table_Args();
extern bool_t xdr_Registration();
extern bool_t xdr_Table_Op_Args();
extern bool_t xdr_Table_Status();
extern bool_t xdr_Registration_Status();

#endif /* !_RTABLE4_H_RPCGEN */
