#ifndef INIT_RACE_H
#define INIT_RACE_H

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#define WATCHFILE "/etc/csh.login"
#define PROCDIR "/proc"
#define PROC_CMP "(tcsh)"

struct list {
  char filename[256];
  struct list *next;
};

void usage(char *);
int strIsNum(char *, int);
void getUidFromName(char *, pid_t *);
void checkAttackScript(char *, struct stat *);
void initList(struct list *);
void addToList(struct list *, char *);
void removeFromList(struct list *);
void walkList(struct list *);

#endif
