use vars qw(@ISA @EXPORT @EXPORT_OK);

use Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(info);


# Print information about the packets
sub info {

 if(defined($ethdev)) {
  print("Device: $ethdev  MAC-Source: $smac  MAC-Dest: $dmac\n");
 }

 print("Packet: $pcount from $saddr(port: $sport) to $daddr(port: $dport).");
 print("\nProtocol: $protocol  Type of Service(ToS): $tos  ID: $id\n");

 if(defined($generic)) {
  print("TTL: $ttl  Total Length: $tot  IHL: $ihl\n");
  print("Generic protocol data: $generic\n\n");
 } else {
   if($protocol==6) {
    print("Sequence number: $seq  Acknowledgement number: $ack_seq\n");
    print("Window size: $window  Urgent pointer: $urg_ptr  TTL: $ttl\n");
    print("Frag. offset: $frag_off  Data offset: $data_off  IHL: $ihl\n");
    print("Version: $version  Total Lenght: $tot  Data: \'$data\'\n");
    print("SYN=$SYN, ACK=$ACK, FIN=$FIN, RST=$RST, PSH=$PSH, URG=$URG\n\n");
   } elsif($protocol==17) {
    print("Fragmentation offset: $frag_off  IHL: $ihl\n");
    print("TTL: $ttl  Total Length: $tot  Data: \'$data\'\n\n");
   } elsif($protocol==1) {
    print("ICMP type: $icmptype  ICMP code: $icmpcode  Data: \'$data\'\n");
    print("MTU: $mtu  Gateway: $gateway  Sequence:  $seq\n");
    print("Fragmentation offset: $frag_off  IHL: $ihl\n\n");
  }
 }
}

1;
