use vars qw(@ISA @EXPORT @EXPORT_OK $VERSION);

use Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(help icmp_show error @error $error);

# Show help and exit...
sub help {

 my $error=shift;

$text_v="\nAPSEND v".$VERSION." - Programmed by Anarchy\n";

$here=<<EOF;
====================================
Usage:  APSEND -x
        APSEND -destination <dest ip> [options] <flags>/<attack>
	APSEND -listen <port> [options] <flags>
	APSEND -plugin <file> [options] <flags>

IP header:
 -s,   --source              <Source IP>            (default="127.0.0.1")
                                                    (0=random)
 -d,   --destination, --dest <Destination IP>
 -v,   --version             <IP version>           (default=4)
 -o,   --tos                 <Type of Service>      (default=0)
       --tot                 <Total Length>         (default=will be calculated)
       --id                  <Identification>       (default=0)
 -fo,  --frag-off, --frag    <Fragmentation Offset> (default=0x4000)
       --ttl                 <Time to Live>         (default=64)
       --protocol            <Protocol number>      (default=6/TCP)
       --ipcheck             <IP header checksum>   (default=will be calculated)
       --ihl                 <ihl>                  (default=5)

TCP header:
 -b,   --source-port, --sp   <TCP source port>      (default=random)
 -p,   --dest-port, --dp     <TCP destination port> (default=80)
 -rs                         Random TCP source port
 -rd                         Random TCP dest port
 -n,   --seq-num, --seq      <sequence number>      (default=0)
 -a,   --ack-num             <ACK number>           (default=0)
 -u,   --urg-ptr             <URG pointer>          (default=0)
 -do,  --data-off, --doff    <DATA offset>          (default=5)
 -res1                       reserved bit 1
 -res2                       reserved bit 2
 -w,   --window              <window size>          (default=0xffff)
 -tcheck                     <TCP checksum>         (default=will be calculated)

TCP flags:
 -ACK  set ACK flag          -PSH  set PSH flag
 -RST  set RST flag          -SYN  set SYN flag
 -URG  set URG flag          -FIN  set FIN flag

UDP header:
 -b,   --source-port, --sp   <UDP source port>      (default=random)
 -p,   --dest-port, --dp     <UDP destination port> (default=7)
 -rs                         Random UDP source port
 -rd                         Random UDP dest port
 -len                        <header/data length>   (default=will be calculated)
 -ucheck                     <UDP checksum>         (default=0, no calculation)
 
ICMP header:
 -g,   --gateway             <ICMP gateway>         (default=0)
 -iid, --icmp-id             <ICMP id>              (default=0)
 -icheck                     <ICMP checksum)        (default=will be calculated)
 -n,   --seq-num, --seq      <ICMP sequence number> (default=0)
 -mtu                        <ICMP mtu>             (default=0)
 -i,   --icmp-type           <ICMP type>            (default=8, Echo Request)
 -c,   --icmp-code           <ICMP code>            (default=0)
 -show                       Show ICMP types/codes

Ethernet frames:
       --eth-device          <device>
 -ems, --eth-mac-source      <MAC source address>   (default=00:00:00:00:00:00)
 -emd, --eth-mac-dest        <MAC dest address>     (default=00:00:00:00:00:00)
 -rems                       Random source MAC addr
 -remd                       Random dest   MAC addr
 
Generic protocols:
 --generic                   <header/data>          (default='')

Socket functions:
 -li,  --listen              <port>                 (use 0 for random port)
 -co,  --connect             <port>                 (use 0 for random port)
 -d,   --destination, --dest <Destination IP>       (only needed for --connect)
       --regex               <regular expression>   (use regex to get only the
						     data your regex matches)
       --nregex              <regular expression>   (like --regex, but print
                                                     only the data your regex
						     does NOT match)
 -sop, --socket-protocol     <protocol number>      (default=6/TCP)
 
Other Options:
 -h,   --help, -?            Show this help
 -f,   --file                <script file>          (not implemented)
       --plugin              <file>                 (plugin file)
 -m,   --number              number of packets      (default=1)
                             to send                (0=unlimited)
 -q,   --quiet               Quiet mode
 -y,   --data                <data to send>         (default='')
                                                    (also for --connect)
 -x                          Show network devices and exit

Attacks:
 -sf,  --syn-flood, --flood  SYN flood
       --land                Land attack (=DoS attack aggainst WIN9x and
                             possibly others like WIN NT and Linux/Unix.)
                             The source port must be the same as the
                             destination port. If not I will autoset it.
       --stream              Stream attack (default src/dest port: 22)
 -bd,  --be-dos, --bed       BeOS DoS attack
 -td,  --tcp-dos, --tcpd     DoS attack against tcpdump 3.4a running on
                             a UNIX based system.
 -uf,  --udp-flood           UDP flood. This can crash an ascend router
                             for example (use port 7 (echo)) to do this.
 -pf,  --ping-flood          ICMP Ping flood
 
Default number of packets for land/tcpdump attack: 1
Default number of packets for SYN flood/UDP flood/stream attack: 0 [=loop] !
If you select attack mode, most of the other flags will be ignored !
You can only select one attack at once !

EOF

  $text_v.=$here;
  print $text_v;
  if(defined($error)) { print("Error: $error[$error-1]\n\n") }
   else { $error=0 }
  exit($error);
}


# Show the ICMP types/codes and exit...
sub icmp_show {

$here=<<"EOF";
====================================

ICMP-Types (standard icmp-numbers):

 0:  Echo Reply                      11: Time Exceed        <code>
 1:  Unassigned                      12: Parameter Problem  <code>
 2:  Unassigned                      13: Timestamp
 3:  Destination Unreachable <code>  14: Timestamp reply
 4:  Source Quench                   15: Information request
 5:  Redirect                <code>  16: Information reply
 6:  Alternate Host Address          17: Address Mask request
 7:  Unassigned                      18: Address Mask reply
 8:  Echo                            19: reserved (for security)
 9:  Router Advertisement            20-29: reserved (for Robustness Experiment)
 10: Router Selection                30: Traceroute

ICMP-Codes (standard icmp-numbers):

 Type : 3
 Codes: 0  Net unreachable
        1  Host unreachable
        2  Protocol unreachable
        3  Port unreachable
        4  Fragmentation needed and Don't Fragment was set
        5  Source route failed
        6  Destination network unknown
        7  Destination host unknown
        8  Source host isolated
        9  Communication with dest. network is administratively prohibited
        10 Communication with dest. host is administratively prohibited
        11 Destination Network Unreachable for Type of Service
        12 Destination Host Unreachable for Type of Service
        13 Communication Administratively Prohibited
        14 Host Precedence Violation
        15 Precedence cutoff in effect

Type : 5
Codes: 0  Redirect Datagram for the Network (or subnet)
       1  Redirect Datagram for the Host
       2  Redirect Datagram for the Type of Service and Network
       3  Redirect Datagram for the Type of Service and Host

Type : 11
Codes: 0  Time to Live exceeded in Transit
       1  Fragment Reassembly Time Exceeded

Type : 12
Codes: 0  Pointer indicates the error
       1  Missing a Required Option
       2  Bad Length

EOF

  $text_v.=$here;
  print $text_v;
  exit(0);
}

1;
