use vars qw(@ISA @EXPORT @EXPORT_OK);

use Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(construct);


# So let's construct the packet(s) now...
sub construct {

 if($protocol!=1) {
  $packet=new Net::RawIP;
 } else {
  $packet=new Net::RawIP ({icmp =>{}});
 }

 # Thanks to Christian Krmer
 if($protocol==17) {
  $packet=new Net::RawIP({udp =>{}});
 }

 # Check if anyone wants an ethernet frame...
 if(defined($ethdev)) {
  $packet->ethnew($ethdev);
  $packet->ethset(source => $smac, dest => $dmac);
 }

 # Random source IP ?
 if($rsip==1) { rand_ip() }

 # Random source/dest port ?
 if($rsport==1 || $rdport==1) { rand_port() }


 # Set the IP header...
 $packet->set({ip =>  { saddr    => $saddr,
                        daddr    => $daddr,
                        version  => $version,
                        ihl      => $ihl,
                        tos      => $tos,
                        tot_len  => $tot,
                        id       => $id,
                        frag_off => $frag_off,
                        ttl      => $ttl,
                      } });

 if(!defined($generic)) { $packet->set({ip => { protocol => $protocol } }) }

 # IP checksum
 if(defined($ipcheck)) { $packet->set({ip => { check => $ipcheck } }) }

 # Packet is a generic packet if $generic is defined...
 if(defined($generic)) {
  $packet->set({generic => { data => $data } });
  $protocol="undef";
 } else {

  # Set the transport layer protocols like TCP/UDP/ICMP...
  # ICMP header
  if($protocol==1) {
   $packet->set({icmp => { type     => $icmptype,
                           code     => $icmpcode,
                           gateway  => $gateway,
                           id       => $iid,
			   sequence => $seq,
			   mtu      => $mtu,
			   data     => $data
                         } });
   if(defined($icheck)) { $packet->set({icmp => { check => $icheck } }) }
  }

  # TCP header
  if($protocol==6) {
   $packet->set({tcp  => { source => $sport,
                           dest   => $dport,
                           seq    => $seq,
                           doff   => $data_off,
                           window => $window,
                           ack_seq=> $ack_seq,
                           urg_ptr=> $urg_ptr,
                           fin    => $FIN,
                           syn    => $SYN,
                           rst    => $RST,
                           psh    => $PSH,
                           ack    => $ACK,
                           urg    => $URG,
                           data   => $data,
                           res1   => $res1,
                           res2   => $res2
                         }
               }) ;
   if(defined($tcheck)) { $packet->set({tcp => { check => $tcheck } }) }	     
  }

  # UDP header
  if($protocol==17) {
   $packet->set({udp  => { source => $sport,
                           dest   => $dport,
			   len    => $len,
			   data   => $data
                         }
               });
   if(defined($ucheck)) { $packet->set({udp => { check => $ucheck } }) }
  }	     
 }

 if($count==0) { $count=1; $set_count=1 }

 # Here we start the main loop...:)
 for($icount=0;$icount<$count;$icount++) {
  $pcount++;     # Packet counter
 
  # Let's call rand_set to generate random values...
  rand_set();
  if($set_count==1) { $icount-- }           # Loop?

  if(!defined($quiet)) {                    # Quiet mode?
   info();
  }

  if(defined($ethdev)) {
   $packet->ethsend();                         # Send the packet (eth frame)
  } else {
     $packet->send();                          # Send the packet...
  }
 
 }

 # No more packets to send...
 exit(0);

}

1;
