#include <bios.h>
#include <stdio.h>

#define secteur_size		512

#define CMD_W		3
#define CMD_V		4
#define DRIVE  	0
#define HEAD   	0
#define TRACK  	0
#define SECT   	1
#define NSECT  	1

void main (int argc, char *argv[])
{
	FILE *fin;
	char secteur[secteur_size] = "";

	if(argc!=2){
		printf("USAGE : rawthat [FICHIER A INSCRIRE]");
		return;
	}

	if((fin = fopen(argv[1],"r")) == NULL){
		printf("Veuillez fournir un nom de fichier existant.");
		return;
	}

	if(fread(&secteur,secteur_size - 1,NSECT,fin) != 1){
		printf("Impossible de lire a partir du fichier.");
		return;
	}

	printf("Ecriture du secteur ... ");

	if(biosdisk(CMD_W,DRIVE,HEAD,TRACK,SECT,NSECT,secteur) != 0x00){
		printf("Erreur lors de l'accs au disque.");
		return;
	}

	printf("OK.");

	fclose(fin);

	return;
}