#include <windows.h>

#include "resource.h"
#include "MD5.h"

LRESULT CALLBACK MDlgproc (HWND,UINT,WPARAM,LPARAM);

HINSTANCE hInst = NULL;

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	MSG msg;
	WNDCLASSEX dlgclass;

	hInst = hInstance;

	dlgclass.cbSize = sizeof(WNDCLASSEX);
	dlgclass.style = CS_HREDRAW | CS_VREDRAW;
	dlgclass.lpfnWndProc = (WNDPROC) MDlgproc;
	dlgclass.cbClsExtra = NULL;
	dlgclass.cbWndExtra = DLGWINDOWEXTRA;
	dlgclass.hInstance = hInst;
	dlgclass.hbrBackground = (HBRUSH)COLOR_BTNFACE+1;
	dlgclass.lpszMenuName = NULL;
	dlgclass.lpszClassName = "DLGCLASS";
	RegisterClassEx(&dlgclass);

	if(!CreateDialogParam(hInst,MAKEINTRESOURCE(IDD_MAIN),NULL,(DLGPROC)MDlgproc,NULL)){
		MessageBox(NULL,"CreateDialogParam()","Erreur",0);
		return 0;
	}
	
	while(GetMessage(&msg,NULL,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}


LRESULT CALLBACK MDlgproc (HWND hDlg,UINT uMsg,WPARAM wParam, LPARAM lParam)
{
char motdepasse[100];
unsigned char digest[16];
unsigned char final[50];

int i=0,j=0,x1=0,x2=0,longeur;

	switch(uMsg)
	{
		case WM_INITDIALOG:
			break;
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_BTHASH:
					GetDlgItemText(hDlg,IDC_TXTMDP,motdepasse,100);
					if((longeur=strlen(motdepasse))>8){
						MessageBox(hDlg,"Mot de passe trop long (maxi. 8).","Erreur",0);
						break;
					} else if(longeur<4){
						MessageBox(hDlg,"Mot de passe trop court (mini. 4).","Erreur",0);
						break;
					}

					StrMD5((unsigned char*)motdepasse,digest);	

					for(i=0;i<16;i++){
						x1 = x2 = digest[i];
						
						x1 >>= 4;
						x1 += 65;

						x2 &= 15;
						x2 += 65;

						final[j] = x1;
						j++;
						final[j] = x2;						
						j++;
					}

					final[j] = 0;

					SetDlgItemText(hDlg,IDC_TXTRESULT,(const char*)final);
					break;
				default:
					break;
			}
			break;
		case WM_CLOSE:
			PostQuitMessage(0);
			break;
		default:
			return false;
	}
	return true;
}