/******************************************************************************
 *                        structures.h by S/ash [RtC]                         *
 *                        RtC Scan : a network mapper                         *
 *                   contain several structures definition                    *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#ifndef __RTCSCAN_STRUCTURES_H__
#define __RTCSCAN_STRUCTURES_H__

/*
 * struct ip_list : used for listing ips
 */
struct ip_list
{
  int      state;
  char*    name;
  uint32_t ip;
  struct ip_list *next;
};

/*
 * struct port_result : used to return result of a port scan
 */
struct port_result
{
  int   state;
  int   scanport;
  char *service;
};

/*
 * struct port_list_file : used for port list files
 */
struct port_list_file
{
  FILE *file;
  char *curline;
  long  curport;
  long  maxport;
  int   readservices;
  int   proto;
};

/*
 * struct ip_list_file : used for ip list files
 */
struct ip_list_file
{
  FILE          *file;          /* the file               */
  unsigned char  maxip[4];      /* the current max ip     */
  unsigned char  minip[4];      /* the current min ip     */
  unsigned char  curip[4];      /* the current ip         */
  char          *name;          /* hostname to display    */
  char          *curcomment;    /* the current commentary */
};

#endif
