/******************************************************************************
 *                          str.fr.h by S/ash [RtC]                           *
 *                        RtC Scan : a network mapper                         *
 *             Contient les chaines d'interface (version franaise)           *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#ifndef __RTCSCAN_STR_H__
#define __RTCSCAN_STR_H__


/* chaines d'erreur */
#define PORTLIST_ERROR              "erreur : la liste des ports a un format incorrect.\n"
#define IPLIST_ERROR                "erreur : la liste des ip a un format incorrect\n"
#define OPENPORTFILE_ERROR          "erreur  l'ouverture du fichier liste de ports %s.\n"
#define OPENIPFILE_ERROR            "erreur  l'ouverture du fichier liste d'ip %s.\n"
#define OPENOFILE_ERROR             "erreur  l'ouverture du fichier de sortie %s.\n"
#define IPSTR_INVALID               "erreur : chane ip invalide\n"
#define INADDR_ERROR                "Problme de connection  l'hte %s.\n"
#define ICMPRAW_SOCK_ERROR          "erreur : ne peut crer de raw socket ICMP\n"\
                                    "         ncessaire pour tester si l'hte est connect\n"
#define TCPRAW_SOCK_ERROR           "erreur : ne peut crer de raw socket TCP\n"\
                                    "         ncessaire aux scannings SYN et Stealth\n"
#define TCPSTREAM_SOCK_ERR          "erreur : ne peut crer de socket TCP en mode flux\n"\
                                    "         ncessaire aux scannings Complete-TCP et FTP Bounce\n"
#define UDPRAW_SOCK_ERROR           "erreur : ne peut crer de raw socket UDP\n"\
                                    "         ncessaire au scanning UDP\n"
#define UDPDGRAM_SOCK_ERR           "erreur : ne peut crer de socket datagram UDP\n"\
                                    "         ncessaire au scanning UDP (lame)\n"
#define IPRAW_SOCK_ERROR            "erreur : ne peut crer de raw socket\n"\
                                    "         ncessaire aux scannings SYN et Stealth\n"
#define CANTFINDLOCALHOST           "erreur : localhost introuvable.\n"
#define CANTWRITEIPHDR              "erreur : Impossible d'crire les en-ttes IP.\n"
#define PACKETSIZE_INCORRECT        "erreur : la taille du paquet doit tre entre " MIN_PACKETSIZESTR " et " MAX_PACKETSIZESTR "\n"
#define FTP_CONNECTREFUSED_ERROR    "\nerreur : l'hte FTP a refus la connexion\n"
#define FTP_CONNECTERROR_ERROR      "\nerreur : problmes de connection au FTP\n"
#define FTP_USERREFUSED_ERROR       "\nerror : login/pass FTP refuss\n"
#define FTP_UNKNOWANSWER_ERROR      "\nerreur : rponse inconnue venant du FTP (tes-vous sr qu'il s'agit d'un FTP ?)\n"
#define FTP_PORTREFUSED_ERROR       "\nerreur : la commande PORT a t refuse\n"\
                                      "         cet hte FTP ne doit pas accepter les commandes PORT trafiques\n"


/* interface strings */
#define COMMENT_LINE       "# "

#define FTP_HOSTNAME       "Recherche du nom d'hte FTP %s "
#define FTP_HOSTIP         "(%s)\n"
#define FTP_CONNEXION      "Connexion au FTP... "
#define FTP_CONNECTED      "ok\n"

#define BEGIN_SCANNING     "\nBalayage de l'hte %s"
#define HOST_COMMENT       " (%s)"
#define HOST_IP            "Adresse IP : %s... "
#define HOST_UPSTR         "Up...\n"
#define HOST_DOWNSTR       "il semble etre down...\n"

#define UDP_SCAN_MSG       "Balayage des ports UDP "
#define TCP_SCAN_MSG       "Balayage des ports TCP "
#define ECHO_SCAN_MSG      "Balayage des htes connects\n"
#define UDP_LAME_SCAN_MSG  "(lame)\n"
#define UDP_FAST_SCAN_MSG  "(classique)\n"
#define TCP_COMP_SCAN_MSG  "(connexion complete)\n"
#define TCP_SYN_SCAN_MSG   "(SYN)\n"
#define TCP_FIN_SCAN_MSG   "(Furtif : FIN)\n"
#define TCP_ACK_SCAN_MSG   "(Furtif : ACK)\n"
#define TCP_FTP_SCAN_MSG   "(FTP bounce attack)\n"
#define LOCALHOST_SCAN_MSG "localhost : %s\n"

#define SCAN_HEAD_LINE     " Port        Etat               Service\n"
#define PORT_OPEN           "%5ld        ouvert             %s\n"
#define PORT_CLOSED         "%5ld        ferm              %s\n"
#define PORT_TIMEDOUT       "%5ld        time out           %s\n"
#define PORT_ERROR          "%5ld        rponse inconnue   %s\n"

#define ECHO_HOST_UP       "connect\n"
#define ECHO_HOST_TIMEDOUT "a dpass les dlais d'attente\n"
#define ECHO_HOST_UNREACH  "ne peut tre atteint\n"

#define PROMPT_NEXTHOST    "Appuyez sur entr pour passer  l'hte suivant..."
#define SCAN_COMPLETED     "\nScan termin (%d hte(s)) en %d ms...\n"

#define INFOSTR            "RtC Scan " VER_STR " : a network mapper\n"\
                           "  A RtC Tech Software, part of the RtC Neset Project\n"\
                           "  RtC    : http://www.rtc.fr.st  -  rtc@fr.st\n"\
                           "  Auteur : S/ash <slash-rtc@fr.st>\n\n"

#define INFOSTRFILE        "# RtC Scan " VER_STR " : a network mapper\n"\
                           "#   A RtC Tech Software, part of the RtC Neset Project\n"\
                           "#   RtC    : http://www.rtc.fr.st  -  rtc@fr.st\n"\
                           "#   Auteur : S/ash <slash-rtc@fr.st>\n\n"

#define SHORTSYNTAXSTR     "syntaxe : %s [options] {-l iplist | ip}\n"\
                           "          ip     : ip  scanner (y compris les masques ip comme 12.3.2-7.*)\n"\
                           "          iplist : fichier contenant la liste des ip  scanner\n"\
                           "tapez %s -? pour plus d'information\n"
                          
#define SYNTAXSTR          "syntaxe : %s [options] {-l iplist | ip}\n"\
                           "          ip     : ip  scanner (y compris les masques ip comme 12.3.[2-7].*)\n"\
                           "          iplist : fichier contenant la liste des ip  scanner\n"\
                           "les options sont :\n"\
                           "  -s : choix de la mthode de scan. Les mthodes disponibles sont :\n"\
                           "     -sS : scanning  demi-ouverture de port (SYN)\n"\
                           "     -sT : scanning TCP  connexion complte : par dfaut\n"\
                           "     -sF : scan furtif (FIN)                   -sA : scan furtif (ACK)\n"\
                           "     -sB host : FTP Bounce scan utilisant host -sE : ICMP Echo scanning\n"\
                           "     -sU : UDP scanning (classique)            -su : UDP scanning (lame)\n"\
                           "  -f : scan lents (pour les methodes S, F, A, E, U)\n"\
                           "  -d dlai : tablit le dlai entre chaque connexion (def : " DEFDELAY_STR " ms)\n"\
                           "  -i ip : donne votre IP pour les scans SYN, furtifs et UDP (classique)\n"\
                           "  -u : dsactive le test de l'hte avant de faire le scan\n"\
                           "  -t timeout : tablit le time out (def : " DEFTIMEOUT_STR " ms)\n"\
                           "  -r scan_port : tablit le numro de port  utiliser (def : " DEFSTCP_PORT_STR ")\n"\
                           "  -H A-B : numro de port  utiliser choisi au hasard entre A et B\n"\
                           "  -m A-B : test tout les ports compris entre A et B\n"\
                           "  -p file : test les ports contenu dans le fichier file (def : /etc/services)\n"\
                           "  -T tries : rgle le nombre d'essai pour les mthodes E et B (def : " DEFAULT_TRIESSTR ")\n"\
                           "  -S packetsize : rgle la taille d'un paquet (mthode E) (def : " DEFAULT_PACKETSIZESTR ")\n"\
                           "  -o file : loggue les rsultats dans le fichier file\n"\
                           "  -h user pass : donne les paramtres de connexion pour la mthode B (def : " DEFFTP_LOGIN "/" DEFFTP_PASS ")\n"\
                           "  -R port : donne le port FTP  utiliser (def : " DEFSFTP_PORT_STR ")\n"\
                           "  -a : montre tout les rsultats (mme pour les ports ferm ou les hte down)\n"\
                           "  -e : n'affiche pas les rsultats sur stdout\n"\
                           "  -n : attend avant le scan de chaque nouvel hte\n"\
                           "  -? : affiche cet cran d'aide\n"\
                           "Les options -p et -m sont incompatibles.\n"


#endif
