/******************************************************************************
 *                          str.en.h by S/ash [RtC]                           *
 *                        RtC Scan : a network mapper                         *
 *                  contain interface strings (English version)               *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#ifndef __RTCSCAN_STR_H__
#define __RTCSCAN_STR_H__


/* error strings */
#define PORTLIST_ERROR              "error : port list file have invalid format.\n"
#define IPLIST_ERROR                "error : IP list file have invalid format\n"
#define OPENPORTFILE_ERROR          "error opening the port list file %s.\n"
#define OPENIPFILE_ERROR            "error opening the ip list file %s.\n"
#define OPENOFILE_ERROR             "error opening output file %s.\n"
#define IPSTR_INVALID               "error : invalid ip string\n"
#define INADDR_ERROR                "Connection problem for host %s.\n"
#define ICMPRAW_SOCK_ERROR          "error : couldn't get ICMP raw socket\n"\
                                    "        needed for seeing if host is up\n"
#define TCPRAW_SOCK_ERROR           "error : couldn't get TCP raw socket\n"\
                                    "        needed for SYN and stealth scanning\n"
#define TCPSTREAM_SOCK_ERR          "error : couldn't get TCP stream socket\n"\
                                    "        needed for Complete-TCP and FTP Bounce scanning\n"
#define UDPRAW_SOCK_ERROR           "error : couldn't get UDP raw socket\n"\
                                    "        needed for UDP scanning\n"
#define UDPDGRAM_SOCK_ERR           "error : couldn't get UDP datagram socket\n"\
                                    "        needed for UDP (lame) scanning\n"
#define IPRAW_SOCK_ERROR            "error : couldn't get raw socket\n"\
                                    "        needed for SYN and stealth scanning\n"
#define CANTFINDLOCALHOST           "error : cannot find localhost.\n"
#define CANTWRITEIPHDR              "error : couldn't write ip header.\n"
#define PACKETSIZE_INCORRECT        "error : packet size must be between " MIN_PACKETSIZESTR " and " MAX_PACKETSIZESTR "\n"
#define FTP_CONNECTREFUSED_ERROR    "\nerror : FTP host have refused connection\n"
#define FTP_CONNECTERROR_ERROR      "\nerror : connection problems to FTP host\n"
#define FTP_USERREFUSED_ERROR       "\nerror : FTP user/pass refused\n"
#define FTP_UNKNOWANSWER_ERROR      "\nerror : unknow answer from FTP host (are you sure it's a FTP ?)\n"
#define FTP_PORTREFUSED_ERROR       "\nerror : PORT command was refused\n"\
                                      "        This FTP serveur must don't accept bogus PORT command\n"

/* interface strings */
#define COMMENT_LINE       "# "

#define FTP_HOSTNAME       "Resolving FTP host name %s "
#define FTP_HOSTIP         "(%s)\n"
#define FTP_CONNEXION      "Connecting to FTP host... "
#define FTP_CONNECTED      "ok\n"

#define BEGIN_SCANNING     "\nScanning host %s"
#define HOST_COMMENT       " (%s)"
#define HOST_IP            "IP Address : %s... "
#define HOST_UPSTR         "Up...\n"
#define HOST_DOWNSTR       "Seems to be down...\n"

#define UDP_SCAN_MSG       "Scanning for UDP ports "
#define TCP_SCAN_MSG       "Scanning for TCP ports "
#define ECHO_SCAN_MSG      "Scanning for hosts up\n"
#define UDP_LAME_SCAN_MSG  "(lame)\n"
#define UDP_FAST_SCAN_MSG  "(classic)\n"
#define TCP_COMP_SCAN_MSG  "(complete connection)\n"
#define TCP_SYN_SCAN_MSG   "(SYN)\n"
#define TCP_FIN_SCAN_MSG   "(stealth : FIN)\n"
#define TCP_ACK_SCAN_MSG   "(stealth : ACK)\n"
#define TCP_FTP_SCAN_MSG   "(FTP bounce attack)\n"
#define LOCALHOST_SCAN_MSG "localhost : %s\n"

#define SCAN_HEAD_LINE     " Port        State           Service\n"
#define PORT_OPEN           "%5ld        open            %s\n"
#define PORT_CLOSED         "%5ld        close           %s\n"
#define PORT_TIMEDOUT       "%5ld        time out        %s\n"
#define PORT_ERROR          "%5ld        unknow answer   %s\n"

#define ECHO_HOST_UP       "up\n"
#define ECHO_HOST_TIMEDOUT "timed out (must be down)\n"
#define ECHO_HOST_UNREACH  "unreachable (must don't exist)\n"

#define PROMPT_NEXTHOST    "Press enter to proceed to next host..."
#define SCAN_COMPLETED     "Scanning completed (%d host(s)) in %d ms...\n"

#define INFOSTR            "RtC Scan " VER_STR " : a network mapper\n"\
                           "  A RtC Tech Software, part of the RtC Neset Project\n"\
                           "  RtC    : http://www.rtc.fr.st  -  rtc@fr.st\n"\
                           "  Author : S/ash <slash-rtc@fr.st>\n\n"

#define INFOSTRFILE        "# RtC Scan " VER_STR " : a network mapper\n"\
                           "#   A RtC Tech Software, part of the RtC Neset Project\n"\
                           "#   RtC    : http://www.rtc.fr.st  -  rtc@fr.st\n"\
                           "#   Author : S/ash <slash-rtc@fr.st>\n\n"

#define SHORTSYNTAXSTR     "syntax : %s [options] {-l iplist | ip}\n"\
                           "         ip     : ip to scan\n"\
                           "         iplist : file containing iplist to scan\n"\
                           "see %s -? for more information\n"
                          
#define SYNTAXSTR          "syntax : %s [options] {-l iplist | ip}\n"\
                           "         ip     : ip to scan (including ip mask like 12.3.[2-7].*)\n"\
                           "         iplist : file containing iplist to scan\n"\
                           "options are :\n"\
                           "  -s : choose scanning method. methods avaible are :\n"\
                           "     -sS : half-open scanning (SYN)\n"\
                           "     -sT : complete TCP connection scanning : default\n"\
                           "     -sF : stealth scanning (FIN)              -sA : stealth scanning (ACK)\n"\
                           "     -sB : FTP Bounce scanning using host      -sE : ICMP Echo scanning\n"\
                           "     -sU : UDP scanning (classic)              -su : UDP scanning (lame)\n"\
                           "  -f : slow scan (methods S, F, A, E, U)\n"\
                           "  -d delay : set the delay (def : " DEFDELAY_STR " ms)\n"\
                           "  -i ip : give your ip for SYN, stealth and UDP (classic) scanning\n"\
                           "  -u : disable testing for host up before scanning\n"\
                           "  -t timeout : set the time out (def : " DEFTIMEOUT_STR " ms)\n"\
                           "  -r scan_port : set the scan port (def : " DEFSTCP_PORT_STR ")\n"\
                           "  -H A-B : random scan port between A and B\n"\
                           "  -m A-B : check all ports between A and B.\n"\
                           "  -p file : check ports contained in file (def : /etc/services)\n"\
                           "  -T tries : set the number of tries to make for E & B methods (def : " DEFAULT_TRIESSTR ")\n"\
                           "  -S packetsize : set the packet size for E method (def : " DEFAULT_PACKETSIZESTR ")\n"\
                           "  -o file : put result in file\n"\
                           "  -h user pass : set connection params for B method (def : " DEFFTP_LOGIN "/" DEFFTP_PASS ")\n"\
                           "  -R port : give FTP port to use (def : " DEFSFTP_PORT_STR ")\n"\
                           "  -a : show all data (even port close or host down)\n"\
                           "  -e : don't display result in stdout\n"\
                           "  -n : prompt before scanning each new host\n"\
                           "  -? : show this help screen\n"\
                           "The options -p and -m are incompatibles.\n"

#endif
