/******************************************************************************
 *                         rtcscan.c by S/ash [RtC]                           *
 *                        RtC Scan : a network mapper                         *
 *                        contain scannings functions                         *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/
#include "rtcscan.h"

/******************************************************************************
 * Function rtcscan  : process the scan                                       *
 * Input  : sm       : scanning method                                        *
 *          fastscan : use fast methods ?                                     *
 *          delay    : the delay between sent                                 *
 *          isupuse  : use isup() ?                                           *
 *          timeout  : set the time out                                       *
 *          sport    : port to use for scanning                               *
 *          smaxport : max port to use for scanning (0 if not at random)      *
 *          plf      : the port list file                                     *
 *          minport  : scan from minport                                      *
 *          maxport  : to maxport                                             *
 *          ilf      : ip list file                                           *
 *          tries    : number of tries to make for E scan                     *
 *          pcksize  : size of packets sent for E scan                        *
 *          ftphost  : FTP host for B scan                                    *
 *          ftpuser  : FTP username for B scan                                *
 *          ftppass  : FTP password for B scan                                *
 *          ftpport  : FTP port fot B scan                                    *
 *          ownip    : localhost ip for root scans                            *
 *          showall  : show all results (even down results) ?                 *
 *          echo     : echo on output ?                                       *
 *          prompt   : prompt before scanning each new host ?                 *
 *          f        : out file                                               *
 * Note : this is the really true main function !!                            *
 * I code it for the second time because of a stupid accident in archiving    *
 * RtC Scan (replace c by x in tar options), and i'm very angry :-(           * 
 ******************************************************************************/
void rtcscan(int sm, int fastscan, int delay, int isupuse, int timeout, int sport,
	     int smaxport, struct port_list_file *plf, int minport, int maxport,
	     struct ip_list_file *ilf, int tries, int pcksize, char *ftphost,
	     char *ftpuser, char *ftppass, int ftpport, char *ownip, int showall,
	     int echo, int prompt, FILE *f)
{
  struct timeval v1, v2;
  int nb_host;
  print_begin_msg(f); /* prosperity :-) */
  gettimeofday(&v1, NULL);
  if(sm==METHOD_B)
    nb_host = ftpscan(ftphost, ftpuser, ftppass, ftpport, plf, minport, maxport, ilf,
		      tries, showall, echo, prompt, f);
  else if(sm==METHOD_E)
    nb_host = ipscan(fastscan, delay, timeout, ilf, tries, pcksize, showall, echo, f);
  else nb_host = portscan(sm, fastscan, delay, isupuse, timeout, sport, smaxport, plf,
			  minport, maxport, ilf, ownip, showall, echo, prompt, f);
  gettimeofday(&v2, NULL);
  print_scan_finished(nb_host, DIFFTIME(v1,v2), f, echo, sm==METHOD_E);
}

/******************************************************************************
 * Function portscan : process a port scan                                    *
 * Input  : sm       : scanning method                                        *
 *          fastscan : use fast methods ?                                     *
 *          delay    : the delay between sent                                 *
 *          isupuse  : use isup() ?                                           *
 *          timeout  : set the time out                                       *
 *          sport    : port to use for scanning                               *
 *          smaxport : max port to use for scanning (0 if not at random)      *
 *          plf      : the port list file                                     *
 *          minport  : scan from minport                                      *
 *          maxport  : to maxport                                             *
 *          ilf      : ip list file                                           *
 *          ownip    : localhost ip for root scans                            *
 *          showall  : show all results (even down results) ?                 *
 *          echo     : echo on output ?                                       *
 *          prompt   : prompt before scanning each new host ?                 *
 *          f        : out file                                               *
 * Output : nb_host  : number of host scanned                                 *
 * I'm still angry :-(, j'en ai marrrrrrrrreee !!                             * 
 ******************************************************************************/
int portscan(int sm, int fastscan, int delay, int isupuse, int timeout, int sport,
	     int smaxport, struct port_list_file *plf, int minport, int maxport,
	     struct ip_list_file *ilf, char *ownip, int showall,
	     int echo, int prompt, FILE *f)
{
  struct port_result portv[SIZEOF_PORTV];
  int r, nb_host = 0;
  int isfirstloop = 1;
  struct sockaddr_in host;
  init_port_result(portv);
  do {
    if(isfirstloop) isfirstloop = 0;
    else if(prompt) prompt_next_host();
    if(plf->file || plf->readservices) rst_port_file(plf);
    else
      {
	plf->curport = minport-1;
	plf->maxport = maxport;
	plf->curline = NULL;
      }
    nb_host++;
    print_host_info(ilf->name, ilf->curcomment, inet_to_inaddr(ilf->curip), echo, f);
    if((sm!=METHOD_u) && (sm!=METHOD_T))
      {
	r = get_localhost(inet_to_inaddr(ilf->curip), ownip, timeout, isupuse);
	if(r<0)
	  {
	    fprintf(stderr, "\n" CANTFINDLOCALHOST);
	    exit(-1);
	  }
      }
    else r = HOST_NODISP;
    print_host_state(r!=HOST_NODISP, isupuse ? r : HOST_NODISP, echo, f);
    if(r!=HOST_DOWN)
      {
	print_scan_methods(sm, echo, f);
	host.sin_addr   = inet_to_inaddr(ilf->curip);
	host.sin_family = AF_INET;
	udptcp_scan_ports(plf, &host, sm, fastscan, sport, smaxport, timeout, delay, portv);
	print_port_result(portv, f, echo, showall);
      }

  } while(!(r=get_next_ip(ilf)));
  if(r<0) exit(-1);
  return nb_host;
}


/******************************************************************************
 * Function ipscan   : process the ip scan                                    *
 * Input  : fastscan : use fast methods ?                                     *
 *          delay    : the delay between sent                                 *
 *          timeout  : set the time out                                       *
 *          ilf      : ip list file                                           *
 *          tries    : number of tries to make for E scan                     *
 *          pcksize  : size of packets sent for E scan                        *
 *          showall  : show all results (even down results) ?                 *
 *          echo     : echo on output ?                                       *
 *          f        : out file                                               *
 * Output : nb_host  : number of host scanned                                 *
 ******************************************************************************/
int ipscan(int fastscan, int delay, int timeout, struct ip_list_file *ilf,
	   int tries, int pcksize, int showall, int echo, FILE *f)
{
  int r, sock, nb_host = 0;
  struct ip_list* ipl = NULL;
  struct in_addr adr;
  sock = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP);
  fcntl(sock, F_SETFL, fcntl(sock, F_GETFL) | O_NONBLOCK);
  
  print_scan_methods(METHOD_E, echo, f);
  do {
    nb_host++;
    adr = inet_to_inaddr(ilf->curip);
    if(fastscan)
      {
	echo_fscan_host(adr, tries, pcksize, delay);
	add_ip(&ipl, ilf->name, adr, HOST_TIMEDOUT);
	r = scan_for_pong(sock, &adr, timeout);
	if(r<3)
	  set_ip(ipl, adr, r);
      }
    else 
      {
	r = echo_scan_host(adr, tries, pcksize, timeout);
	if(r!=3)
	  add_ip(&ipl, ilf->name, adr, r);
      }
    usleep(delay*1000);
  } while(!(r=get_next_ip(ilf)));
  if(r<0) exit(-1);
  if(fastscan) /* waiting for answer */
    while((r=scan_for_pong(sock, &adr, timeout)) != HOST_TIMEDOUT)
      if(r<3) set_ip(ipl, adr, r);
  print_iplist(ipl, f, echo, showall);
  free_iplist(ipl);
  return nb_host;
}

/******************************************************************************
 * Function ftpscan : process a port scan using ftp bounce attack             *
 * Input  : ftphost    : ftp host to use as a proxy                           *
 *          user, pass : user and password for ftp host                       *
 *          ftpport    : port to use for ftp connexion                        *
 *          plf        : the port list file                                   *
 *          minport    : scan from minport                                    *
 *          maxport    : to maxport                                           *
 *          ilf        : ip list file                                         *
 *          tries      : number of tries...                                   *
 *          showall    : show all results (even down results) ?               *
 *          echo       : echo on output ?                                     *
 *          prompt     : prompt before scanning each new host ?               *
 *          f          : out file                                             *
 * Output : nb_host  : number of host scanned                                 *
 * Je suis plus calme maintenant :-)                                          * 
 ******************************************************************************/
int ftpscan(char *ftphost, char *user, char *pass, int ftpport,
	    struct port_list_file *plf, int minport, int maxport,
	    struct ip_list_file *ilf, int tries, int showall,
	     int echo, int prompt, FILE *f)
{
  struct port_result portv[SIZEOF_PORTV];
  int sock, r, nb_host = 0;
  int isfirstloop = 1;
  struct in_addr host, current;
  init_port_result(portv);

  /* connexion to ftp host */
  if(echo) printf(FTP_HOSTNAME, ftphost);
  if(f) fprintf(f, FTP_HOSTNAME, ftphost);
  host = resolve(ftphost);
  if(host.s_addr==INADDR_NONE)
    {
      fprintf(stderr, INADDR_ERROR, ftphost);
      exit(-1);
    }
  if(echo) printf(FTP_HOSTIP, inet_ntoa(host));
  if(f) fprintf(f, FTP_HOSTIP, inet_ntoa(host));
  if(echo) printf(FTP_CONNEXION);
  if(f) fprintf(f, FTP_CONNEXION);
  sock = ftp_connect(host, user, pass, ftpport);
  if(sock<0)
    {
      fflush(stdout);
      if(sock==-1) fprintf(stderr, FTP_CONNECTREFUSED_ERROR);
      else if(sock==-2) fprintf(stderr, FTP_USERREFUSED_ERROR);
      else fprintf(stderr, FTP_CONNECTERROR_ERROR);
      exit(-1);
    }
  if(echo) printf(FTP_CONNEXION);
  if(f) fprintf(f, FTP_CONNEXION);
  /* connexion completed */

  do {
    if(isfirstloop) isfirstloop = 0;
    else if(prompt) prompt_next_host();
    if(plf->file || plf->readservices) rst_port_file(plf);
    else
      {
	plf->curport = minport-1;
	plf->maxport = maxport;
	plf->curline = NULL;
      }
    nb_host++;
    print_host_info(ilf->name, ilf->curcomment, inet_to_inaddr(ilf->curip), echo, f);
    print_host_state(0, HOST_NODISP, echo, f);
    print_scan_methods(METHOD_B, echo, f);
    current   = inet_to_inaddr(ilf->curip);
    r = ftp_scan_ports(sock, current, tries, plf, portv);
    if(r<0)
      {
	fflush(stdout);
	if(r==-1) fprintf(stderr, FTP_CONNECTREFUSED_ERROR);
	else if(r==-2) fprintf(stderr, FTP_UNKNOWANSWER_ERROR);
	else fprintf(stderr, FTP_PORTREFUSED_ERROR);
      }
    if(r)
      {
	ftp_close(sock);
	exit(-1);
      }
    print_port_result(portv, f, echo, showall);
  } while(!(r=get_next_ip(ilf)));
  ftp_close(sock);
  if(r<0) exit(-1);
  return nb_host;
}
