/******************************************************************************
 *                        prototypes.h by S/ash [RtC]                         *
 *                        RtC Scan : a network mapper                         *
 *                       contain functions prototypes                         *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#ifndef __RTCSCAN_PROTOTYPES_H__
#define __RTCSCAN_PROTOTYPES_H__

/* macro for time diff */
#define DIFFTIME(a,b) ((b.tv_sec-a.tv_sec)*1000 + (b.tv_usec-a.tv_usec)/1000)


/*
 * File ipraw.c
 */
#ifdef DEBUGGING
void HEXDUMP(unsigned, unsigned char*);
#endif
unsigned short in_chksum(u_short*, int);
int tcp_send(int, struct sockaddr_in*, unsigned long, unsigned long, unsigned, unsigned,
	     unsigned char, unsigned long, unsigned long, unsigned, char*, unsigned);
int udp_send(int, struct sockaddr_in*, unsigned long, unsigned long, unsigned, unsigned,
	     char*, unsigned);
int isup(struct in_addr, struct in_addr*, long);
int send_icmp_echo(int, struct sockaddr_in,     /* send an icmp echo request       */
		   u_short, u_short, char*, int);
int ping(int, struct sockaddr_in,               /* send a ping and stand the reply */
	 int, int, u_short, u_short);
int fast_ping(int, struct sockaddr_in, int,     /* send a fast ping                */
	      u_short, u_short);
int scan_for_pong(int, struct in_addr*, int);   /* check for icmp echo reply       */
struct in_addr resolve(char*);

/*
 * File arguments.c
 */
void print_help(char*, int);
void parse_arg(int, char**, int*, long*);
char *inet_to_str(char*);
char *inaddr_to_inet(struct in_addr);
struct in_addr inet_to_inaddr(char*);
int open_ip_file(char*, struct ip_list_file*);
int get_next_ip(struct ip_list_file*);

/*
 * File portfile.c
 */
int open_port_list_file(char*, struct port_list_file*, int, int);
int rst_port_file(struct port_list_file*);
long get_next_port(struct port_list_file*, char*);

/*
 * File udptcpscan.c
 */
int  udptcp_scan_port(long, struct sockaddr_in*, int, long, long);
void udptcp_fscan_port(long, struct sockaddr_in*, int, long);
void udptcp_read_ans_port(int, struct sockaddr_in*, int, struct port_result *portv, int*);
int  get_localhost(struct in_addr, char*, long, int);
int  udptcp_scan_ports(struct port_list_file*, struct sockaddr_in*,
		       int, int, long, long, long, long, struct port_result*);

/*
 * File ftpscan.c
 */
int  ftp_connect(struct in_addr, char*, char*, int);
void ftp_close(int);
int  ftp_send_port(int, int, struct in_addr);
int  ftp_check_port(int);
int  ftp_scan_port(int, struct in_addr, int, int);
int  ftp_scan_ports(int, struct in_addr, int, struct port_list_file*, struct port_result*);

/*
 * File echoscan.c
 */
int   echo_scan_host(struct in_addr, int, int, int);            /* scan an host                       */
void  echo_fscan_host(struct in_addr, int, int, int);           /* send an icmp request to one host   */

/*
 * File interface.c
 */
void print_begin_msg(FILE*);
void print_host_info(char*, char*, struct in_addr, int, FILE*);
void print_host_state(int, int, int, FILE*);
void print_scan_methods(int, int, FILE*);
void init_port_result(struct port_result*);
void print_port_result(struct port_result*, FILE*, int, int);
void prompt_next_host();
void print_scan_finished(int, int, FILE*, int, int);
void print_ip_address(struct in_addr, char*, FILE*, int, int, int);
void add_ip(struct ip_list**, char*, struct in_addr, int);
void set_ip(struct ip_list*, struct in_addr, int);
void free_iplist(struct ip_list*);
void print_iplist(struct ip_list*, FILE*, int, int);

/*
 * File rtcscan.c
 */
void rtcscan(int, int, int, int, int, int, int, struct port_list_file*,
	     int, int, struct ip_list_file*, int, int, char*, char*,
	     char*, int, char*, int, int, int, FILE*);
int portscan(int, int, int, int, int, int, int, struct port_list_file*,
	     int, int, struct ip_list_file*, char*, int, int, int, FILE*);
int ipscan(int, int, int, struct ip_list_file*, int, int, int, int, FILE*);
int ftpscan(char*, char*, char*, int, struct port_list_file*, int, int, 
	    struct ip_list_file*, int, int, int, int, FILE*);

/*
 * File main.c
 */
int main(int, char**);
void check_sockets(int, int);
void run_scan(char**, int, long*);

#endif
