/******************************************************************************
 *                           main.c by S/ash [RtC]                            *
 *                        RtC Scan : a network mapper                         *
 *            contain initialization functions and main() procedure           *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#include "rtcscan.h"

#define GET_ARG_STRING(i) (argtab[i] ? argv[argtab[i]] : NULL)

/******************************************************************************
 * Function main : the main procedure                                         *
 * Input  : argc : argument counter                                           *
 *          argv : argument vector                                            *
 * Output : return : 0                                                        *
 * function main is of type integer just for escaping a stupid gcc warning    *
 * message that force main to be of this type                                 *
 ******************************************************************************/
int main(int argc, char **argv)
{
  int  flags;
  long argtab[ARG_TAB_SIZE];
  /* hehe, prosperity is on :-) */
  printf(INFOSTR);
  
  /* initializing rand seed */
  srand(time(NULL));
 
  /* parsing arguments... */
  parse_arg(argc, argv, &flags, argtab);

  /* If you asked for a raw socket method, can you ? */
  check_sockets(argtab[METHOD_IND], !(flags & ISUP_FLAG));
  
  /* all is ok, scan on */
  run_scan(argv, flags, argtab);

  /* return 0 to keep gcc happy */
  return 0;
}

/******************************************************************************
 * Function check_sockets : huh check for luser that asked a raw socket while *
 *                          he isn't root...                                  *
 * Input  : sm : scanning method                                              *
 *          up : use isup ?                                                   *
 * for echo-scanning or if we use isup ICMP RAW Sockets are needed            *
 * for syn & stealth scanning TCP RAW Sockets are needed                      *
 * for TCP connect() & FTP Bounce Scanning TCP STREAM Sockets are needed      *
 * for UDP (lame) scanning UDP DATAGRAM Sockets are needed                    *
 * for UDP scanning UDP RAW Sockets are needed                                *
 * for Echo, SYN, Stealth & UDP Scanning IP RAW Sockets are needed            *
 ******************************************************************************/
void check_sockets(int sm, int up)
{
  int s;
  switch(sm)
    {
    case METHOD_T:
    case METHOD_B:
      /* TCP connect() & FTP Bounce scanning */
      if ((s=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
	{
	  fprintf(stderr, TCPSTREAM_SOCK_ERR);
	  exit(1);
	}
      close(s);
      break;
    case METHOD_S:
    case METHOD_A:
    case METHOD_F:
      /* syn or stealth scanning */
      if ((s=socket(AF_INET, SOCK_RAW, IPPROTO_TCP)) == -1)
	{
	  fprintf(stderr, TCPRAW_SOCK_ERROR);
	  exit(1);
	}
      close(s);
      if ((s=socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
	{
	  fprintf(stderr, IPRAW_SOCK_ERROR);
	  exit(1);
	}
      if(up)
	if((s=socket(AF_INET, SOCK_RAW, IPPROTO_ICMP))==-1)
	  {
	    fprintf(stderr, ICMPRAW_SOCK_ERROR);
	    exit(1);
	  }
      close(s);
      break;
    case METHOD_U: /* classic UDP scanning */
      if ((s=socket(AF_INET, SOCK_RAW, IPPROTO_UDP)) == -1)
	{
	  fprintf(stderr, UDPRAW_SOCK_ERROR);
	  exit(1);
	}
      close(s);
      if ((s=socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
	{
	  fprintf(stderr, IPRAW_SOCK_ERROR);
	  exit(1);
	}
      close(s);
      if(up)
	if((s=socket(AF_INET, SOCK_RAW, IPPROTO_ICMP))==-1)
	  {
	    fprintf(stderr, ICMPRAW_SOCK_ERROR);
	    exit(1);
	  }
      break;
    case METHOD_u: /* lame UDP scanning */
      if((s=socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP))==-1)
	{
	  fprintf(stderr, UDPDGRAM_SOCK_ERR);
	  exit(1);
	}
      close(s);
      break;      
    }
}

/******************************************************************************
 * Function run_scan : open files & launch the scan                           *
 * Input  : argv   : argument vector                                          *
 *          flags  : argument flags                                           *
 *          argtab : argument parsed tabular                                  *
 ******************************************************************************/
void run_scan(char **argv, int flags, long *argtab)
{
  FILE *f;
  struct port_list_file plf;
  struct ip_list_file   ilf;
  int r;
  if(argtab[OUTFILE_IND])
    {
      f = fopen(argv[argtab[OUTFILE_IND]], "w");
      if(!f)
	{
	  fprintf(stderr, OPENOFILE_ERROR);
	  exit(-1);
	}
    }
  else f = NULL;
  if(flags & IPFILE_FLAG)
    {
      if(!open_ip_file(argv[argtab[IP_IND]], &ilf))
	{
	  fprintf(stderr, OPENIPFILE_ERROR, argv[argtab[IP_IND]]);
	  exit(-1);
	}
      if(get_next_ip(&ilf)) exit(-1);
    }
  else 
    {
      if((r=parse_ip_string(&ilf, argv[argtab[IP_IND]])))
	{
	  if (r==1)   /* ip string incorrect */
	    {
	      fprintf(stderr, IPSTR_INVALID);
	      exit(-1);
	    }
	  else        /* error resolving host */
	    {
	      fprintf(stderr, INADDR_ERROR, argv[argtab[IP_IND]]);
	      exit(-1);
	    }
	}
      ilf.file = NULL;
      ilf.curcomment = NULL;
    }
  if(!(flags & USESERVICES_FLAG))
    open_port_list_file("", &plf, (argtab[METHOD_IND]==METHOD_U) || (argtab[METHOD_IND]==METHOD_u), 1);
  else if(flags & PORTFILE_FLAG)
    {
      if(open_port_list_file(argv[argtab[MIN_FILE_PORT_IND]], &plf, (argtab[METHOD_IND]==METHOD_U) || (argtab[METHOD_IND]==METHOD_u), 0))
	{
	  fprintf(stderr, OPENPORTFILE_ERROR, argv[argtab[MIN_FILE_PORT_IND]]);
	  exit(-1);
	}
    }
  else
    {
      plf.readservices = 0;
      plf.proto = (argtab[METHOD_IND]==METHOD_U) || (argtab[METHOD_IND]==METHOD_u);
      plf.file = NULL;
    }

    /* well, files opened, going to scan... */
    rtcscan(argtab[METHOD_IND], !(flags & SLOW_FLAG), argtab[DELAY_IND],
	    !(flags & ISUP_FLAG), argtab[TIMEOUT_IND], argtab[OWNPORT_IND], argtab[OWNPORTMAX_IND],
	    &plf, argtab[MIN_FILE_PORT_IND], argtab[MAX_PORT_IND], &ilf,
	    argtab[TRIES_IND], argtab[PACKETSIZE_IND], GET_ARG_STRING(FTPHOST_IND), 
	    GET_ARG_STRING(FTP_USERNAME_IND) ? GET_ARG_STRING(FTP_USERNAME_IND) : DEFFTP_LOGIN,
	    GET_ARG_STRING(FTP_PASSWD_IND) ? GET_ARG_STRING(FTP_PASSWD_IND) : DEFFTP_PASS, 
	    argtab[FTP_PORT_IND] ? argtab[FTP_PORT_IND] : DEFSFTP_PORT,
	    GET_ARG_STRING(OWNIP_IND), (flags & SHOWALL_FLAG), !(flags & NOECHO_FLAG),
	    (flags & PROMPT_FLAG), f);
    /* closing files */
    if(ilf.file) fclose(ilf.file);
    if(plf.file) fclose(plf.file);
    if(f) fclose(f);
}
