/******************************************************************************
 *                        interface.h by S/ash [RtC]                          *
 *                        RtC Scan : a network mapper                         *
 *                 contain functions for displaying informations              *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#include "rtcscan.h"

extern int localhost_addr;

/******************************************************************************
 * Function print_begin_msg - print the beginning message                     *
 * Input  : f : output file                                                   *
 * Just for prosperity hehe ;-)                                               *
 ******************************************************************************/
void print_begin_msg(FILE *f)
{
  if(f) fprintf(f, INFOSTRFILE);
}

/******************************************************************************
 * Function print_host_info - print the host informations                     *
 * Input  : name    : hostname                                                *
 *          comment : comment on host                                         *
 *          adr     : ip address of host                                      *
 *          echo    : show echo on stdout ?                                   *
 *          f       : output file                                             *
 ******************************************************************************/
void print_host_info(char *name, char *comment, struct in_addr adr, int echo, FILE *f)
{
  if(echo)
    {
      printf(BEGIN_SCANNING, name ? name : inet_ntoa(adr));
      printf(comment ? HOST_COMMENT : endl, comment);
      printf(HOST_IP, inet_ntoa(adr));
    }
  if(f)
    {
      fprintf(f, BEGIN_SCANNING, name ? name : inet_ntoa(adr));
      fprintf(f, comment ? HOST_COMMENT : endl, comment);
      fprintf(f, HOST_IP, inet_ntoa(adr));
    }

}
/******************************************************************************
 * Function print_host_state - print the state of the host                    *
 * Input  : state   : host state                                              *
 *          echo    : show echo on stdout ?                                   *
 *          f       : output file                                             *
 ******************************************************************************/
void print_host_state(int showhost, int state, int echo, FILE *f)
{
  struct in_addr tmp;
  if(echo)
    {
      switch(state)
	{
	case HOST_UP:
	  printf(HOST_UPSTR);
	  tmp.s_addr = localhost_addr;
	  printf(LOCALHOST_SCAN_MSG, inet_ntoa(tmp));
	  break;
	case HOST_DOWN:
	  printf(HOST_DOWNSTR);
	  break;
	case HOST_NODISP:
	  printf(endl);
	  tmp.s_addr = localhost_addr;
	  if(showhost) printf(LOCALHOST_SCAN_MSG, inet_ntoa(tmp));
	  break;
	}
    }
  if(f)
    {
      switch(state)
	{
	case HOST_UP:
	  fprintf(f, HOST_UPSTR);
	  tmp.s_addr = localhost_addr;
	  fprintf(f, LOCALHOST_SCAN_MSG, inet_ntoa(tmp));
	  break;
	case HOST_DOWN:
	  fprintf(f, HOST_DOWNSTR);
	  break;
	case HOST_NODISP:
	  fprintf(f, endl);
	  tmp.s_addr = localhost_addr;
	  if(showhost) fprintf(f, LOCALHOST_SCAN_MSG, inet_ntoa(tmp));
	  break;
	}
    }

}

/******************************************************************************
 * Function print_scan_methods : print the scanning method                    *
 * Input  : sm      : scanning method                                         *
 *          echo    : show echo on stdout ?                                   *
 *          f       : output file                                             *
 ******************************************************************************/
void print_scan_methods(int sm, int echo, FILE *f)
{
  if(echo)
    {
      switch(sm)
	{
	case METHOD_S:
	  printf(TCP_SCAN_MSG);
	  printf(TCP_SYN_SCAN_MSG);
	  break;
	case METHOD_T:
	  printf(TCP_SCAN_MSG);
	  printf(TCP_COMP_SCAN_MSG);
	  break;
	case METHOD_F:
	  printf(TCP_SCAN_MSG);
	  printf(TCP_FIN_SCAN_MSG);
	  break;
	case METHOD_A:
	  printf(TCP_SCAN_MSG);
	  printf(TCP_ACK_SCAN_MSG);
	  break;
	case METHOD_B:
	  printf(TCP_SCAN_MSG);
	  printf(TCP_FTP_SCAN_MSG);
	  break;
	case METHOD_E:
	  printf(ECHO_SCAN_MSG);
	  break;
	case METHOD_U:
	  printf(UDP_SCAN_MSG);
	  printf(UDP_FAST_SCAN_MSG);
	  break;
	case METHOD_u:
	  printf(UDP_SCAN_MSG);
	  printf(UDP_LAME_SCAN_MSG);
	  break;
	}
    }
  if(f)
    {
      switch(sm)
	{
	case METHOD_S:
	  fprintf(f, TCP_SCAN_MSG);
	  fprintf(f, TCP_SYN_SCAN_MSG);
	  break;
	case METHOD_T:
	  fprintf(f, TCP_SCAN_MSG);
	  fprintf(f, TCP_COMP_SCAN_MSG);
	  break;
	case METHOD_F:
	  fprintf(f, TCP_SCAN_MSG);
	  fprintf(f, TCP_FIN_SCAN_MSG);
	  break;
	case METHOD_A:
	  fprintf(f, TCP_SCAN_MSG);
	  fprintf(f, TCP_ACK_SCAN_MSG);
	  break;
	case METHOD_B:
	  fprintf(f, TCP_SCAN_MSG);
	  fprintf(f, TCP_FTP_SCAN_MSG);
	  break;
	case METHOD_E:
	  fprintf(f, COMMENT_LINE ECHO_SCAN_MSG);
	  break;
	case METHOD_U:
	  fprintf(f, UDP_SCAN_MSG);
	  fprintf(f, UDP_FAST_SCAN_MSG);
	  break;
	case METHOD_u:
	  fprintf(f, UDP_SCAN_MSG);
	  fprintf(f, UDP_LAME_SCAN_MSG);
	  break;
	}
    }
}


/******************************************************************************
 * Function init_port_result  : initialize a port vector                      *
 * Input  : portv   : port vector                                             *
 * Yes, yes, i know it's not it place but it do for the first time what       *
 * print_port_result will do after                                            *
 ******************************************************************************/
void init_port_result(struct port_result *portv)
{
  int i;
  for(i=0; i<SIZEOF_PORTV; i++)
    {
      portv[i].service = NULL;
      portv[i].state = PORTSTATE_NO;
    }
}

/******************************************************************************
 * Function print_port_result  : also free the service string associate       *
 * Input  : portv   : port vector                                             *
 *          f       : output file                                             *
 *          echo    : show echo on stdout ?                                   *
 *          showall : show all port scanned ?                                 *
 ******************************************************************************/
void print_port_result(struct port_result *portv, FILE *f, int echo, int showall)
{
  int i;
  if(echo)
    printf(SCAN_HEAD_LINE);
  if(f)
    fprintf(f, SCAN_HEAD_LINE);
  for(i=0; i<SIZEOF_PORTV; i++)
    {
      switch(portv[i].state)
	{
	case PORTSTATE_TIMEOUT:
	  if(echo) printf(PORT_TIMEDOUT, i, portv[i].service ? portv[i].service : "");
	  if(f) fprintf(f, PORT_TIMEDOUT, i, portv[i].service ? portv[i].service : "");
	  break;
	case PORTSTATE_OPENED:
	  if(echo) printf(PORT_OPEN, i, portv[i].service ? portv[i].service : "");
	  if(f) fprintf(f, PORT_OPEN, i, portv[i].service ? portv[i].service : "");
	  break;
	case PORTSTATE_ERROR:
	  if(echo) printf(PORT_ERROR, i, portv[i].service ? portv[i].service : "");
	  if(f) fprintf(f, PORT_ERROR, i, portv[i].service ? portv[i].service : "");
	  break;
	case PORTSTATE_CLOSED:
	  if(showall)
	    {
	      if(echo) printf(PORT_CLOSED, i, portv[i].service ? portv[i].service : "");
	      if(f) fprintf(f, PORT_CLOSED, i, portv[i].service ? portv[i].service : "");
	    }
	}
      if(portv[i].service)
	{
	  free(portv[i].service);
	  portv[i].service = NULL;
	}
      portv[i].state = PORTSTATE_NO;
    }
}

/******************************************************************************
 * Function prompt_next_host  : just prompt for next host                     *
 ******************************************************************************/
void prompt_next_host()
{
  printf(PROMPT_NEXTHOST);
  while(getchar()!='\n');
}


/******************************************************************************
 * Function print_scan_finished  : self-explaining (hi ! JLL)                 *
 * Input  : nbhost : number of hosts scanned                                  *
 *          t      : time used for scanning                                   *
 *          f      : output file                                              *
 *          echo   : show echo on stdout ?                                    *
 *          comm   : comment the line in the file ?                           *
 ******************************************************************************/
void print_scan_finished(int nbhost, int t, FILE* f, int echo, int comm)
{
  if(echo)
    printf(endl SCAN_COMPLETED, nbhost, t);
  if(f)
    fprintf(f, comm ? endl COMMENT_LINE SCAN_COMPLETED : endl SCAN_COMPLETED, nbhost, t);
}

/******************************************************************************
 * Function print_ip_address  : self-explaining (hi ! JLL)                    *
 * Input  : host : host ip                                                    *
 *          name : host name (eventually comment)                             *
 *          f      : output file                                              *
 *          echo   : show echo on stdout ?                                    *
 *          showall: show even host down ?                                    *
 *          state  : host state                                               *
 ******************************************************************************/
void print_ip_address(struct in_addr host, char *name, FILE *f, int echo, int showall, int state)
{
  switch(state)
    {
    case HOST_UNKNOW: /* he answered */
    case HOST_ANSWER:
      if(echo) printf(name ? "%s (%s) " ECHO_HOST_UP : "%s " ECHO_HOST_UP, inet_ntoa(host), name);
      if(f) fprintf(f, name ? "%s (%s) " ECHO_HOST_UP : "%s " ECHO_HOST_UP, inet_ntoa(host), name);
      break;
    case HOST_TIMEDOUT:
      if(showall)
	{
	  if(echo) printf(name ? "%s (%s) " ECHO_HOST_TIMEDOUT : "%s " ECHO_HOST_TIMEDOUT, inet_ntoa(host), name);
	  if(f) fprintf(f, name ? COMMENT_LINE "%s (%s) " ECHO_HOST_TIMEDOUT : COMMENT_LINE "%s " ECHO_HOST_TIMEDOUT, inet_ntoa(host), name);
	}
      break;
    case HOST_UNREACHABLE:
      if(showall)
	{
	  if(echo) printf(name ? "%s (%s) " ECHO_HOST_UNREACH : "%s " ECHO_HOST_UNREACH, inet_ntoa(host), name);
	  if(f) fprintf(f, name ? COMMENT_LINE "%s (%s) " ECHO_HOST_UNREACH : COMMENT_LINE "%s " ECHO_HOST_UNREACH, inet_ntoa(host), name);
	}
      break;
    }
}

/******************************************************************************
 * Function add_ip  : add an ip to an ip list                                 *
 * Input  : ipl     : the ip list                                             *
 *          name    : the ip name                                             *
 *          host    : the host ip                                             *
 *          state   : the host state                                          *
 ******************************************************************************/
void add_ip(struct ip_list **ipl, char *name, struct in_addr host, int state)
{
  struct ip_list *p1, *p2; int i;
  struct ip_list *tmp = (struct ip_list*)malloc(sizeof(struct ip_list));
  struct hostent *h;
  tmp->state = state;
  tmp->ip    = host.s_addr;
  tmp->name  = NULL;
  i  = ntohs(host.s_addr);
  p2 = NULL;
  p1 = *ipl;
  if(!name)
    {
      h = gethostbyaddr((char*)(&(tmp->ip)), sizeof(tmp->ip), AF_INET);
      if(h)
	if(h->h_name)
	  {
	    tmp->name = (char*)malloc(strlen(h->h_name)+1);
	    strcpy(tmp->name, h->h_name);
	  }
    }
  else
    {
      tmp->name = (char*)malloc(strlen(name)+1);
      strcpy(tmp->name, name);
    }
  if(p1)
    {
      while(p1->next && (ntohs(p1->ip) > i))
	{
	  p2 = p1;
	  p1 = p1->next;
	}
      if(p1->ip == host.s_addr)
	{
	  if((p1->state==HOST_UNKNOW) && (state==HOST_ANSWER)) p1->state = HOST_ANSWER;
	  else if(p1->state != HOST_ANSWER) p1->state = state;
	  if(!(p1->name) && tmp->name) p1->name = tmp->name;
	  else free(tmp->name);
	}
      else if(p2)
	{
	  p2->next  = tmp;
	  tmp->next = p1;
	}
      else
	{
	  *ipl = tmp;
	  tmp->next = p1;
	}
    }
  else
    {
      *ipl = tmp;
      tmp->next = NULL;
    }
}

/******************************************************************************
 * Function set_ip  : set the state of an ip in an ip list                    *
 * Input  : ipl     : the ip list                                             *
 *          host    : the host ip                                             *
 *          state   : the host state                                          *
 ******************************************************************************/
void set_ip(struct ip_list *ipl, struct in_addr host, int state)
{
  if(ipl)
    {
      if(ipl->ip == host.s_addr)
	{
	  if((ipl->state==HOST_UNKNOW) && (state==HOST_ANSWER)) ipl->state = HOST_ANSWER;
	  else if(ipl->state != HOST_ANSWER) ipl->state = state;
	}
      else set_ip(ipl->next, host, state);
    }
}

/******************************************************************************
 * Function free_iplist  : free an ip list                                    *
 * Input  : ipl     : the ip list                                             *
 ******************************************************************************/
void free_iplist(struct ip_list *ipl)
{
  if(ipl)
    {
      if(ipl->name) free(ipl->name);
      free_iplist(ipl->next);
      free(ipl);
    }
}

/******************************************************************************
 * Function print_iplist  : display an ip list                                *
 * Input  : ipl     : the ip list                                             *
 *          f      : output file                                              *
 *          echo   : show echo on stdout ?                                    *
 *          showall: show even host down ?                                    *
 ******************************************************************************/
void print_iplist(struct ip_list *ipl, FILE *f, int echo, int showall)
{
  struct in_addr adr;
  if(ipl)
    {
      adr.s_addr = ipl->ip;
      print_ip_address(adr, ipl->name, f, echo, showall, ipl->state);
      print_iplist(ipl->next, f, echo, showall);
    }
}
