/******************************************************************************
 *                         echoscan.h by S/ash [RtC]                          *
 *                        RtC Scan : a network mapper                         *
 *                        functions for echo scanning                         *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#include "rtcscan.h"
/******************************************************************************
 * Function echo_scan_host - scan an host using ping                          *
 * Input  : host     : host to scan                                           *
 *          tries    : number to tries to do if time out                      *
 *          packsize : size of packets to send                                *
 *          timeout  : ping time out                                          *
 * Output : return   : ping output                                            *
 ******************************************************************************/
int echo_scan_host(struct in_addr host, int tries, int packsize, int timeout)
{
  struct sockaddr_in dest;
  int sock, res;
  u_short seq_nb, ident = rand();
 
  /* resolving host address */
  dest.sin_family = AF_INET;
  dest.sin_addr = host;
  /* opening socket */
  sock = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP);
  if(sock<0)
    {
      fprintf(stderr, ICMPRAW_SOCK_ERROR);
      exit(-1);
    }
  for(seq_nb=0; (seq_nb<tries) && ((res=ping(sock, dest, timeout, packsize, ident, seq_nb))==HOST_TIMEDOUT); seq_nb++); /* ping sequence */
  /* All done */
  close(sock);
  return res;
}

/******************************************************************************
 * Function echo_fscan_host - scan an host using fast_ping                    *
 * Input  : host     : host to scan                                           *
 *          tries    : number to tries to do if time out                      *
 *          packsize : size of packets to send                                *
 *          delai    : delay between sent                                     *
 ******************************************************************************/
void echo_fscan_host(struct in_addr host, int tries, int packsize, int delai)
{
  struct sockaddr_in dest;
  int sock, res;
  u_short seq_nb, ident = rand();
 
  /* resolving host address */
  dest.sin_family = AF_INET;
  dest.sin_addr = host;
  /* opening socket */
  sock = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP);
  if(sock<0)
    {
      fprintf(stderr, ICMPRAW_SOCK_ERROR);
      exit(-1);
    }
  for(seq_nb=0; seq_nb<tries; seq_nb++)
    {
      fast_ping(sock, dest, packsize, ident, seq_nb); /* ping sequence */
      usleep(1000*delai);
    }
  /* All done */
  close(sock);
}
