/******************************************************************************
 *                         constant.h by S/ash [RtC]                          *
 *                        RtC Scan : a network mapper                         *
 *                         contain several constants                          *
 *              This is a part of the RtC Neset Project - RtC Tech            *
 ******************************************************************************/

#ifndef __RTCSCAN_CONSTANT_H__
#define __RTCSCAN_CONSTANT_H__


/* classical strings */
#ifndef endl
#define endl "\n"
#endif
#ifndef tab
#define tab  "\t"
#endif
#ifndef ws
#define ws   " "
#endif

#include "config.h"   /* parameters set by configure script */

/* constants */
#define DEFTIMEOUT                   1000
#define DEFTIMEOUT_STR              "1000"
#define DEFDELAY                     5
#define DEFDELAY_STR                "5"
#define DEFSTCP_PORT                 10001
#define DEFSTCP_PORT_STR            "10001"
#define DEFSFTP_PORT                 21
#define DEFSFTP_PORT_STR            "21"
#define DEFFTP_LOGIN                "ftp"
#define DEFFTP_PASS                 "ftp@nowhere.no"
#define LOW_TTL                      65
#define DEFAULT_TIMEOUT              5000
#define DEFAULT_TIMEOUTSTR          "5000"
#define MIN_PACKETSIZE               8
#define MIN_PACKETSIZESTR           "8"
#define MAX_PACKETSIZE               2048
#define MAX_PACKETSIZESTR           "2048"
#define DEFAULT_PACKETSIZESTR       "64"
#define DEFAULT_PACKETSIZE           64
#define DEFAULT_TRIES                1
#define DEFAULT_TRIESSTR            "1"

/* port tab */
#define SIZEOF_PORTV                 65536
#define PORTSTATE_NO                -1
#define PORTSTATE_TIMEOUT            0
#define PORTSTATE_OPENED             1
#define PORTSTATE_CLOSED             2
#define PORTSTATE_ERROR              3

/* ping return values */
#define HOST_UNKNOW                 -1
#define HOST_ANSWER                  0
#define HOST_TIMEDOUT                1
#define HOST_UNREACHABLE             2
#define PING_ERROR                   3
#define PING_RAS                     4

/* host states */
#define HOST_UP                      0
#define HOST_DOWN                    1
#define HOST_NODISP                 -1

/* argument parsing */                     /* option */
/* Scanning methods */
#define METHOD_S                     1     /*  -sS   */
#define METHOD_T                     2     /*  -sT   */
#define METHOD_F                     3     /*  -sF   */
#define METHOD_A                     4     /*  -sA   */
#define METHOD_B                     5     /*  -sB   */
#define METHOD_E                     6     /*  -sE   */
#define METHOD_U                     7     /*  -sU   */
#define METHOD_u                     8     /*  -su   */
/* size of argument tab */
#define ARG_TAB_SIZE                 16
/* flags */
#define SLOW_FLAG                    1     /*  -f    */
#define ISUP_FLAG                    2     /*  -u    */
#define IPFILE_FLAG                  4     /*  -l    */
#define PORTFILE_FLAG                8     /*  -p    */
#define SHOWALL_FLAG                 16    /*  -a    */
#define NOECHO_FLAG                  32    /*  -e    */
#define PROMPT_FLAG                  64    /*  -n    */
#define USESERVICES_FLAG             128   /* don't use /etc/services */
/* indexes for ARG_TAB */
#define IP_IND                       0   /* index for ip to scan  */
#define METHOD_IND                   1   /* Method for scan       */
#define DELAY_IND                    2   /* delay                 */
#define OWNIP_IND                    3   /* Index of our own ip   */
#define TIMEOUT_IND                  4   /* Time out              */
#define OWNPORT_IND                  5   /* own port              */
#define OWNPORTMAX_IND               6   /* max own port          */
#define MIN_FILE_PORT_IND            7   /* Min port or port file */
#define MAX_PORT_IND                 8   /* Max port              */
#define FTPHOST_IND                  9   /* FTP host name         */
#define FTP_USERNAME_IND             10   /* user name for FTP     */
#define FTP_PASSWD_IND               11  /* password for FTP      */
#define FTP_PORT_IND                 12  /* port to use for FTP   */
#define PACKETSIZE_IND               13  /* Size of ICMP Packets  */
#define TRIES_IND                    14  /* Number of Tries       */
#define OUTFILE_IND                  15  /* Out File index        */

#endif
