/* xRaSnif by RaPass <rapass@gmx.net> */
#include "xRaSnif.h"
#include <ctype.h>

gboolean fin_fenetre_data(GtkWidget *Fenetre, struct widg *ptr) {
  ptr->fenetre_sniffe = NULL;
  ptr->texte_sniffe = NULL;
  return FALSE;
}

void refresh_sniffdata(GtkWidget *Text, char *filename) {
  FILE *fptr;
  char buffer[100];
  int i,c;
  
  if ((fptr = fopen(filename, "r")) == NULL) {
    perror("Ouverture fichier");
  }
  else {
    gtk_text_freeze(GTK_TEXT(Text));
    gtk_editable_delete_text(GTK_EDITABLE(Text),0,-1);
    do {
      i = 0;
      do {
	c = fgetc(fptr);
	if (isprint(c)) {
	  buffer[i] = c;
	  i++;	
	}
	if (c == 13) {
	  buffer[i] = 10;
	  i++;
	}
	if (c == EOF)
	  break;
      }
      while(i >= 98);
      
      buffer[i] = '\0';
      /* fprintf(stderr, "%s", buffer); */ /* Pour afficher sur le terminal aussi */
      gtk_text_insert(GTK_TEXT(Text), NULL, NULL, NULL,
		      buffer, i);
    }  
    while (c != EOF);
    gtk_text_thaw(GTK_TEXT(Text));
  }
  fclose(fptr);
}
gboolean aff_snifdata() {
  struct widg *ptr;
  GtkWidget *Boite;
  GtkWidget *Ascenseur;
  GtkWidget *Bouton;
  
  ptr = (struct widg *)connections[ligne_select];
  fprintf(stderr, "\033[1;32mAffichage des donnees sniffe de la %d\033[0m\n", ligne_select);
  
  
  if (ptr->fenetre_sniffe == NULL) {
    ptr->fenetre_sniffe = gtk_dialog_new();
    gtk_signal_connect(GTK_OBJECT(ptr->fenetre_sniffe), "destroy", 
		       (GtkSignalFunc)fin_fenetre_data, (gpointer)ptr);
    gtk_window_set_title(GTK_WINDOW(ptr->fenetre_sniffe), "Sniffing rulez!!");
    Boite = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(ptr->fenetre_sniffe)->vbox), Boite);

    ptr->texte_sniffe = gtk_text_new(NULL, NULL);

    gtk_widget_set_usize(ptr->texte_sniffe, 700, 200);
    gtk_box_pack_start_defaults(GTK_BOX(Boite), ptr->texte_sniffe);
    Ascenseur = gtk_vscrollbar_new(GTK_TEXT(ptr->texte_sniffe)->vadj);
    gtk_box_pack_start_defaults(GTK_BOX(Boite), Ascenseur);

    Bouton = gtk_button_new_with_label("Fermer");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ptr->fenetre_sniffe)->action_area), 
		       Bouton, TRUE, TRUE, 0);
    gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked", 
			      (GtkSignalFunc)gtk_widget_destroy,
			      GTK_OBJECT(ptr->fenetre_sniffe));

    gtk_widget_show_all(ptr->fenetre_sniffe);
  } else 
    gdk_window_raise(ptr->fenetre_sniffe->window);
  
  refresh_sniffdata(ptr->texte_sniffe, ptr->filename);  
  return TRUE;
}
