/* xRaSnif by RaPass <rapass@gmx.net>*/
#include "xRaSnif.h"

extern int ligne_select;

gboolean fin_fenetre(GtkWidget *Fenetre, GtkWidget **entries) {
  struct widg *ptr;
  int i;
  for(i=0 ; i <= NbrLignes ; i++) {
    ptr = (struct widg *)connections[i];
    if (Fenetre == ptr->fenetre_entete) {
      ptr->fenetre_entete = NULL;
      break;
    }
  }
  g_free(entries);
  return FALSE;
}

gboolean rafraichir_fenetre(GtkWidget *Bouton,GtkWidget **entries) {
  struct iphdr *ip;
  struct tcphdr *tcp;
  gchar *buffer;
  
  
  
  ip =(struct iphdr *)(connections[(int)entries[18]] + SIZE_WID + ENTETE_ETH);
  tcp =(struct tcphdr *)(connections[(int)entries[18]] + SIZE_WID + ENTETE_ETH + ENTETE_IP);
  
  pthread_mutex_lock(&my_mutex);

  buffer = g_strdup_printf("%d", ip->version);
  gtk_entry_set_text(GTK_ENTRY(entries[0]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d", ip->tos);
  gtk_entry_set_text(GTK_ENTRY(entries[1]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d octets", ntohs(ip->tot_len));
  gtk_entry_set_text(GTK_ENTRY(entries[2]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d", ntohs(ip->id));
  gtk_entry_set_text(GTK_ENTRY(entries[3]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d", ip->ttl);
  gtk_entry_set_text(GTK_ENTRY(entries[4]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d", ntohs(ip->check));
  gtk_entry_set_text(GTK_ENTRY(entries[5]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%u", (unsigned int)ntohl(tcp->seq));
  gtk_entry_set_text(GTK_ENTRY(entries[6]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%u",(unsigned int)ntohl(tcp->ack_seq));
  gtk_entry_set_text(GTK_ENTRY(entries[7]), buffer);
  g_free(buffer);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[8]), tcp->urg);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[9]), tcp->ack);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[10]), tcp->psh);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[11]), tcp->rst);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[12]), tcp->syn);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(entries[13]), tcp->fin);



  buffer = g_strdup_printf("%d",ntohs(tcp->window));
  gtk_entry_set_text(GTK_ENTRY(entries[14]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d",ntohs(tcp->check));
  gtk_entry_set_text(GTK_ENTRY(entries[15]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d",ntohs(tcp->urg_ptr));
  gtk_entry_set_text(GTK_ENTRY(entries[16]), buffer);
  g_free(buffer);

  buffer = g_strdup_printf("%d octets", ntohs(ip->tot_len) - ENTETE_IP - (tcp->doff*4));
  gtk_entry_set_text(GTK_ENTRY(entries[17]), buffer); 
  pthread_mutex_unlock(&my_mutex);
  g_free(buffer);
  
  return TRUE;
}


gboolean  Aff_entete(GtkWidget *bah) {
  GtkWidget *Label;
  GtkWidget *Table;
  GtkWidget *Bouton;
  GtkWidget **entries;
  unsigned char *so, *dest;
  struct widg *ptr;
  gchar *buffer;
  struct iphdr *ip;
  struct tcphdr *tcp;

  
  
  ptr = (struct widg *)connections[ligne_select]; 
  fprintf(stderr, "\033[1;32mAffichage entetes de la %d\033[0m\n", ligne_select);
  if (ptr->fenetre_entete != NULL) 
    gtk_widget_destroy(ptr->fenetre_entete);
  
  entries = g_malloc((18 * sizeof(GtkWidget *)) + sizeof(int));
  ptr->fenetre_entete = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect(GTK_OBJECT(ptr->fenetre_entete), "destroy", 
		     (GtkSignalFunc)fin_fenetre, (gpointer)entries);
  
  ip =(struct iphdr *)(connections[ligne_select] + SIZE_WID + ENTETE_ETH);
  tcp =(struct tcphdr *)(connections[ligne_select] + SIZE_WID + ENTETE_ETH + ENTETE_IP);
  so = (unsigned char *)&(ip->saddr);  
  dest = (unsigned char *)&(ip->daddr);
  buffer = g_strdup_printf("%u.%u.%u.%u:%d ---> %u.%u.%u.%u:%d\n", 
			   so[0],so[1],so[2],so[3],ntohs(tcp->source),
			   dest[0],dest[1],dest[2],dest[3], ntohs(tcp->dest));
  gtk_window_set_title(GTK_WINDOW(ptr->fenetre_entete), buffer);
  g_free(buffer);
  Table = gtk_table_new(20, 8, FALSE);
  gtk_container_add(GTK_CONTAINER(ptr->fenetre_entete), Table);
  
  entries[18] = (int)ligne_select;
  Label = gtk_label_new("-=| Entete IP |=-");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 6,  0, 1);
  Label = gtk_label_new("version : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 1, 2);
  entries[0] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[0] , 3, 6, 1, 2);
  Label = gtk_label_new("TOS : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 2, 3);
  entries[1] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[1] , 3, 6, 2, 3);
  Label = gtk_label_new("Longeur datagramme IP : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 3, 4);
  entries[2] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[2] , 3, 6, 3, 4); 
  Label = gtk_label_new("id : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 4, 5);
  entries[3] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[3] , 3, 6, 4, 5);
  Label = gtk_label_new("TTL : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 5, 6);
  entries[4] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[4] , 3, 6, 5, 6);
  Label = gtk_label_new("Checksum : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 6, 7);
  entries[5] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[5] , 3, 6, 6, 7);
  
  Label = gtk_label_new("-=| Entete TCP |=-");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 6,  7, 8);
  Label = gtk_label_new("No sequence : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 8, 9);
  entries[6] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[6] , 3, 6, 8, 9);
  Label = gtk_label_new("No A/R : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 9, 10);
  entries[7] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[7] , 3, 6, 9, 10);
  Label = gtk_label_new("Flags : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 1, 10, 11);
  entries[8] = gtk_check_button_new_with_label("URG");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[8], 0, 1, 11, 12);
  entries[9] = gtk_check_button_new_with_label("ACK");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[9], 1, 2, 11, 12);
  entries[10] = gtk_check_button_new_with_label("PSH");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[10], 2, 3, 11, 12);
  entries[11] = gtk_check_button_new_with_label("RST");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[11], 3, 4, 11, 12);
  entries[12] = gtk_check_button_new_with_label("SYN");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[12], 4, 5, 11, 12);
  entries[13] = gtk_check_button_new_with_label("FIN");
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[13], 5, 6, 11, 12);
  Label = gtk_label_new("fenetre : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 12, 13);
  entries[14] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[14] , 3, 6, 12, 13);
  Label = gtk_label_new("checksum : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 13, 14);
  entries[15] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[15] , 3, 6, 13, 14);
  Label = gtk_label_new("ptr. d'urgence : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 14, 15);
  entries[16] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[16] , 3, 6, 14, 15);
  
  Label = gtk_label_new("-=| Donnees |=-");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 6,  15, 16);
  Label = gtk_label_new("taille : ");
  gtk_table_attach_defaults(GTK_TABLE(Table), Label, 0, 3, 16, 17);
  entries[17] = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(Table), entries[17] , 3, 6, 16, 17);
  
 
  Bouton = gtk_button_new_with_label("Fermer");
  gtk_signal_connect_object(GTK_OBJECT(Bouton), "clicked",
			    (GtkSignalFunc)gtk_widget_destroy,
			    GTK_OBJECT(ptr->fenetre_entete));
  gtk_table_attach_defaults(GTK_TABLE(Table), Bouton, 0,6, 17, 18);
  
  gtk_widget_show_all(ptr->fenetre_entete);
  rafraichir_fenetre(NULL, entries);   
  
  return TRUE;
} 
