/* xRaSnif by RaPass <rapass@gmx.net>*/
#include "xRaSnif.h"
#include <ctype.h>

int ports_a_sniffer[] = { 7, 13, 21, 22, 23, 25, 79, 109, 110, 143,
			  512, 513, 514, 517, 6667, 6668, 0 };

int ask_for_port(int port) {
  int i;
  
  for (i=0 ; ports_a_sniffer[i] != 0 ; i++) {
    if (port == ports_a_sniffer[i])
      return (port);
  }
  return -1;
}

int cherche_connection(struct iphdr *ip1, struct tcphdr *tcp1, 
		       int nbr_connections, int mode) {
  int i;
  struct iphdr *ip2;
  struct tcphdr *tcp2;

  for(i=0 ; i < nbr_connections ; i++) {
    ip2 =(struct iphdr *)(connections[i] + SIZE_WID + ENTETE_ETH);
    tcp2 =(struct tcphdr *)(connections[i] + SIZE_WID + 
			    ENTETE_ETH + ENTETE_IP);
    
    if (mode == 0) {
      if((ip1->saddr == ip2->saddr) && (ip1->daddr == ip2->daddr) && 
	 (tcp1->source == tcp2->source) && (tcp1->dest == tcp2->dest))   
	return i;
    }
     else {
      if ((ip1->saddr == ip2->daddr) && (ip1->daddr == ip2->saddr) && 
	  (tcp1->source == tcp2->dest) && (tcp1->dest ==tcp2->source))
	return i;
    }	
  }
  return -1;
}


int ajoute_connection(char *trame, GtkWidget *Liste, int nbr_connections) {
  struct tm dc;
  time_t first_paquet;
  unsigned char *so, *dest;

  struct iphdr *ip;
  struct tcphdr *tcp;
  char *donnees;
  struct widg *ptr;
  gchar *insert[3];
  int i, len_donnees;
  
  ip = (struct iphdr *) (trame + ENTETE_ETH);
  tcp = (struct tcphdr *) (trame + ENTETE_ETH + ENTETE_IP);
  donnees = (char *)(trame + ENTETE_ETH + ENTETE_IP + (tcp->doff*4));
  len_donnees = ntohs(ip->tot_len) - ENTETE_IP - (tcp->doff*4);

  if ((ask_for_port(ntohs(tcp->source)) == -1) && (ask_for_port(ntohs(tcp->dest)) == -1))
    return nbr_connections;

  connections[nbr_connections] = malloc(SIZE_WID + TAILLE_TRAME);
  bcopy(trame, connections[nbr_connections] + SIZE_WID, TAILLE_TRAME);
  
  /* temporaire */
  ptr = (struct widg *)connections[nbr_connections]; 
  time(&first_paquet);
 
  ptr->fenetre_entete = NULL;
  ptr->fenetre_sniffe = NULL;
  ptr->texte_sniffe = NULL;
  ptr->fenetre_hijack = NULL;
    
  so = (unsigned char *)&(ip->saddr);  
  dest = (unsigned char *)&(ip->daddr);
  
  dc = *localtime(&first_paquet); 
  insert[0] = g_strdup_printf("%02d-%02d-%04d %02d:%02d:%02d", 
			      dc.tm_mday, dc.tm_mon+1, dc.tm_year+1900,
			      dc.tm_hour, dc.tm_min, dc.tm_sec); 
 
  insert[1] = g_strdup_printf("%u.%u.%u.%u:%d", 
			      so[0],so[1],so[2],so[3],
			      ntohs(tcp->source)); 
  insert[2] = g_strdup_printf("%u.%u.%u.%u:%d",	     
			      dest[0],dest[1],dest[2],dest[3], 
			      ntohs(tcp->dest));
 
  gtk_clist_freeze(GTK_CLIST(Liste));
  gtk_clist_append(GTK_CLIST(Liste), insert);
  gtk_clist_thaw(GTK_CLIST(Liste));
  
  ptr->filename = g_strdup_printf("log/%s-%s-%s", insert[0], insert[1], 
				  insert[2]);
  free(insert[0]);
  free(insert[1]);
  free(insert[2]);
  
  if ((ptr->fptr = fopen(ptr->filename, "w+")) == NULL)
    perror("Creation du fichier");
 
  fprintf(ptr->fptr, 
	  "/* Premier paquet recu le %02d/%02d/%04d a %02d:%02d:%02d */",
	  dc.tm_mday, dc.tm_mon+1, dc.tm_year+1900,
	  dc.tm_hour, dc.tm_min, dc.tm_sec);
  fputc(13, ptr->fptr);

  if (len_donnees > 0) {
    for (i=0 ; i < len_donnees ; i++) 
      fputc(donnees[i], ptr->fptr);	  
    fflush(ptr->fptr);
  }
  
  fprintf(stderr, 
	  "\033[1;34mAJOUT CONNECTION TCP (Passer sur la souris sur la list TCP pour l'actualiser)\033[0m\n"); 
  return nbr_connections+1;
}

int enleve_connection(int connect_a_enlever, GtkWidget *Liste, 
		      int nbr_connections) {
  int i;
  struct widg *ptr;

  fprintf(stderr, 
	  "\033[1;34mENLEVE CONNECTION TCP (Passer sur la souris sur la list TCP pour l'actualiser)\033[0m\n");

  if (Liste != NULL) {
    gtk_clist_freeze(GTK_CLIST(Liste));
    gtk_clist_remove(GTK_CLIST(Liste), connect_a_enlever);
    gtk_clist_thaw(GTK_CLIST(Liste));
  }
    
  ptr = (struct widg *)connections[connect_a_enlever];

  if ((fclose(ptr->fptr)) != 0)
    perror("Fermeture fichier");
    
  g_free(ptr->filename);
  
  if (ptr->fenetre_entete != NULL) 
    gtk_widget_destroy(ptr->fenetre_entete);
    
  if (ptr->fenetre_sniffe != NULL)  
    gtk_widget_destroy(ptr->fenetre_sniffe);
  
  
  if (ligne_select == connect_a_enlever) {
    if (FenetreOptionsTCP != NULL)
      gtk_widget_destroy(FenetreOptionsTCP);
  }
  
  free(connections[connect_a_enlever]);
  connections[connect_a_enlever] = NULL;

  if (connect_a_enlever < nbr_connections) {
    for( i= 0 ; connections[connect_a_enlever+i+1] != NULL ; i++)
      connections[connect_a_enlever+i] = connections[connect_a_enlever+i+1];
    connections[connect_a_enlever+i] = NULL;
  }
  
  return nbr_connections-1;
}

  

int sniffe_TCP(char *trame, GtkWidget *Liste, int nbr_connections) {
  
  int  ligne;
  int i;
  struct widg *ptr;
  struct iphdr *ip;
  struct tcphdr *tcp, *tcp2;
  char *donnees;
  int len_donnees;
  
  
  ip = (struct iphdr *) (trame + ENTETE_ETH);
  tcp = (struct tcphdr *) (trame + ENTETE_ETH + ENTETE_IP);
  donnees = (char *) (trame + ENTETE_ETH + ENTETE_IP + (tcp->doff*4));
  len_donnees = ntohs(ip->tot_len) - ENTETE_IP - (tcp->doff*4);



  /*----Reception pacquet RST (qui enleve les 2 connections) --*/
    if (tcp->rst == 1) {
      if ((ligne = cherche_connection(ip, tcp, nbr_connections, 0)) != -1) 
	nbr_connections = enleve_connection(ligne, Liste, nbr_connections);
      
      if ((ligne = cherche_connection(ip, tcp, nbr_connections, 1))  != -1) 
        nbr_connections = enleve_connection(ligne, Liste, nbr_connections);
      
    } else {

      /* SI c ul'ACK d'un paquet FIN ... */
      if((ligne = cherche_connection(ip, tcp, nbr_connections, 1)) != -1) {
    
	tcp2 = (struct tcphdr *) (connections[ligne] + SIZE_WID + ENTETE_ETH + ENTETE_IP);
 	if (tcp2->fin == 1) {
	  nbr_connections = enleve_connection(ligne, Liste, nbr_connections);	  
	  if ((ligne = cherche_connection(ip, tcp, nbr_connections, 0)) != -1) 
	    nbr_connections = enleve_connection(ligne, Liste, nbr_connections); 
	  
	  return nbr_connections;
	}
      }
      
      /*Si cette connection n'existe pas, on ajoute une ligne */
      if ((ligne = cherche_connection(ip, tcp, nbr_connections, 0)) == -1) 
	nbr_connections = ajoute_connection(trame, Liste, nbr_connections);

      else {
	/* Sinon on actualise qqs trucs .. */
	ptr = (struct widg *)connections[ligne];
      
	bcopy(trame, connections[ligne] + SIZE_WID, TAILLE_TRAME);

	if (len_donnees > 0) {
	  for (i=0 ; i < len_donnees ; i++) 
	    fputc(donnees[i], ptr->fptr);	  
	  fflush(ptr->fptr);
	}
      }
    }
    return nbr_connections;
}
