/* xRaSnif by RaPass <rapass@gmx.net>*/
#include "xRaSnif.h"
#include <signal.h>
#include <semaphore.h>

int sock_for_sniffe, sock_for_send;
char **connections;
pthread_t th1;
pthread_mutex_t my_mutex;
sem_t my_sem;
char *hehe;



void *my_thread_process(GtkWidget **widgets) {

  pthread_setcancelstate (PTHREAD_CANCEL_ENABLE, NULL); 
  pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

  /* -- On attend que l'interface soit creer ...--*/
  sem_wait(&my_sem); 
  /* -- ... Et on y va, on lance le snif --*/
  
  filter(widgets);
  pthread_exit(0);
}

void bingo() {
  fprintf(stderr, "Reception d'un signal de fin\n");
  FinProg(NULL);
}


int main(int argc, char *argv[]) {
  GtkWidget *Liste_TCP;
  GtkWidget *Liste_ICMP;
  GtkWidget **widgets;
  pthread_attr_t thread_attr;
  int optval=1;

  /* --- On verifie que c'est bien le root qui a lance le programme --*/
  if (getuid() || geteuid()) {
    fprintf(stderr, "\033[1;31mVous devez etre root pour executer ce programme.\033[0m\n");
    exit(13);
  }

  if (argc != 2) {
    fprintf(stderr, "Usage: %s [device]\n", argv[0]);
    exit(0);
  }
   
  mkdir("log", 700);
   
  signal(SIGINT, bingo);
  signal(SIGKILL, bingo);
  signal(SIGQUIT, bingo);
  signal(SIGTERM, bingo);
  signal(SIGHUP, SIG_IGN);
  /* --- On met la carte reseau en promiscuous mod ---*/
  hehe = argv[1];
  if ((sock_for_sniffe = socket(AF_INET, SOCK_PACKET, htons(ETH_P_ALL))) < 0)
    perror("Creation socket");

  set_promisc(hehe, sock_for_sniffe);
  
 
  if ((sock_for_send = socket(PF_INET,SOCK_RAW,IPPROTO_TCP)) < 0)
    perror("Creation socket");
  if (setsockopt(sock_for_send,IPPROTO_IP,IP_HDRINCL,&optval,sizeof(optval)) < 0)
    perror("Cannot set flag IP_HDRINCL");
  


  /* --- On cree la thread ---*/
  pthread_mutex_init (&my_mutex, NULL);
  sem_init (&my_sem, 0, 0);

  if (pthread_attr_init (&thread_attr) != 0) {
    fprintf(stderr, "Erreur lors de l'appelle de pthread_attr_init.\n");
    exit (13);
  }

  if (pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED) !=0) {
    fprintf(stderr,"Erreur lors de l'appelle de pthread_attr_setdetachstate.\n");
    exit(13);
  }

  widgets = g_malloc(2 * sizeof(GtkWidget *));
  widgets[1] = Liste_TCP;
  widgets[2] = Liste_ICMP;

  if (pthread_create(&th1, &thread_attr, (void *)my_thread_process, widgets) < 0) {
    fprintf (stderr, "pthread_create error for thread\n");
    exit (1);
  }
  /* -- On cree l'inerface graphique -- */
  xinterface(argc, argv, widgets);
  return 0;
}
