/* xRaSnif by RaPass <rapass@gmx.net> */

#define _BSD_SOURCE
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h> 


#include <sys/types.h>           
#include <sys/socket.h>	
#include <sys/ioctl.h> 
#include <sys/stat.h> 	 

#include <netinet/in.h> 
#include <netinet/ip.h>
#include <netinet/tcp.h>
 
 
 
#include <arpa/inet.h> 
#include <linux/socket.h>  
#include <linux/if_ether.h>
#include <linux/if.h> 

#include <fcntl.h> 

#define	IPHDR	sizeof(struct iphdr)
#define	TCPHDR	sizeof(struct tcphdr)
#define	PSEUDOHDR	sizeof(struct pseudohdr)

struct pseudohdr {
	unsigned long saddr;
	unsigned long daddr;
	unsigned char nada;
	unsigned char protocol;
	unsigned short length;
	};	

extern int sock_for_send;

int set_promisc(char *device, int fd) {
	struct ifreq ifr;	 

	strcpy(ifr.ifr_name, device); 
	if (ioctl(fd, SIOCGIFFLAGS, &ifr) < 0)
	  return -1;

	ifr.ifr_flags |= IFF_PROMISC; 
	if (ioctl(fd, SIOCSIFFLAGS, &ifr) < 0) 
	  return -1;
 
	return 0; 
}

int unset_promisc(char *device, int fd)
{
  struct ifreq ifr;
  
  strcpy(ifr.ifr_name, device);
  
  if (ioctl(fd, SIOCGIFFLAGS, &ifr) < 0)
    return -1;
  
  ifr.ifr_flags &= ~IFF_PROMISC;
  if (ioctl(fd, SIOCSIFFLAGS, &ifr) < 0)
    return -1;
  
  return 0;
}
 

unsigned short in_cksum(addr, len)
    u_short *addr;
    int len;
{
    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;

    /*
     * Our algorithm is simple, using a 32 bit accumulator (sum), we add
     * sequential 16 bit words to it, and at the end, fold back all the
     * carry bits from the top 16 bits into the lower 16 bits.
     */
    while (nleft > 1)  {
        sum += *w++;
        nleft -= 2;
    }

    /* mop up an odd byte, if necessary */
    if (nleft == 1) {
        *(u_char *)(&answer) = *(u_char *)w ;
        sum += answer;
    }

    /* add back carry outs from top 16 bits to low 16 bits */
    sum = (sum >> 16) + (sum & 0xffff);   /* add hi 16 to low 16 */
    sum += (sum >> 16);                   /* add carry */
    answer = ~sum;                        /* truncate to 16 bits */
    return(answer);
}

void envoie_tcp(unsigned long saddr,
               unsigned long daddr,
               unsigned sport,
               unsigned dport,
               unsigned char flags,
               unsigned long seq,
               unsigned long ack,
               unsigned tcp_win,
               char     *donnees,
               int      taille_donnees){

  struct sockaddr_in addr;  /* struct utiliser pour la fonction sendto() */
  struct iphdr *ip;         /* pointeur vers le debut du dgramme IP */
  struct tcphdr *tcp;       /* pointeur vers le debut du paquet TCP */
  struct pseudohdr *pseudo; /* juste pour le checksum TCP */
  
  unsigned char *data;          /* pointeur vers les donnees du paquet TCP */
  unsigned char buffer[2048];   /* buffer est le datagramme IP */

/*--On fait pointer les pointeurs sur les differentes parties du dgramme----*/ 
  ip = (struct iphdr *) buffer;
  tcp = (struct tcphdr *) (buffer + IPHDR);
  pseudo = (struct pseudohdr *)(buffer + IPHDR - PSEUDOHDR);
  data = (unsigned char *) (buffer + IPHDR + TCPHDR);
/*---------------------------------------------------------------------------*/

/*---------------------Fabrication du sockaddr_in----------------------------*/
  addr.sin_family = AF_INET;
  addr.sin_port = htons(dport);
  addr.sin_addr.s_addr = daddr;
/*---------------------------------------------------------------------------*/

/*-----------------Mise a 0 de tout les octets du datagramme ----------------*/
  memset(buffer, 0, 2048);
/*---------------------------------------------------------------------------*/

/*--------------Placement des donnees apres l'entete TCP---------------------*/
  memcpy(buffer + IPHDR + TCPHDR, donnees, taille_donnees);
/*---------------------------------------------------------------------------*/

/*---------------------------------Fabrication de l'entete TCP --------------*/
  tcp->th_sport = htons(sport);
  tcp->th_dport = htons(dport);
  tcp->th_seq = htonl(seq);
  tcp->th_ack = htonl(ack);
  tcp->th_off = 5;
  tcp->th_flags = flags;
  tcp->th_win = htons(tcp_win);
	/*** Calcul du checksum de l'entete TCP ***/
  pseudo->saddr = saddr;
  pseudo->daddr = daddr;
  pseudo->protocol = IPPROTO_TCP;
  pseudo->length = htons(TCPHDR + taille_donnees); 
  tcp->th_sum = in_cksum ((unsigned short *)pseudo, 
                          TCPHDR + PSEUDOHDR + taille_donnees);
/*---------------------------------------------------------------------------*/

/*------------------Fabrication de l'entete IP-------------------------------*/
  memset(ip, 0, IPHDR);
  ip->version = 4;
  ip->ihl = 5;
  ip->tos = 0;
  ip->tot_len = htons(IPHDR + TCPHDR + taille_donnees);
  ip->id = getpid(); 
  ip->frag_off = 0;
  ip->ttl = 255;
  ip->protocol = IPPROTO_TCP;
  ip->saddr = saddr;
  ip->daddr = daddr;
  ip->check = (unsigned short) in_cksum((unsigned short *)ip, IPHDR);
/*---------------------------------------------------------------------------*/

/*-------------------------Envoie du datagramme -----------------------------*/
  if (sendto(sock_for_send, buffer, 
             ntohs(ip->tot_len), 0, (struct sockaddr *)&addr, 
             sizeof(addr)) < 0)
    perror("Envoie du datagramme");
/*---------------------------------------------------------------------------*/
}
