(**************************************************************************)
(*                                                                        *)
(*   CERCLES.PAS                                                          *)
(*   Auteur Olivier Pcheux                                               *)
(*   opecheux@multimania.com                                              *)
(*   http://www.multimania.com/opecheux                                   *)
(*                                                                        *)
(*   Ce programme donne l'implantation des tracs de cercles en mode 13h  *)
(*                                                                        *)
(**************************************************************************)

Function ReadKey:Char; Inline($B4/7/$CD/33); { L'unite CRT de borland ne
  fonctionne pas sur les ordinateurs rapides (erreur 200) }
Function KeyPressed:Boolean; Inline($B4/11/$CD/33); { " }

Var Couleur_cercle:Byte; { Variable globale pour aller plus vite }

(**************************************************************************)
(*                                                                        *)
(*    Dessine un point avec clipping                                      *)
(*                                                                        *)
(**************************************************************************)
{ Cette procedure est ici pour l'exemple. Elle n'est pas utilise car le
trac de cercles est symtrique }
Procedure Point(X,Y:Integer);
 Begin
  { Test des limites }
  If (X>=0) And (X<320) And (Y>=0) And (Y<200) Then
  { Dessin }
  Mem[$A000:(((Y Shl 2)+Y) Shl 6)+X]:=Couleur_cercle
 End;


(**************************************************************************)
(*                                                                        *)
(*    Dessine 2 points (X+dX,Y) et (X-dX,Y) avec clipping                 *)
(*                                                                        *)
(**************************************************************************)
Procedure DPoint(X,dX,Y:Integer);
 Var Y80:Integer; { Offset du point central calcul une fois }
 Begin
  If (Y>=0) And (Y<200) Then { Dans les limites veticales }
   Begin
    Y80:=(((Y Shl 2)+Y) Shl 6)+X; { Offset du point central (X,Y) }
    { si (X+dX,Y) est dans les limites horizontales, on le trace }
    If (X+dX>=0) And (X+dX<320) Then Mem[$A000:Y80+dX]:=Couleur_cercle;
    { si (X-dX,Y) est dans les limites horizontales, on le trace }
    If (X-dX>=0) And (X-dX<320) Then Mem[$A000:Y80-dX]:=Couleur_cercle
   End
 End;


(**************************************************************************)
(*                                                                        *)
(*    Dessine un cercle (pour les modes o les pixels sont carrs)        *)
(*                                                                        *)
(**************************************************************************)
Procedure Cercle(X,Y,R:Integer; Couleur:Byte);
 Var Erreur, { En fait on trace une verticale et on calcule une erreur }
     dX, dY:Integer; { Coordonn d'un point dans le repre li au centre }
 Begin
  Couleur_cercle:=Couleur; { Et un paramtre en moins  passer }
  Erreur:=-(R Shr 1); { Erreur selon Martin }
  dX:=R; dY:=0; { Point (R,0) de dpart }
   Repeat
    DPoint(X,dX,Y+dY); { Trac du point }
    DPoint(X,dX,Y-dY); { Et des symtriques }
    DPoint(X,dY,Y+dX);
    DPoint(X,dY,Y-dX);
    Inc(dY); Inc(Erreur,dY); { Incrmentation systmatique de Y }
    If Erreur>0 Then { Erreur suprieur  un demi pixel }
     Begin Dec(Erreur,dX); Dec(dX) End { Donc dcrmentation de X }
   Until dY>dX { Fin quand on arrive  45 degr }
 End;


(**************************************************************************)
(*                                                                        *)
(*    Trac d'un cercle avec les approximations utiles                    *)
(*                                                                        *)
(**************************************************************************)
Procedure Ellipse(X,Y,Rx:integer; Couleur:Byte);
 Var Erreur, { Erreur sur le rayon }
     dX,dY:Integer; { Coordonns d'un point dans le repre du centre }
 Begin
  Couleur_cercle:=Couleur; { Et un paramtre en moins  passer }
  { Trac  partir des extrmes droit et gauche }
  Erreur:=-(Rx Shr 1); { Erreur nulle }
  dX:=Rx; dY:=0; { Point le plus  droite }
   Repeat
    DPoint(X,dX,Y+dY); { Trac des 4 points }
    DPoint(X,dX,Y-dY);
    Inc(dY); Inc(Erreur,dY);{ Incr. systmatique de Y }
    If Erreur>0 Then { Si l'erreur est trop grande }
     Begin Dec(dX); Dec(Erreur,(dX*89) shr 7) End {on dcrmente X }
   Until Erreur>0; { Fin si on devrait se dplacer deux fois (45 degr) }
  { Trac en continuant }
   Repeat
    DPoint(X,dX,Y+dY); { Trac des 4 points }
    DPoint(X,dX,Y-dY);
    Dec(dX); Dec(Erreur,dX); { Dcr. systmatique de Y }
    If Erreur<0 Then { Si l'erreur est trop grande }
     Begin Inc(dY); Inc(Erreur,(dY shl 7) div 89) End { On incrmente X }
   Until dX<0; { Fin si on devrait se dplacer deux fois (45 degr) }
 End;


Var X,Y,R,
    Couleur:Integer;
Begin
  { Passage en mode 13 }
  asm MOV AX,$13; INT $10 end;

  { Trac de cercles dforms }
  For R:=1 to 25 do Cercle(160,100,R*8,15);

  Readkey;

  {effacer l'cran }
  asm MOV AX,$13; INT $10 end;

  { Trac de cercles fait avec des ellipses }
  For R:=1 to 25 do Ellipse(160,100,R*8,15);
  Readkey;

  {effacer l'cran }
  asm MOV AX,$13; INT $10 end;

  { Pour faire joli, je n'explique pas }
  For R:=1 to 200 do Ellipse(160,100,R,R+20);
  Readkey;
  X:=40; Y:=50;
   Repeat
    Repeat Dec(Couleur,69); For R:=1 to 70 Do
       Begin Inc(Couleur); Ellipse(X,Y,71-R,Couleur) End;
     Inc(X) Until (X=280) or Keypressed;
    Repeat Dec(Couleur,69); For R:=1 to 70 Do
      Begin Inc(Couleur); Ellipse(X,Y,71-R,Couleur) End;
     Inc(Y) Until (Y=150) or Keypressed;
    Repeat Dec(Couleur,69); For R:=1 to 70 Do
      Begin Inc(Couleur); Ellipse(X,Y,71-R,Couleur) End;
     Dec(X) Until (X=40) or Keypressed;
    Repeat Dec(Couleur,69); For R:=1 to 70 Do
      Begin Inc(Couleur); Ellipse(X,Y,71-R,Couleur) End;
     Dec(Y) Until (Y=50) or Keypressed;
   Until Keypressed;

 { Retour au mode 80 colonnes texte }
  asm MOV AX,3; INT $10 end
End.
