/**************************************************************************/
/*                                                                        */
/*   CERCLES.C                                                            */
/*   Auteur Olivier Pcheux                                               */
/*   opecheux@multimania.com                                              */
/*   http://www.multimania.com/opecheux                                   */
/*                                                                        */
/*   Ce programme donne l'implantation des tracs de cercles en mode 13h  */
/*                                                                        */
/**************************************************************************/
#include <stdio.h>
#include <dos.h> /* intr et pokeb */
#include <bios.h> /* bioskey */

#define ecran 0xa000

typedef unsigned char byte;
typedef unsigned short word;

byte couleur_cercle; /* pour aller plus vite */

/**************************************************************************/
/*                                                                        */
/*    Dessine un point avec clipping                                      */
/*                                                                        */
/**************************************************************************/
/* Cette void function est ici pour l'exemple. Elle n'est pas utilise car le
trac de cercles est symtrique */
void  point(int X, int Y)
{
  /* Test des limites */
  if ((X>=0) && (X<320) && (Y>=0) && (Y<200))
  /* Dessin */
  pokeb(ecran,(Y << 8)+(Y << 6)+X,couleur_cercle);
}


/**************************************************************************/
/*                                                                        */
/*    Dessine 2 points (X+dX,Y) et (X-dX,Y) avec clipping                 */
/*                                                                        */
/**************************************************************************/
void dpoint(int X, int dX, int Y)
{
  int Y80; /* Offset du point central calcul une fois */

  if ((Y>=0) && (Y<200))  /* Dans les limites veticales */
  {
    Y80=(Y << 8)+(Y << 6)+X; /* Offset du point central (X,Y) */
    /* si (X+dX,Y) est dans les limites horizontales, on le trace */
    if ((X+dX>=0) && (X+dX<320))  pokeb(ecran,Y80+dX,couleur_cercle);
    /* si (X-dX,Y) est dans les limites horizontales, on le trace */
    if ((X-dX>=0) && (X-dX<320))  pokeb(ecran,Y80-dX,couleur_cercle);
  }
}


/**************************************************************************/
/*                                                                        */
/*    Dessine un cercle (pour les modes o les pixels sont carrs)        */
/*                                                                        */
/**************************************************************************/
void cercle(int X, int Y, int R, byte couleur)
{
  int erreur, /* En fait on trace une verticale et on calcule une erreur */
     dX, dY; /* Coordonn d'un point dans le repre li au centre */

  couleur_cercle=couleur; /* Et un paramtre en moins  passer */
  erreur=-(R >> 1); /* Erreur selon Martin */
  dX=R; dY=0; /* Point (R,0) de dpart */
  do {
    dpoint(X,dX,Y+dY); /* Trac du point */
    dpoint(X,dX,Y-dY); /* Et des symtriques */
    dpoint(X,dY,Y+dX);
    dpoint(X,dY,Y-dX);
    erreur+=++dY; /* Incrmentation systmatique de Y */
    if (erreur>0)  /* Erreur suprieur  un demi pixel */
      erreur-=dX--;  /* Donc dcrmentation de X */
  } while (dY<=dX); /* Fin quand on arrive  45 degr */
}


/**************************************************************************/
/*                                                                        */
/*    Trac d'un cercle avec les approximations utiles                    */
/*                                                                        */
/**************************************************************************/
void ellipse(int X, int Y, int Rx, byte couleur)
{
  int erreur, /* Erreur sur le rayon */
     dX,dY; /* Coordonns d'un point dans le repre du centre */

  couleur_cercle=couleur; /* Et un paramtre en moins  passer */
  /* Trac  partir des extrmes droit et gauche */
  erreur=-(Rx >> 1); /* Erreur nulle */
  dX=Rx; dY=0; /* Point le plus  droite */
  do {
    dpoint(X,dX,Y+dY); /* Trac des 4 points */
    dpoint(X,dX,Y-dY);
    erreur+=++dY;/* Incr. systmatique de Y */
    if (erreur>0)  /* Si l'erreur est trop grande */
      erreur-=(--dX*89)>>7; /*on dcrmente X */
  } while (erreur<=0); /* Fin si on devrait se dplacer deux fois (45 degr) */
  /* Trac en continuant */
  do {
    dpoint(X,dX,Y+dY); /* Trac des 4 points */
    dpoint(X,dX,Y-dY);
    erreur-=--dX; /* Dcr. systmatique de Y */
    if (erreur<0)  /* Si l'erreur est trop grande */
      erreur+=(++dY<<7)/89; /*on incmente X */
  } while (dX>=0); /* Fin si on est sur l'axe */
};


int X,Y,R,
    couleur;
struct REGPACK registres;

int main(void)
{
  /* Passage en mode 13 */
  registres.r_ax=0x13;
  intr(0x10,&registres);

  /* Trac de cercles dforms */
  for (R=1; R<=25; cercle(160,100,R++*8,15));

  getch();

  /*effacer l'cran */
  registres.r_ax=0x13;
  intr(0x10,&registres);

  /* Trac de cercles fait avec des ellipses */
  for (R=1; R<=25; ellipse(160,100,R++*8,15));
  getch();

  /*effacer l'cran */
  registres.r_ax=0x13;
  intr(0x10,&registres);

  /* Pour faire joli, je n'explique pas */
  for (R=1; R<=200; ellipse(160,100,R,R+++20));
  getch();
  X=40; Y=50;
  do {
    do { couleur-=69;
      for (R=70; R>0; ellipse(X,Y,--R,++couleur));
     } while ((X++<=280) && (bioskey(1)==0));
    do { couleur-=69;
      for (R=70; R>0; ellipse(X,Y,--R,++couleur));
     } while ((Y++<=150) && (bioskey(1)==0));
    do { couleur-=69;
      for (R=70; R>0; ellipse(X,Y,--R,++couleur));
     } while ((X-->=40) && (bioskey(1)==0));
    do { couleur-=69;
      for (R=70; R>0; ellipse(X,Y,--R,++couleur));
     } while ((Y-->=50) && (bioskey(1)==0));
  } while (bioskey(1)==0); getch();

  /* Retour au mode 80 colonnes texte */
  registres.r_ax=3;
  intr(0x10,&registres);
}
