/***********************************************
*                                              *
* CREATION D'UN BUFFER-UTILISATION DU MODE 13h *
*                                              *
***********************************************/


#include <alloc.h>
#include <mem.h>
#include <dos.h>


/******************************/
/* IMPLEMENTATION D'UN BUFFER */
/******************************/


/* Pointeur sur le buffer */
unsigned char far * _Buf= NULL;


/* Fonction de creation du buffer */
int cree_buf()
{
 _Buf= (unsigned char far *) farmalloc( 64000 );

 if( _Buf==NULL )
	return 1;  // si l'alloc n'a pas marchee retourne 1
 else
	return 0;
}



/* Donne l'acces a la mem video au lieu de donner acces au buffer */
/* On peut toujours utiliser les fonctions bputpixel/bclsc */
void acces_vid()
{
 if( _Buf!=NULL ) farfree( _Buf ); /* evite la 'perte' du buffer */

 _Buf= (unsigned char far *) MK_FP( 0xA000 , 0x0 );
}



/* detruit le buffer */
int del_buf()
{
 if( _Buf == NULL )
	return 1;

 farfree( _Buf );

 return 0;
}




/************************************/
/* FONCTIONS D'ACCES A LA MEM VIDEO */
/************************************/

/* Creation d'un point d'acces a la mem video (en mode 13h) */
unsigned char far * _Vid= (unsigned char far *) MK_FP( 0xA000 , 0 );


/* Copie du buffer dans la mem video */
void aff_buf()
{
 /* Copie un bloc de 64000 octets de _Buf vers _Vid */
 _fmemcpy( _Vid , _Buf , 64000 );

}


/* Activation du mode 13h mode accesible sur toutes(?) cartes (S)VGA */
void vga()
{
 asm {
	mov  ax, 0x0013  /* Mode demand (13h : 320x200 256c) */
	int  0x10        /* Interuption video */
     }
}



/* Mode texte standard */
void texte()
{
 asm {
	mov  ax, 0x0003
	int  0x10
     }
}



/***************************************/
/* FONCTIONS D'ECRITURE DANS LE BUFFER */
/***************************************/

/* BPUTPIXEL */
/* 'Affiche' un pixel dans le buffer */
void bputpixel( int X , int Y , char col )
{
 _Buf[(Y << 8) + (Y << 6) + X]= col;  /* equi : _Buf[320*Y+X]= col */
}



/* BCLSC */
/* remplit l'ecran avec la couleur col */
void bclsc( char col )
{
 int i,j;

 _fmemset( _Buf , col , 64000 );
}


/* BCLS */
/* Efface l'ecran (noir) */
void bcls( void )
{
 bclsc( 0 );
}
