/**********************************************************
*                                                         *
*             UTILISATION DE L'ANIMATION                  *
*                                                         *
* UTILISATION DU BUFFER & DEMO POUR UTILISATION D'UN FOND *
*                                                         *
**********************************************************/

/* MODELE MEMOIRE RECOMMENDE : COMPACT */


#include <conio.h>
#include <alloc.h>


#include "buffer.c"


/* Defini le nombre max de sprites dans une anim */
#define NB_MAX_SPR 10

/* defini la duree de la temporisation pour l'animation */
#define TEMP 5


/* Structure sprite */
typedef struct
	{
	 int lar;
	 int lg;
	 char * des;
	} sprite;

/* Structure sp_anime */
typedef struct
	{
	 int tmp; 
	 int cour;
	 int nb;
	 sprite * tab[NB_MAX_SPR];
	} sp_anime;

/* Ici j'ai rajoute tmp qui est une variable de temporisation pour rendre
   plus visible l'animation */


/* definitions des Sprites */
unsigned char sp1[10][10]=
	{{ 0, 0, 0, 1, 1, 1, 1, 0, 0, 0},
	 { 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
	 { 0, 1, 1, 0, 0, 0, 0, 1, 1, 0},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 0, 1, 1, 0, 0, 0, 0, 1, 1, 0},
	 { 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
	 { 0, 0, 0, 1, 1, 1, 1, 0, 0, 0},
	};


unsigned char sp2[8][10]=
	{{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	 { 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
	 { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 1, 1, 0, 0, 0, 0, 0, 0, 1, 1},
	 { 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
	 { 0, 0, 1, 1, 1, 1, 1, 1, 0, 0},
	};





/* Cree un sprites (se contente de remplir la structure) */
int creat_spr( sprite * sp , char * tab , int t_x , int t_y )
{

 sp->des= tab;  /* Declaration simpliste du sprite a remplacer par tte */
		    /* autre declaration */
 sp->lar= t_x;
 sp->lg= t_y;

 return 0;
}


/* Dessine le sprite dans le buffer */
void des_spr( int x , int y , sprite * sp )
{
 int i,j;

 for( i= 0 ; i<sp->lar ; i++ )
   for( j= 0 ; j<sp->lg ; j++ )
     if( sp->des[j*sp->lar+i] != 0 )
	 bputpixel( x+i , y+j , sp->des[j*sp->lar+i] );

}



/* Cree un sprite de la taille de l'ecran avec un motif (vraiment) bidon */
void bkgrd( sprite *sp )
{
 long i;

 sp->lg= 200;
 sp->lar= 320;
 sp->des= (char *) malloc( 64000 );

 if( sp->des==NULL )
	{
	 texte();
	 printf("\Pas asser de memoire pour creer le fond...\n");
	 exit( 1 );
	}

 for( i= 0 ; i<64000 ; i++ )
	sp->des[i]= i%50+30;
}


/* dessine l'anim */
void des_ani( int x , int y , sp_anime * spa )
{

 des_spr( x , y , spa->tab[ spa->cour ] );

 spa->tmp++;  /* Incrementation de la temporisation */

 if( spa->tmp== TEMP )  /* Si la temporisation est passee */
  {
   spa->tmp= 0; /* Mise a zero de la tempo */
   spa->cour++; /* on change de sprite la prochaine fois */

   if( spa->cour == spa->nb ) 
	spa->cour= 0;
  }
}




void main()
{

 int x,y; /* coo de l'anim */
 int incx,incy;

 sprite s1;
 sprite s2;
 sprite bk;
 sp_anime ani;

 /* Creation des sprites */
 creat_spr( &s1 , &sp1[0][0] , 10 , 10 ); 
 creat_spr( &s2 , &sp2[0][0] , 10 , 8 );

 /* creation de l'anim 'a la main' */
 ani.nb= 2;
 ani.cour= 0;
 ani.tmp= 0;
 ani.tab[0]= &s1;
 ani.tab[1]= &s2;

 /* creation du fond */
 bkgrd( &bk );

 /* creation du buffer */
 if( cree_buf() )
	{
	 printf("Pas asser de memoire pour creer le buffer..\n");
	}

 /* passage en mode vga */
 vga();

 x= y= 10;
 incx= 2;
 incy= 1;

/* boucle principale */

 do
  {
/* ETAPE 1 : affichage dans le buffer */
   des_spr( 0 , 0 , &bk );
    /* bclsc( 3 ); */
    /* remplacer la ligne precedante par celle d'avant pour voir */
    /* la nullite de des_spr pour les gros sprites */

   des_ani( x , y , &ani );

/* ETAPE 2 : affichage du buffer a l'ecran */
   aff_buf();

   x+= incx;
   y+= incy;

   if( x<=2 || x>=308 ) incx= -incx;
   if( y<=2 || y>=188 ) incy= -incy;


  }
  while( !kbhit() ); /* tant qu'on a pas appuye sur une touche */

 getch(); /* reception du caractere lu par kbhit */

 del_buf(); /* Libere l'espace memoire du buffer */
 farfree( bk.des ); /* Libere l'espace memoire pour le fond */

 texte();
}





