(**************************************************************************)
(*                                                                        *)
(*   DROITE_P.PAS                                                         *)
(*   Auteur Olivier Pcheux                                               *)
(*   opecheux@multimania.com                                              *)
(*   http://www.multimania.com/opecheux                                   *)
(*                                                                        *)
(*   Ce programme donne la ralisation de l'algorithme de Martin          *)
(*   pour tracer des droites et donne une implantaion possible            *)
(*   pour les droites particulires, les cadres et les rectangles         *)
(*                                                                        *)
(**************************************************************************)


uses graph,
     crt; { A cause du keypressed de la fin }

const largeur_ecran=320;

var ecran:array[0..63999]of byte absolute $A000:$0000;



{ Trac de droites quelconques }
procedure droite(x1,y1,x2,y2:integer; couleur:byte);
{ dessine une ligne incline }
 const incremente=$46FF; { Ces 4 constantes permettent de modifier le code }
       decremente=$4EFF; {  en changeant les inc en dec ventuellement }
       ajoute=$4681;
       soustrait=$6E81;
 var offset_P, { offset du point P que l'on dessine }
     offset_P_plus_Q:word; { pour le point Q on ajoute les 2 offsets (const) }
     temporaire, { variable pour changer ventuellement x et xp }
     deltaX,deltaY, { variations totales suivant x et suivant y }
     delta_delta, {diffrnece deltaY-deltaX ou l'inverse }
     reste_a_faire, { nombre de boucles  faire }
     erreur:integer; { contient une valeur ngative si l'erreur est
       infrieur  un demi-pixel }
 label inc_dec_X, inc_dec_Y; { Lieux de remplacements }
 Begin
  { choix du sens de dessin }
  deltaX:=abs(x2-x1); deltaY:=abs(y2-y1);
  delta_delta:=deltaX-deltaY;

  if delta_delta>=0 then
   begin { droite peu incline }
    { on veut aller de la gauche vers la droite }
    if x2<x1 then { on change le point de dpart et d'arrive }
     begin
      temporaire:=x1; x1:=x2; x2:=temporaire; { change les abscices }
      temporaire:=y1; y1:=y2; y2:=temporaire; { change les ordonns }
     end;
    if y2>=y1 then asm { on utilisera inc(,) }
      { le WORD PTR permet d'indiquer la taille du transfert }
      MOV WORD PTR [CS:offset inc_dec_Y],ajoute
     end
    else asm { on utilisera dec(,) }
      MOV WORD PTR [CS:offset inc_dec_Y],soustrait
     end;
    { initialisations }
    reste_a_faire:=(deltaX+1) shr 1;
    erreur:=deltaY-(deltaX shr 1);
    offset_P:=(((y1 shl 2)+y1) shl 6)+x1; { 320*y1+x1 }
    offset_P_plus_Q:=(((y2 shl 2)+y2) shl 6)+x2+offset_P; { 320*y2+x2 +... }

     repeat
      ecran[offset_P]:=couleur; { dessiner le point P }
      ecran[offset_P_plus_Q-offset_P]:=couleur; { et Q }
      inc(offset_P); { incrmenter X }
      if erreur>0 then
       begin
        inc_dec_Y: inc(offset_P,largeur_ecran);{ incrmenter ou dcrmenter Y }
        dec(erreur,delta_delta)
       end
      else inc(erreur,deltaY);
      dec(reste_a_faire);
     until reste_a_faire=0;
    { dessin du dernier point si le nombre de points est impair }
    if (deltaX and 1)=0 then ecran[offset_P]:=couleur
   end { droite peu incline }



  else { delta_delta<0 }
   begin { droite trs incline }
    delta_delta:=-delta_delta; {il doit tre positif }
    { on veut aller du bas en haut }
    if y2<y1 then { on change le point de dpart et d'arrive }
     begin
      temporaire:=x1; x1:=x2; x2:=temporaire; { change les abscices }
      temporaire:=y1; y1:=y2; y2:=temporaire; { change les ordonns }
     end;
    if x2>=x1 then asm { on utilisera inc() }
      MOV WORD PTR [CS:offset inc_dec_X],incremente
     end
    else asm { on utilisera dec() }
      MOV WORD PTR [CS:offset inc_dec_X],decremente
     end;
    { initialisations }
    reste_a_faire:=(deltaY +1) shr 1;
    erreur:=deltaX-(deltaY shr 1);
    offset_P:=(((y1 shl 2)+y1) shl 6)+x1;
    offset_P_plus_Q:=(((y2 shl 2)+y2) shl 6)+x2+offset_P;

     repeat
      ecran[offset_P]:=couleur; { dessiner le point P }
      ecran[offset_P_plus_Q-offset_P]:=couleur; { et Q }
      inc(offset_P,largeur_ecran); { incrmenter Y }
      if erreur>0 then
       begin
        inc_dec_X: inc(offset_P); { incrmenter x }
        dec(erreur,delta_delta)
       end
      else inc(erreur,deltaX);
      dec(reste_a_faire);
     until reste_a_faire=0;
    { dessin du dernier point si le nombre de points est impair }
    if (deltaY and 1)=0 then ecran[offset_P]:=couleur
   end;  { droite trs incline }
 end;


{ Trac de droites horizontales avec x2>x1 }
procedure droite_horizontale(x1,y,x2:integer; couleur:byte);
 begin
  fillchar(ecran[(((y shl 2)+y) shl 6)+x1],x2-x1+1,couleur)
 end;


{ Trac de droites verticales avec y2>y1 }
procedure droite_verticale(x,y1,y2:integer; couleur:byte);
 begin
  y1:=(((y1 shl 2)+y1) shl 6)+x; { offset de dpart }
  y2:=(((y2 shl 2)+y2) shl 6)+x; { offset d'arrive }
   repeat
    ecran[y1]:=couleur;
    inc(y1,largeur_ecran)
   until Word(y1)>word(y2)
 end;


{ trac de cadres avec x2>x1 et y2>y1 }
procedure cadre(x1,y1,x2,y2:integer; couleur:byte);
 begin
  droite_horizontale(x1,y1,x2,couleur);
  droite_verticale(x1,y1+1,y2-1,couleur);
  droite_verticale(x2,y1+1,y2-1,couleur);
  droite_horizontale(x1,y2,x2,couleur)
 end;


{ trac de rectangles x2>x1 et y2>y1 }
procedure rectangle(x1,y1,x2,y2:integer; couleur:byte);
 begin
  y1:=(((y1 shl 2)+y1) shl 6)+x1; { offset de dpart }
  y2:=(((y2 shl 2)+y2) shl 6)+x1; {offset d'arrive }
  dec(x2,x1-1); { x2 contient dornavent la largeur }
   repeat
    fillchar(ecran[y1],x2,couleur);
    inc(y1,largeur_ecran)
   until Word(y1)>word(y2)
 end;





var i,j,
    pilote, mode:integer;
    couleur:byte;

Begin
 { Passage en mode 13 }
  asm MOV AX,$13; INT $10 end;

 { test des lignes horizontales }
 j:=0;
  repeat
   for i:=j to 199-j do
    begin inc(couleur); droite_horizontale(j,i,319-j,couleur) end;
   for i:=j to 199-j do
    begin inc(couleur); droite_horizontale(j,199-i,319-j,couleur) end;
   j:=(j+1) mod 99;
  until keypressed; readkey;


 { test des lignes verticales }
 j:=0;
  repeat
   for i:=j to 319-j do
    begin inc(couleur); droite_verticale(i,j,199-j,couleur) end;
   for i:=j to 319-j do
    begin inc(couleur); droite_verticale(319-i,j,199-j,couleur) end;
   j:=(j+1) mod 99;
  until keypressed; readkey;


 { test des cadres }
  repeat
   for j:=0 to 99 do for i:=0 to 49 do
    begin inc(couleur); cadre(i+j,i,219-i+j,99-i,couleur) end;
   for j:=0 to 99 do for i:=0 to 49 do
    begin inc(couleur); cadre(i+100,i+j,319-i,99-i+j,couleur) end;
   for j:=0 to 99 do for i:=0 to 49 do
    begin inc(couleur); cadre(100+i-j,100+i,319-i-j,199-i,couleur) end;
   for j:=0 to 99 do for i:=0 to 49 do
    begin inc(couleur); cadre(i,i+100-j,219-i,199-i-j,couleur) end;
  until keypressed; readkey;



 { test des rectangles }
  repeat
   for j:=0 to 99 do
    begin inc(couleur); rectangle(j,0,219+j,99,couleur) end;
   for j:=0 to 99 do
    begin inc(couleur); rectangle(100,j,319,99+j,couleur) end;
   for j:=0 to 99 do
    begin inc(couleur); rectangle(100-j,100,319-j,199,couleur) end;
   for j:=0 to 99 do
    begin inc(couleur); rectangle(0,100-j,219,199 -j,couleur) end;
  until keypressed; readkey;



 { test des lignes quelconques }
 j:=0;
  repeat
   for i:=0 to 319-j do
    begin inc(couleur); droite(i+j,j,319-i,199,couleur) end;
   for i:=0 to 199-j do
    begin inc(couleur); droite(319,i+j,j,199-i,couleur) end;
   j:=(j+1) mod 199;
  until keypressed; readkey;

 { Retour au mode texte }
  asm MOV AX,3; INT $10 end
End.