/**************************************************************************/
/*                                                                        */
/*   POINT.C                                                              */
/*   Auteur Olivier Pcheux                                               */
/*   opecheux@multimania.com                                              */
/*                                                                        */
/*   Ce programme chronomtre diffrents moyens de faire offset=320y+x.   */
/*   Il fonctionne uniquement sous DOS  cause de la variable time.       */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <dos.h> /* MK_FP */

typedef unsigned char byte;
typedef unsigned short word;

word offset,y,x; /* On calcule la formule offset=320.y+x */
unsigned long boucle, /* pour chronomtrer, on va compter les boucles */
     nb_de_boucles; /* nombre total */
word far*time=(word far*)MK_FP(0x0000,0x046C); /* horloge systme */
word temps, /* mmorier l'instant du dpart et le temps total en 1/18s */
     temps_boucle, /* temps  dduire pour avoir la formule */
     temps_reference; /* temps de la premire formule */




void main(void)
{
  printf("\n\nLangage C:\n");
  while (*time>0xfff0); /* nous permet d'viter le problme de la
			 comparaison temps+10>*time */

  /* On va dans un premier temps compter le nombre de boucles que l'on fait
    pendant 1/2s. Ce nombre multipli par 32 servira de base. On va donc
    mesurer sur des temps de l'ordre de 15s */
  temps=*time;
  while (temps==*time); /* il faut attendre une incrmentation de *time */
  nb_de_boucles=0; /* comptage du nombre de boucles */
  while (temps+10>*time) { offset=(y<<8)+(y<<6)+x; nb_de_boucles++; }
  nb_de_boucles<<=5; /* le temps est multipli par 32 */
  printf("Etalonnage fait, calcul sur %.0f millions de boucles\n",
    nb_de_boucles/1e6);

  /* chronomtrage de la boucle */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--) ;
  temps_boucle=*time-temps; /* calcul du temps de calcul */

  /* chronomtrage de la fomule 1 */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--) offset=(y<<8)+(y<<6)+x;
  temps_reference=*time-temps-temps_boucle; /* calcul du temps de calcul */
  printf("offset=(y<<8)+(y<<6)+x : 100%% (%.2fus)\n",
    (temps_reference*1e6)/nb_de_boucles);

  /* chronomtrage de la fomule 2 */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--) offset=(((y<<2)+y)<<6)+x;
  temps=*time-temps-temps_boucle; /* calcul du temps de calcul */
  printf("offset=(((y<<2)+y)<<6)+x : %.0f%%\n",
    (temps*100.0)/temps_reference);

  /* chronomtrage de la fomule 3 */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--)
    offset=(((y<<1<<1)+y)<<6)+x;
  temps=*time-temps-temps_boucle; /* calcul du temps de calcul */
  printf("offset=(((y<<1<<1)+y)<<6)+x : %.0f%%\n",
    (temps*100.0)/temps_reference);

  /* chronomtrage de la fomule 4 */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--)
    offset=(((y<<1<<1)+y)<<1<<1<<1<<1<<1<<1)+x;
  temps=*time-temps-temps_boucle; /* calcul du temps de calcul */
  printf("offset=(((y<<1<<1)+y)<<1...)+x : %.0f%%\n",
    (temps*100.0)/temps_reference);

  /* chronomtrage de la fomule 5 */
  temps=*time;
  while (temps==*time); /* attente de l'incrmentation */
  for (boucle=nb_de_boucles; boucle!=0; boucle--) offset=320*y+x;
  temps=*time-temps-temps_boucle; /* calcul du temps de calcul */
  printf("offset=320*y+x : %.0f%%\n",
    (temps*100.0)/temps_reference);

}