unit DocEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, Printers;

type
  TFicheEdition = class(TForm)
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Edition1: TMenuItem;
    Aide1: TMenuItem;
    Nouveau1: TMenuItem;
    Ouvrir1: TMenuItem;
    Enregistrer1: TMenuItem;
    Enregistrersous1: TMenuItem;
    N1: TMenuItem;
    Imprimer1: TMenuItem;
    N2: TMenuItem;
    Quitter1: TMenuItem;
    Couper1: TMenuItem;
    Copier1: TMenuItem;
    Coller1: TMenuItem;
    Apropos1: TMenuItem;
    Document: TMemo;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure Ouvrir1Click(Sender: TObject);
    procedure Enregistrersous1Click(Sender: TObject);
    procedure Enregistrer1Click(Sender: TObject);
    procedure Nouveau1Click(Sender: TObject);
    procedure Imprimer1Click(Sender: TObject);
    procedure Quitter1Click(Sender: TObject);
    procedure Couper1Click(Sender: TObject);
    procedure Copier1Click(Sender: TObject);
    procedure Coller1Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  FicheEdition: TFicheEdition;

implementation

{$R *.DFM}

procedure TFicheEdition.Ouvrir1Click(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    Document.Lines.LoadFromFile(OpenDialog.FileName); //charge le fichier dans le mmo
    Document.SelStart :=0 //remet le curseur au dbut du texte
  end;
end;

procedure TFicheEdition.Enregistrersous1Click(Sender: TObject);
begin
  if SaveDialog.Execute then begin
    Document.Lines.SaveToFile(SaveDialog.FileName);
  end;
end;

procedure TFicheEdition.Enregistrer1Click(Sender: TObject);
begin
  // Si c'est la premire fois que l'on sauve le fichier, le programme affiche
  // le boite de sauvegarde.
  If OpenDialog.FileName<>'' then
    Document.Lines.SaveToFile(OpenDialog.FileName)
  else Enregistrersous1Click(Sender);
end;

procedure TFicheEdition.Nouveau1Click(Sender: TObject);
begin
  Document.Clear;
end;

procedure TFicheEdition.Imprimer1Click(Sender: TObject);
var
  Text: TextFile;
  NbLignes, i: integer;
begin
  NbLignes:=Document.Lines.Count; // compte le nombre de lignes  imprimer

  AssignPrn(Text);  // on utilise ici l'imprimante comme s'il s'agissait d'crire dans un fichier
  Rewrite(Text);

  i:=0; // comence  partir de la ligne 0
  Repeat
    WriteLn(Text, Document.Lines[i]);
    i:= i+1;// incrmente d'une ligne
  until i= NbLignes; // jusqu' la dernire ligne
  CloseFile(Text);
end;

procedure TFicheEdition.Quitter1Click(Sender: TObject);
begin
  Close;
end;

procedure TFicheEdition.Couper1Click(Sender: TObject);
begin
  Document.CutToClipboard;
end;

procedure TFicheEdition.Copier1Click(Sender: TObject);
begin
  Document.CopyToClipboard;
end;

procedure TFicheEdition.Coller1Click(Sender: TObject);
begin
  Document.PasteFromClipboard;
end;

end.
