program Pro2Htm;

{$M $4000,0,0 }
uses dos;

const
     VERSION : string = '1.0.8'; { n version Linux-like }

{ Programme de conversion .PRO->.HTM
   Hugo MERCIER 1999 pour PrograZine

   27/05/1999

   }

const
     MAXTAG = 32;
     MAXVAR = 20;
     MAXATTACH = 10;
     MAXINDEX = 15;

     CR = chr(13)+chr(10);

type
    TChaine = array[0..400] of char;
    TTag = record
         tag : string;
         replace : TChaine;
    end;

    TVariable = record
              Nom, Valeur : string;
              end;

    TIndex = record
           Titre,Auteur,FileName : string;
    end;
var
   FileIn, FileOut,FileAux : text;

   StrFilePRO, StrFileENT, StrFileOUT : String;
   StrFileTag, StrFileBef, StrFileAft : string;
   StrFileName : string;

   Tags : array[0..MAXTAG] of TTag;
   NbTags : integer;

   Variable : array[1..MAXVAR] of TVariable;
   NbVars : integer;

   { fichiers attachs }
   Attach : array[1..MAXATTACH] of string;
   NbAttachs : integer;

   Index : array[1..MAXINDEX] of TIndex;
   NbIndex : integer;

   NbErrs : integer;

   { --- Repertoire source */ destination --- }

   RepDest, RepSrc : string;

   { -- options de la ligne de commmande --- }
   OptChar,OptChar2 : char;
   OptStr,OptStr2 : string;

   Recurse : boolean;
   TraitementIndex : boolean;

{Teste si un fichier existe }

function FileExists(FileName: String): Boolean;
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
end;

{ met la chane en majuscule}

function UCase(str: string): string;
var
   j : integer;
begin
     for j:=1 to length(str) do
         if (ord(str[j]) > 96) and (ord(str[j]) < 97+26) then
            str[j] := chr(ord(str[j]) - 32);
     UCase := str;
end;

procedure strcpy(var ch : TChaine; str : string);
var
   i : integer;
begin
     for i:=0 to length(str)-1 do
         ch[i] := str[i];

     if length(str)=0 then ch[i] := #0 else ch[i+1] := #0;
end;

function strlen(ch : TChaine): integer;
var
   i : integer;
begin
     i := 0;
     while ch[i]<>#0 do inc(i);
     strlen := i;
end;

procedure strcat(var ch : TChaine; str : string);
var
   i,l : integer;
begin
     l := strlen(ch);
     for i:=0 to length(str)-1 do
         ch[l+i] := str[i+1];
     ch[l+i+1] := chr(0);
end;

procedure strdisp(var ch : TChaine);
var i : integer;
begin
     i := 0;
     while ch[i]<>chr(0) do
     begin
          write(ch[i]);
          inc(i);
     end;
     writeln;
end;


{Renvoie un mot d'une chane dlimit par TAG1 et TAG2 (char) }
{ Aucun bug connu }

procedure ExtractWord(str : string; tag1, tag2 : char; var ret : string);
var i,k : integer;
begin
     ret := '';
     i := 1;
     k := 1;
     while (str[i]<>tag1) and (i<=length(str)) do inc(i) ;

     if str[i]=tag1 then
     begin
          inc(i);
          while (str[i]<>tag2) and (i<=length(str)) do
          begin
               ret:=ret+str[i];
               inc(i);
          end;
          if str[i]<>tag2 then ret:='';
     end;
end;

{Donne une valeur  une variable}

{cr la variable si elle n'existe pas }

procedure SetVariable(svar, sval :string);
var i : integer;
    MVar : string;
    fini, trouve : boolean;
begin
     i := 1;

     Mvar := UCase(svar);

     fini := false;
     trouve := false;

     while not fini do
     begin
          if variable[i].Nom=MVar then
          begin
               fini := true;
               trouve := true;
          end;
          if i=NbVars then fini := true;
          inc(i);
     end;

     if not trouve then
     begin
          Variable[i-1].Nom := MVar;
          Variable[i-1].Valeur := sval;
          inc(NbVars);
     end else
          Variable[i-1].Valeur := sval;
end;

{ renvoie la valeur d'une variable : chane}
function GetVariable(svar : string) : string;
var i : integer;
    MVar : string;
    fini, trouve : boolean;
begin
     MVar := UCase(svar);
     i := 1;

     fini := false;
     trouve := false;

     while not fini do
     begin
           if (i=NbVars) then fini:=true;
           if (Variable[i].Nom=MVar) then
           begin
                trouve:=true;
                fini := true;
           end;
           inc(i);
     end;


     if trouve then GetVariable := Variable[i-1].Valeur
               else GetVariable := '';
end;


procedure ReplaceInString(var Str : string; Text1,Text2 : string);
var p : integer;
    av, ap : string;
begin
     p := pos(Text1,Str);
     if p<>0 then
     begin
          av := copy(Str,1,p-1);
          ap := copy(Str,p+length(Text1),256);
          if pos(Text1,ap)<>0 then
             ReplaceInString(ap,Text1,Text2);

          Str := av + Text2 + ap;
     end;
end;

{ Initialisation des fichiers }

procedure InitTabs;
var
   FileInTAG, FileInENT : text;
   Ligne, Ligne2 : string;
   i,k : integer;

   av,ap : string;
   mot : string;
   liste : boolean;
begin
     NbVars := 1;

     SetVariable('FILE','');
     SetVariable('NUMERO','');
     SetVariable('TITRE','');
     SetVariable('AUTEUR','');
     SetVariable('EMAIL','');
     SetVariable('WEB','');
     SetVariable('NIVEAU','');
     SetVariable('LANGAGE','');
     SetVariable('OS','');
     SetVariable('CLES','');
     SetVariable('DESCRIPTION','');
     SetVariable('SOURCE1','');
     SetVariable('SOURCE2','');
     SetVariable('SOURCE3','');
     SetVariable('SOURCE4','');
     { type par dfaut }
     SetVariable('TYPE','article');

     assign(FileInENT,StrFileEnt);
     reset(FileInENT);

     { lit les variables dans le fichier .ENT }
     liste := false;
     while (not eof(FileInENT)) and (not liste) do
     begin
          readln(FileInENT,Ligne);
          if UCase(Ligne)='LISTE' then liste := true;
          av := copy(Ligne,1,pos('=',Ligne)-1);
          ap := copy(Ligne,pos('=',Ligne)+1,256);
          SetVariable(av,ap);
     end;

     if not TraitementIndex then
     begin
          Index[NbIndex].Titre := GetVariable('TITRE');
          Index[NbIndex].Auteur := GetVariable('AUTEUR');
          Index[NbIndex].FileName := StrFileName;
          inc(NbIndex);
     end;

     k:=0;
     while (not eof(FileInENT)) and (liste) do
     begin
          readln(FileInENT,Ligne);
          if UCase(Ligne)='FIN' then
               liste := false;
          Attach[k] := Ligne;
          inc(k);
     end;
     NbAttachs := k-1;


     close(FileInENT);

     StrFileTag := GetVariable('TYPE') + '.tag';
     StrFileBef := GetVariable('TYPE') + '.bef';
     StrFileAft := GetVariable('TYPE') + '.aft';

     if not FileExists(StrFileTag) then
     begin
          Writeln('Fichier ',StrFileTag,' introuvable !');
          halt(1);
     end;

     if not FileExists(StrFileBef) then
     begin
          Writeln('Fichier ',StrFileBef,' introuvable !');
          halt(1);
     end;

     if not FileExists(StrFileAft) then
     begin
          Writeln('Fichier ',StrFileAft,' introuvable !');
          halt(1);
     end;

     assign(FileInTAG,StrFileTag);
     reset(FileInTAG);


     {lit les lignes qui remplacent les balises }
     k := 0;
     while not eof(FileInTAG) do
     begin
          readln(FileInTAG,Ligne);

          if copy(Ligne,1,4) = '####' then
          begin
               Tags[k].Tag := copy(Ligne,6,256);
               Tags[k].Replace[0] := #0;
               Ligne2 := '';
               if not TraitementIndex then Write('.');
               while copy(Ligne2,1,4)<>'####' do
               begin
                    readln(FileInTAG,Ligne2);
                    if copy(Ligne2,1,4)<>'####' then
                       strcat(Tags[k].Replace,Ligne2 + CR);
               end;
               Tags[k].Replace[strlen(Tags[k].Replace)-2]:=#0;
               inc(k);
          end;
     end;

     NbTags := k;
     close(FileInTag);
end;


{Teste si le tag existe dans la base des tags  remplacer }

function TrouveTag(str : string): integer;
var
   i : integer;
   trouve : integer;
begin
     trouve := -1;
     for i:=0 to NbTags-1 do
         if Tags[i].Tag = str then
         begin
            trouve := i;
            break;
         end;
     TrouveTag := trouve;
end;

procedure ConvertToHTM(fi : string);
var
   rien : dirstr;
   fich: NameStr;
   ext : extstr;

   fo,ligne,Tag,NomFichier : string;
   ligne2 : string;
   erreur : boolean;
   i,j,t,cpt : integer;
   car : char;
begin
     StrFilePRO := fi + '.pro';
     StrFileENT := fi + '.ent';
     fo:=fi+'.htm';

     FSplit(fo,rien,fich,ext);
     StrFileOUT := RepDest + fich+'.htm';
     NomFichier := fich+'.htm';

     erreur := false;

     if not FileExists(StrFilePRO) then
     begin
          writeln('Fichier ',StrFilePRO,' introuvable.');
          inc(NbErrs);
          NbAttachs := -1;
          erreur := true;
     end;

     if not FileExists(StrFileENT) then
     begin
          writeln('Fichier ',StrFileENT,' introuvable.');
          inc(NbErrs);
          NbAttachs:=-1;
          erreur := true;
     end;

     if not erreur then
     begin


     if not TraitementIndex then Write('Fichier ',StrFileENT,': ');
     InitTabs;
     if not TraitementIndex then Writeln('ok');

     SetVariable('FILE',NomFichier);

     if not TraitementIndex then Writeln('Fichier ',StrFilePRO,' -> ',StrFileOUT,': ');
     assign(FileIn,StrFilePRO);
     assign(FileOut,StrFileOUT);

     reset(FileIn);
     rewrite(FileOut);

     { -- recopie le dbut de FILE.BEF }
     assign(FileAux,StrFileBEF);
     reset(FileAux);

     while not eof(FileAux) do
     begin
          readln(FileAux,ligne);
          writeln(FileOut,ligne);
     end;

     close(FileAux);

     while not eof(FileIn) do
     begin
          read(FileIn,car);
          if car = '<' then
          begin
               Tag:='<';
               repeat
                     read(FileIn,car);
                     Tag:=Tag+car;
               until car = '>';
               t := TrouveTag(Ucase(Tag));
               if t<>-1 then
                  for cpt := 0 to strlen(Tags[t].Replace) -1 do
                      write(FileOut,Tags[t].Replace[cpt])
               else
               begin
                   write(FileOut,Tag);
               end;

          end else
              write(FileOut,car);
     end;

     { -- recopie la fin de FILE.AFT }
     assign(FileAux,StrFileAFT);
     reset(FileAux);

     while not eof(FileAux) do
     begin
          readln(FileAux,ligne);
          writeln(FileOut,ligne);
     end;

     close(FileAux);

     close(FileOut);
     close(FileIn);

     { --- Remplace les #xxx# par leur valeurs ---}

     assign(FileAux,'temp.001');
     rewrite(FileAux);

     reset(FileOut);
     while not eof(FileOut) do
     begin
          readln(FileOut,ligne);
          if UCase(Ligne)='%REP-INDEX%' then
          begin
               readln(FileOut,Ligne);
               for i:=0 to NbIndex-1 do
               begin
                    Ligne2:=Ligne;
                    ReplaceInString(ligne2,'#FILEA#',Index[i].FileName);
                    ReplaceInString(ligne2,'#TITREA#',Index[i].Titre);
                    ReplaceInString(ligne2,'#AUTEURA#',Index[i].Auteur);
                    Writeln(FileAux,ligne2);
               end;
          end else
          begin

               for i:=1 to NbVars - 1 do
                   ReplaceInString(ligne,'#'+Variable[i].Nom+'#',Variable[i].Valeur);
               writeln(FileAux,ligne);
          end;
     end;

     close(FileOut);
     close(FilEAux);

     { -- recopie le temporaire en htm --- }

     reset(FileAux);
     rewrite(FileOut);
     while not eof(FileAux) do
     begin
          readln(FileAux,ligne);
          writeln(FileOut,ligne);
     end;
     close(FileOut);
     close(FileAux);

     end;
end;


procedure CopyAttach;
var i:integer;
    com : string;
begin
     if NbAttachs>-1 then
     begin
        Write('    > Fichiers attachs: ');
        for i:=0 to NbAttachs-1 do
        begin
          RepDest[0]:=chr(ord(RepDest[0])-1);
          com := '/c copy ';
          com := com + RepSrc+Attach[i] + ' '+RepDest+' >nul';
          SwapVectors;
          exec(getenv('COMSPEC'),com);
          SwapVectors;
          RepDest[0]:=chr(ord(RepDest[0])+1);
          Write(UCase(Attach[i]),' ');
        end;
        Writeln('ok');
     end;
end;


procedure RecurseDirectories(pt:string);
var
 DirInfo: SearchRec;

 st : string;
begin

     NbIndex := 0;
     writeln('****');

 FindFirst(pt+'*.*', Directory, DirInfo);
 while DosError = 0 do
 begin
   If (DirInfo.Attr AND Directory<>0) and (copy(DirInfo.Name,1,1)<>'.') then
   begin
        RecurseDirectories(pt+DirInfo.Name+'\');
   end;

   FindNext(DirInfo);
  end;

  FindFirst(pt+'*.PRO',Archive,DirInfo);
  while DosError = 0 do
  begin
   { ---- traitement recursf ici ---- }
        IF UCase(DirInfo.Name)<>'INDEX.PRO' then
        begin
             st:=pt+DirInfo.Name+'\';
             st:=copy(st,1,pos('.',st)-1);
             TraitementIndex := false;
             StrFileName := copy(DirInfo.Name,1,pos('.',DirInfo.Name)-1)+'.htm';
             ConvertToHTM(st);
             CopyAttach;
        end;

   { ----- fin du traitement -------- }

       FindNext(DirInfo);
  end;

  if FileExists(pt+'INDEX.PRO') then
  begin
    Writeln('Sommaire: ');
    TraitementIndex := true;
    st:=pt+'INDEX';
    ConvertToHTM(st);
    CopyAttach;

    {efface le fichier temporaire }
    SwapVectors;
    Exec(GetEnv('COMSPEC'),'/c del temp.001');
    SwapVectors;
  end;
end;

procedure Syntaxe;
begin
     write('PRO2HTM v. ');
     write(VERSION);
     writeln(' - disCaSe / PrograZine');
     writeln;
     writeln('Syntaxe: PRO2HTM fichier [options]');
     writeln('         fichier: fichier  convertir, sans extension');
     writeln('         -iREpertoire: repertoire source de PrograZine');
     writeln('         -oREpertoire: repertoire destination de PrograZine');
end;

begin
     if ParamCount < 1 then
     begin
          Syntaxe;
          halt(1);
     end;

     NbErrs:=0;
     Recurse := false;

     { si la ligne commence par '-' }
     if copy(paramstr(1),1,1) = '-' then
     begin

     OptStr := UCase(copy(paramstr(1),2,1));
     OptChar := OptStr[1];

     case OptChar of
     'I' : begin
         Recurse := true;
         RepSrc := copy(paramstr(1),3,256);
         if RepSrc[length(RepSrc)] <> '\' then RepSrc := RepSrc + '\';

         if copy(paramstr(2),1,1) = '-' then
         begin
              OptStr2:=UCase(copy(paramstr(2),2,1));
              OptChar2 := OptStr2[1];
              if OptChar2 = 'O' then
              begin
                 RepDest := copy(paramstr(2),3,256);
                 if RepDest[length(RepDest)] <> '\' then RepDest := RepDest + '\';
              end
              else
                  RepDest := '.\';
         end else
             RepDest := '.\';

         end;
     'O' : begin
         Recurse := true;
          RepDest:= copy(paramstr(1),3,256);
          if RepDest[length(RepDest)] <> '\' then RepDest := RepDest + '\';
          RepSrc:='.\';
          end;
     'H' : begin
         Syntaxe;
         halt(0);
         end;
     end;

     if Recurse then RecurseDirectories(FExpand(RepSrc));

     { Si la ligne <> '-xxx' }
     end else
     begin
          RepDest:='';
          ConvertToHTM(paramstr(1));
     end;

     if NbErrs = 0 then
          Writeln('Aucune erreur.')
          else
              if NbErrs = 1 then
                 Writeln('1 erreur.')
              else
                 Writeln(NbErrs,' erreurs.');
end.