.data

h_srcfile       dd 0
h_srcmap        dd 0
srcmap_addr     dd 0
h_destfile      dd 0
h_destmap       dd 0
destmap_addr    dd 0

check           dd 0
buff            dd 0
good            dd 0

.code

;============================================================================
; OpenBothFiles
;============================================================================
;
; Open the source and destination files
;
; in
;  src_ptr  : ptr to the src filename
;  dest_ptr : ptr to the dest filename
;  sizelow  : low dword of the size of destfile
;  sizehigh : high dword of the size of destfiles
;  h_owner  : handle of the calling box
;
; out
;  0 if no error
;  1 if error
;

OpenBothFiles proc src_ptr:dword, dest_ptr:dword, sizelow:dword, sizehigh:dword, h_owner:dword

    pushad

  ; map source file

    call CreateFileA,src_ptr,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,0
    mov [h_srcfile],eax
    call CreateFileMappingA,h_srcfile,0,PAGE_READONLY,0,0,NULL
    mov [h_srcmap],eax
    call MapViewOfFile,h_srcmap,FILE_MAP_READ,0,0,0
    mov [srcmap_addr],eax
    or eax,eax
    jnz obf1

    call ErrorMessage, h_owner, offset err_map
    popad
    mov eax,1
    ret

  obf1:

  ; map destination file

    call CreateFileA,dest_ptr,GENERIC_READWRITE,FILE_SHARE_WRITE,0,OPEN_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,0
    mov [h_destfile],eax
    call CreateFileMappingA,h_destfile,0,PAGE_READWRITE,sizehigh,sizelow,NULL
    mov [h_destmap],eax
    call MapViewOfFile,h_destmap,FILE_MAP_ALL_ACCESS,0,0,0
    mov [destmap_addr],eax
    or eax,eax
    jnz obf2

    call ErrorMessage, h_owner, offset err_map
    popad
    mov eax,1
    ret

  obf2:

    popad
    xor eax,eax
    ret

OpenBothFiles endp



;============================================================================
; CloseBothFiles
;============================================================================
;
; Close the source and destination files
;


CloseBothFiles proc

  ; unmap destination file

    call UnmapViewOfFile, destmap_addr
    call CloseHandle, h_destmap
    call CloseHandle, h_destfile

  ; unmap source file

    call UnmapViewOfFile, srcmap_addr
    call CloseHandle, h_srcmap
    call CloseHandle, h_srcfile

    xor eax,eax
    ret

CloseBothFiles endp


;============================================================================
; CheckFile
;============================================================================
;
; Checks if the file is a correct XOR file :)
;
; in
;  src_ptr  : ptr to the src filename
;

CheckFile proc src_ptr:dword

    pushad

    mov dword ptr [good], FALSE

    call CreateFileA,src_ptr,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,0
    mov [h_srcfile],eax
    call ReadFile, h_srcfile, offset check, 4, offset buff, 0
    cmp eax,TRUE
    jne cf_end

    cmp dword ptr [check], 00524F58h                 ; 'XOR',0
    jne cf_end

    mov dword ptr [good], TRUE

  cf_end:

    popad
    mov eax, dword ptr [good]
    ret

CheckFile endp