.data

h_find          dd 0
W32FD           WIN32_FIND_DATA <>

.code

;============================================================================
; Cipher
;============================================================================
;
; cipher the src file and create the ciphered file
;
; in
;  src_ptr  : ptr to the src filename
;  dest_ptr : ptr to the dest filename
;  h_owner  : handle of the calling box
;
; out
;  0 if no error
;  1 if error
;



Cipher proc src_ptr:dword, dest_ptr:dword, h_owner:dword

    pushad

    call FindFirstFileA, src_ptr, offset W32FD
    mov dword ptr [h_find],eax
    inc eax
    jnz cipher1

    call FindClose, h_find
    call ErrorMessage, h_owner, offset err_no_file
    popad
    mov eax,1
    ret

  cipher1:

    mov ecx,W32FD.nFileSizeLow
    mov edx,W32FD.nFileSizeHigh
    add ecx,SIZEOF_HEADER
    adc edx,0

    call OpenBothFiles, offset W32FD.cFileName, dest_ptr, ecx, edx, h_owner

    or eax,eax
    jz cipher2

    popad
    mov eax,1
    ret

  cipher2:

  ; tirage d'une cl pour le fichier
    call GetRandom
    mov dword ptr [file_key], eax
    xor eax,dword ptr [owner_key]
  ; ---

    mov ecx,W32FD.nFileSizeLow
    mov edx,W32FD.nFileSizeHigh
    mov esi,dword ptr [srcmap_addr]
    mov edi,dword ptr [destmap_addr]
    mov dword ptr [edi], 00524F58h                 ; 'XOR',0
    mov dword ptr [edi + 4], eax
    add edi,SIZEOF_HEADER

  begin_cipher:
    cmp ecx,3
    ja go_on_cipher
    or edx,edx
    jz finish_cipher
    dec edx
  go_on_cipher:
    lodsd
; ---------- cipher routine ----------
    bswap eax
    xor eax, dword ptr [file_key]
    rol eax,4
; ---------- end of cipher routine ----------
    stosd
    sub ecx,4
    jmp begin_cipher
  finish_cipher:
    rep movsb

    call CloseBothFiles

    call FindClose,h_find

    call WarningMessage, h_owner, offset warn_ciphered

    popad
    xor eax,eax
    ret

endp Cipher



;============================================================================
; Decipher
;============================================================================
;
; decipher the src file and create the deciphered file
;
; in
;  src_ptr  : ptr to the src filename
;  dest_ptr : ptr to the dest filename
;  h_owner  : handle of the calling box
;
; out
;  0 if no error
;  1 if error
;

Decipher proc src_ptr:dword, dest_ptr:dword, h_owner:dword

    pushad

    call FindFirstFileA, src_ptr, offset W32FD
    mov dword ptr [h_find],eax
    inc eax
    jnz decipher1

    call FindClose,h_find
    call ErrorMessage, h_owner, offset err_no_file
    popad
    mov eax,1
    ret

  decipher1:

    mov edx,W32FD.nFileSizeHigh
    mov ecx,W32FD.nFileSizeLow
    sub ecx,SIZEOF_HEADER
    sbb edx,0

    call OpenBothFiles,offset W32FD.cFileName, dest_ptr, ecx, edx, h_owner
    or eax,eax
    jz decipher2

    popad
    mov eax,1
    ret

  decipher2:

    mov esi,dword ptr [srcmap_addr]
    mov edi,dword ptr [destmap_addr]

  ; rcupration de la cl du fichier
    mov eax,dword ptr [esi + 4]
    xor eax,dword ptr [owner_key]
    mov dword ptr [file_key], eax
  ; ---

    add esi,SIZEOF_HEADER

  begin_decipher:
    cmp ecx,3
    ja go_on_decipher
    or edx,edx
    jz finish_decipher
    dec edx
  go_on_decipher:
    lodsd
; ---------- decipher routine ----------
    ror eax,4
    xor eax, dword ptr [file_key]
    bswap eax
; ---------- end of decipher routine ----------
    stosd
    sub ecx,4
    jmp begin_decipher
  finish_decipher:
    rep movsb

    call CloseBothFiles

    call FindClose, h_find

    call WarningMessage, h_owner, offset warn_deciphered

    popad
    xor eax,eax
    ret

endp Decipher