.data

conffile        db 'penelope.conf',0

.code

;============================================================================
; Options Box procedure
;============================================================================


OptionsBox proc _hwind:dword, wmsg:dword, wparama:dword, lparama:dword


    cmp [wmsg],WM_INITDIALOG
    je init_optionsbox
    cmp [wmsg],WM_CLOSE
    je kill_optionsbox
    cmp [wmsg],WM_DESTROY
    je kill_optionsbox
    cmp [wmsg],WM_COMMAND
    je optionsevents

    xor eax,eax
    ret

kill_optionsbox:
    call EndDialog, _hwind, 0


init_optionsbox:
    call LoadIconA, h_module, MY_ICON_FILE2
    call SendMessageA, _hwind, WM_SETICON, 0, eax

    ret

optionsevents:

    cmp [wparama],MAKECONF_PB
    je event_makeconf
    cmp [wparama],LOADCONF_PB
    je event_loadconf
    cmp [wparama],SETASS_PB
    je event_setass
    cmp [wparama],REMASS_PB
    je event_remass
    cmp [wparama],OPTQUIT_PB
    je kill_optionsbox

    xor eax,eax
    ret

event_makeconf:

    pushad

    call CreateFileA,offset conffile,GENERIC_READWRITE,FILE_SHARE_WRITE,0,OPEN_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,0
    mov [h_destfile],eax
    call CreateFileMappingA,h_destfile,0,PAGE_READWRITE,0,4,NULL
    mov [h_destmap],eax
    call MapViewOfFile,h_destmap,FILE_MAP_ALL_ACCESS,0,0,4
    mov [destmap_addr],eax
    or eax,eax
    jnz event_makeconf1

    call ErrorMessage, _hwind, offset err_map
    popad
    xor eax,eax
    ret

  event_makeconf1:

    mov eax,dword ptr [owner_key]
    xor eax,dword ptr [prog_key]
    mov edi,dword ptr [destmap_addr]
    mov [edi],eax

    call UnmapViewOfFile, destmap_addr
    call CloseHandle, h_destmap
    call CloseHandle, h_destfile

    call WarningMessage,_hwind,offset warn_makeconf

    popad
    xor eax,eax

    ret


event_loadconf:

    pushad

    call QuestionMessage,_hwind,offset qu_loadconf
    cmp eax,IDNO
    je event_loadconf2

    call CreateFileA,offset conffile,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,0
    mov [h_srcfile],eax
    call CreateFileMappingA,h_srcfile,0,PAGE_READONLY,0,0,NULL
    mov [h_srcmap],eax
    call MapViewOfFile,h_srcmap,FILE_MAP_READ,0,0,0
    mov [srcmap_addr],eax
    or eax,eax
    jnz event_loadconf1

    call ErrorMessage, _hwind, offset err_map
    popad
    xor eax,eax
    ret

  event_loadconf1:

    mov esi,dword ptr [srcmap_addr]
    mov eax,dword ptr [esi]
    xor eax,dword ptr [prog_key]
    mov dword ptr [owner_key],eax

    call UnmapViewOfFile, srcmap_addr
    call CloseHandle, h_srcmap
    call CloseHandle, h_srcfile

    call WarningMessage,_hwind,offset warn_loadconf

  event_loadconf2:

    popad
    xor eax,eax
    ret


event_setass:

    call QuestionMessage,_hwind,offset qu_setass
    cmp eax,IDNO
    je event_setass1

    call SetAssociation
    call WarningMessage,_hwind,offset warn_setass

  event_setass1:

    xor eax,eax
    ret


event_remass:

    call QuestionMessage,_hwind,offset qu_remass
    cmp eax,IDNO
    je event_remass1

    call RemAssociation
    call WarningMessage,_hwind,offset warn_remass

  event_remass1:

    xor eax,eax
    ret

OptionsBox endp
