.data

OFN             OPENFILENAME <>

ofn_filters     db 'All files (*.*)',0,'*.*',0,'Ciphered files (*.xor)',0,'*.xor',0,0
ofn_title_open  db 'Penelope by Androgyne/RtC - In File',0
ofn_title_save  db 'Penelope by Androgyne/RtC - Out File',0

.code

;============================================================================
; Main Box procedure
;============================================================================

MyBox proc _hwind:dword, wmsg:dword, wparama:dword, lparama:dword


    cmp [wmsg],WM_INITDIALOG
    je init_box
    cmp [wmsg],WM_CLOSE
    je kill_box
    cmp [wmsg],WM_DESTROY
    je kill_box
    cmp [wmsg],WM_COMMAND
    je events

    xor eax,eax
    ret

kill_box:

    call RegOpenKeyExA,HKEY_LOCAL_MACHINE,offset regsubkey,0,KEY_ALL_ACCESS,offset h_regkey
    call RegSetValueExA,h_regkey,offset regvaluename2,0,REG_DWORD,offset rand_seed1,4
    call RegSetValueExA,h_regkey,offset regvaluename3,0,REG_DWORD,offset rand_seed2,4

    mov eax,dword ptr [owner_key]
    xor eax,dword ptr [prog_key]
    call RegSetValueExA,h_regkey,offset regvaluename1,0,REG_DWORD,eax,4
    call RegCloseKey,h_regkey

    call EndDialog, _hwind, 0


init_box:
    call LoadIconA, h_module, MY_ICON
    call SendMessageA, _hwind, WM_SETICON, 0, eax

    mov eax, dword ptr [in_file]
    or eax,eax
    jz init_box_end

    call SendDlgItemMessageA, _hwind, INFILE_ET, WM_SETTEXT, 0, offset in_file
    xor eax,eax

  init_box_end:

    ret

events:

    cmp [wparama],QUIT_PB
    je kill_box
    cmp [wparama],ABOUT_PB
    je event_about
    cmp [wparama],OPTIONS_PB
    je event_options
    cmp [wparama],CIPHER_PB
    je event_cipher
    cmp [wparama],DECIPHER_PB
    je event_decipher
    cmp [wparama],OPEN_PB
    je event_open

    xor eax,eax
    ret

event_about:

    call DialogBoxParamA, h_module, ABOUT_BOX, _hwind, offset AboutBox, 0
    xor eax,eax
    ret

event_options:

    call DialogBoxParamA, h_module, OPTIONS_BOX, _hwind, offset OptionsBox, 0
    xor eax,eax
    ret

event_open:

    mov eax,_hwind

    mov OFN.hwndOwner, eax
    mov OFN.lpstrFilter, offset ofn_filters
    mov OFN.nFilterIndex, 1
    mov OFN.lpstrFile, offset in_file
    mov OFN.nMaxFile, MAX_PATH
    mov OFN.lpstrTitle, offset ofn_title_open
    mov OFN.Flags, OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST + OFN_HIDEREADONLY

    call GetOpenFileNameA, offset OFN
    cmp eax,FALSE
    je event_open_end

    call SendDlgItemMessageA, _hwind, INFILE_ET, WM_SETTEXT, 0, offset in_file

  event_open_end:

    xor eax,eax
    ret

;----------------------------------------------------------------------------
; EVENT CIPHER
;----------------------------------------------------------------------------

event_cipher:

    pushad

    call SendDlgItemMessageA, _hwind, INFILE_ET, WM_GETTEXT, MAX_PATH, offset in_file
    or eax,eax
    jnz event_cipher1

    call ErrorMessage, _hwind, offset err_no_srcname
    popad
    xor eax,eax
    ret

  event_cipher1:

    call lstrcpy, offset out_file, offset in_file
    call lstrlen, offset out_file
    mov ebx,eax
    mov dword ptr [out_file + ebx],"rox."
    mov byte ptr [out_file + ebx + 5],0

    call Cipher, offset in_file, offset out_file, _hwind

    popad
    xor eax,eax
    ret

;----------------------------------------------------------------------------
; EVENT DECPIHER
;----------------------------------------------------------------------------

event_decipher:

    pushad

    call SendDlgItemMessageA, _hwind, INFILE_ET, WM_GETTEXT, MAX_PATH, offset in_file
    or eax,eax
    jnz event_decipher1

    call ErrorMessage, _hwind, offset err_no_srcname
    popad
    xor eax,eax
    ret

  event_decipher1:

    call CheckFile, offset in_file
    cmp eax,TRUE
    je event_decipher4

    call ErrorMessage, _hwind, offset err_bad_format
    popad
    xor eax,eax
    ret

  event_decipher4:

    call lstrlen, offset in_file
    mov ebx,eax
    add ebx,offset in_file
    sub ebx,4
    cmp dword ptr [ebx],'rox.'
    je event_decipher2

    mov eax,_hwind

    mov OFN.hwndOwner, eax
    mov OFN.lpstrFilter, offset ofn_filters
    mov OFN.nFilterIndex, 1
    mov OFN.lpstrFile, offset out_file
    mov OFN.nMaxFile, MAX_PATH
    mov OFN.lpstrTitle, offset ofn_title_save
    mov OFN.Flags, OFN_HIDEREADONLY + OFN_OVERWRITEPROMPT

    call GetSaveFileNameA, offset OFN
    cmp eax,TRUE
    je event_decipher3

    call ErrorMessage, _hwind, offset err_no_destname
    popad
    xor eax,eax
    ret


  event_decipher2:

    call lstrcpy, offset out_file, offset in_file
    call lstrlen, offset out_file
    mov ebx,eax
    add ebx,offset out_file
    sub ebx,4
    mov byte ptr [ebx],0

  event_decipher3:

    call Decipher, offset in_file, offset out_file, _hwind

    popad
    xor eax,eax
    ret

MyBox endp