/*
 *  beo_john/c/listen.c
 *
 *	Beowulf John, Listening Server code
 *
 *  Copyright (C) 1999 Professor Falken <prfalken@freeshell.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>				/* Common I/O includes */
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>			/* fifo creation */
#include <sys/stat.h>

#include <sys/wait.h>			/* waitpid() */

#include <sys/socket.h>			/* networking functions */
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <signal.h>

#include <sys/ipc.h>			/* shared memory support */
#include <sys/shm.h>

#include <errno.h>				/* error notification */
#include "beo_server.h"

int shm_id;						/* ID of shared mem segment with demux */
int *ipc_buf;					/* shared mem segment with demux */
int csock;						/* client socket */
int demux_pid;

extern void child(void);
extern void demux(void);

int main(int argc, char *argv[])
{
	int nbyt;						/* byte counter for misc ops */
	char tmp[11];

	int lsock;						/* Listening socket */
	struct sockaddr_in laddr;		/* local socket address */
	struct sockaddr_in caddr;		/* client socket address */
	int caddrlen = sizeof(caddr);	/* client address length */

	signal(SIGPIPE, SIG_IGN);

	/* Parse command line */
	if (argc != 2) {
		fprintf(stderr, "Usage: %s localport\n", argv[0]);
		return 30;
	}

	/* Fork in background */
/*	if ((nbyt = fork()) == -1) {
		perror("fork");
		return 20;
	}
	if (nbyt > 0)
		return 0;
	setsid();*/


    if ((shm_id = shmget(0x666, 3, IPC_CREAT | 0600)) == -1) {
		perror("shmget");
        return(20);
	}

	if ((ipc_buf = shmat(shm_id, 0, 0)) == -1) {
		perror("shmat");
		return(20);
	}

	ipc_buf[0] = 0;
	ipc_buf[1] = 0;

	if ((nbyt = fork()) == -1) {
		perror("fork");
		return(20);
	}

	if (nbyt == 0) {
		demux();
		return(20);
	}

	demux_pid = nbyt;
	/* Create & Open listen port */
	laddr.sin_port = htons((unsigned short)(atol(argv[1])));
	if ((lsock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
		perror("socket");
		return 20;
	}
	laddr.sin_family = htons(AF_INET);
	laddr.sin_addr.s_addr = htonl(0);
	if (bind(lsock, &laddr, sizeof(laddr))) {
		perror("bind");
		return 20;
	}
	if (listen(lsock, 1)) {
		perror("listen");
		return 20;
	}

	/* accept incoming connection (parent only) */
	while ((csock = accept(lsock, &caddr, &caddrlen)) != -1) {

	/* fork child server */
		if ((nbyt = fork()) == -1) {
			shutdown(csock, 2);
			continue;
		}

	/* if child server goto gotsock */
		if (nbyt == 0)
			child();

	/* parent server */
		/* create child's demultiplexer fifo */

		sprintf((char *)tmp, "node.%05d\0", nbyt);
		mkfifo((char *)tmp, 0600);

		ipc_buf[0] = nbyt;
		kill(demux_pid, SIGUSR1);


		while (waitpid(-1, NULL, WNOHANG) > 0);
	}
	return 20;	/* error in accept(2) */
}

