/*
 *  beo_john/c/demux.c
 *
 *  Beowulf John, Demultiplexer code
 *
 *  Copyright (C) 1999 Professor Falken <prfalken@freeshell.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <signal.h>
#include <errno.h>

#include <sys/ipc.h>
#include <sys/shm.h>

#include "beo_server.h"

typedef struct {
    int fifo;
    int pid;
    int valid;
} node_info;

extern int *ipc_buf;
int sig_count;
node_info sig_fifos[MAX_NODES+1];

static void new_node(int sig)
{
    int tmp_pid;
    char tmp[11];

    tmp_pid = ipc_buf[0];
    sprintf((char *)tmp, "node.%05d\0", tmp_pid);
    sig_count++;
    sig_fifos[sig_count].fifo = open((char *)tmp, O_WRONLY);
    sig_fifos[sig_count].pid = tmp_pid;
    fprintf(stderr, "new node : %d\n", tmp_pid);
}

static void del_node(int sig)
{
    int tmp_pid;
    int i;

    tmp_pid = ipc_buf[1];
    sig_count--;

    for (i=0;i<=MAX_NODES;i++)
        if (sig_fifos[i].pid == tmp_pid)
            sig_fifos[i].fifo = 666;
    fprintf(stderr, "del node : %d\n", tmp_pid);
}

void reorder_sig_fifos(void)
{
    int i;
    int j;
    node_info tmp_fifos[MAX_NODES+1];

    for (i=0,j=0;i<=MAX_NODES;i++) {
        tmp_fifos[i].fifo = 666;
        if (sig_fifos[i].fifo != 666) {
            tmp_fifos[j] = sig_fifos[i];
            j++;
        }
    }

    for (i=0;i<=MAX_NODES;i++)
        sig_fifos[i] = tmp_fifos[i];
}


void demux(void)
{
    node_info node_fifos[MAX_NODES+1];          /* parent server demux fifos (wo) */
    sigset_t block;
    int master_fifo;
    int n_nodes = 0;
    int i;
    int curr_node = 0;
    fd_set fdfr;    /* reading fd_set */
    fd_set fdfe;    /* exception fd_set */
    int nbyt;
    char buf[10];

    for (i=0;i<=MAX_NODES;i++) {
        node_fifos[i].fifo = 666;
        node_fifos[i].pid = -1;
        sig_fifos[i].fifo = 666;
        node_fifos[i].pid = -1;
    }

    master_fifo = open("master.node", O_RDONLY);
    (void)signal(SIGUSR1, new_node);
    (void)signal(SIGUSR2, del_node);

    sigemptyset(&block);
    sigaddset(&block, SIGUSR1);
    sigaddset(&block, SIGUSR2);

    sig_count = -1;

    while(1) {

        sigprocmask(SIG_BLOCK, &block, NULL);

        reorder_sig_fifos();
        n_nodes = sig_count;
        for (i=0;i<=MAX_NODES;i++)
            node_fifos[i] = sig_fifos[i];

        if (curr_node >= sig_count+1)
            curr_node = 0;

        sigprocmask(SIG_UNBLOCK, &block, NULL);

        if (n_nodes >= 0) {
            FD_ZERO(&fdfr);
            FD_ZERO(&fdfe);
            FD_SET(node_fifos[curr_node].fifo, &fdfr);
            FD_SET(node_fifos[curr_node].fifo, &fdfe);
            FD_SET(master_fifo, &fdfr);
            FD_SET(master_fifo, &fdfe);

            sigprocmask(SIG_BLOCK, &block, NULL);
            if (select(20, &fdfr, NULL, &fdfe, NULL) == -1) {
                perror("select");
                kill(SIGTERM, getppid());
                exit(20);
            }
            sigprocmask(SIG_UNBLOCK, &block, NULL);

            if (FD_ISSET(master_fifo, &fdfr) || FD_ISSET(master_fifo, &fdfe)) {
                memset(&buf, 0, 10);
                if ((nbyt = read(master_fifo, buf, 9)) <= 0) {
                    perror("read");
                    exit(20);
                }
                if ((write(node_fifos[curr_node].fifo, buf, nbyt)) <= 0) {
                    perror("write");
                    exit(20);
                }
                curr_node++;
            }
        }
    }
}
