/*
 *  beo_john/c/child.c
 *
 *  Beowulf John, Client Side Server code
 *
 *  Copyright (C) 1999 Professor Falken <prfalken@freeshell.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <signal.h>
#include <errno.h>
#include "beo_server.h"

extern int *ipc_buf;
extern int demux_pid;

extern int csock;                   /* client socket */

void child(void)
{
    fd_set fdsr;                    /* reading fd_set */
    fd_set fdse;                    /* exceptions fd_set */
    char tmp[11];                   /* temp string for file names */
    int child_fifo;                 /* demultiplexer output (ro) */
    int nbyt;
    char buf[10];                   /* send/recv buffer */

    /* open demultiplexer fifo */
    sprintf((char *)tmp, "node.%05d\0", getpid());
    child_fifo = open((char *)tmp, O_RDONLY);

    /* Let's rock ! */
    while (1) {
        FD_ZERO(&fdsr);
        FD_ZERO(&fdse);
        FD_SET(csock, &fdsr);
        FD_SET(csock, &fdse);

        FD_SET(child_fifo, &fdsr);
        FD_SET(child_fifo, &fdse);

        /* wait for I/O */
        if (select(20, &fdsr, NULL, &fdse, NULL) == -1) {
            goto quit;
        }

        /* send data from demux to client */
        if (FD_ISSET(child_fifo, &fdsr) || FD_ISSET(child_fifo, &fdse)) {
            memset(&buf, 0, 10);
            if ((nbyt = read(child_fifo, buf, 9)) <= 0)
                goto quit;
            if ((write(csock, buf, nbyt)) <= 0)
                goto quit;
        }
    }

    /* Cleanup file descriptors... */
quit:
    ipc_buf[1] = getpid();
    kill(demux_pid, SIGUSR2);
    close(child_fifo);
    remove((char *)tmp);

    shutdown(csock, 2);
    close(csock);

    exit(0);
}
