#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/socket.h>
#include <sys/types.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <signal.h>
#include <errno.h>

int main(int argc, char *argv[])
{
	fd_set fdsr;
	fd_set fdse;

	int sockfd;
	struct sockaddr_in server_addr;
	unsigned long a;
	struct hostent *h;
	char buf[10];

	if (argc != 3) {
		fprintf(stderr,"usage: %s <server> <port>\n", argv[0]);
		exit(1);
	}

	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	a = inet_addr(argv[1]);
	if (!(h = gethostbyname(argv[1])) && !(h = gethostbyaddr(&a, 4, AF_INET))) {
		perror(argv[1]);
		return 25;
	}

	server_addr.sin_family = h->h_addrtype;
	server_addr.sin_port = htons(atoi(argv[2]));
	memcpy(&server_addr.sin_addr, h->h_addr, h->h_length);

	if (connect(sockfd, &server_addr, sizeof(server_addr))) {
		fprintf(stderr, "500 connect: %s\n", strerror(errno));
		exit(1);
	}

	while(1) {
		FD_ZERO(&fdsr);
		FD_ZERO(&fdse);
		FD_SET(sockfd, &fdsr);
		FD_SET(sockfd, &fdse);

		if (select(20, &fdsr, NULL, &fdse, NULL) == -1) {
			perror("select");
			exit(-1);
		}

		if (FD_ISSET(sockfd, &fdsr) || FD_ISSET(sockfd, &fdse)) {
			memset(&buf, 0, 10);
			if (read(sockfd, buf, 9) <= 0) {
				perror("read");
				exit(-1);
			}
    		printf("%s", buf);
		}
	}
}
