#include "phreax.h"

char e[50], ask, comment[100], debug, timeoutbuff[20], resume_filename[50], 
     numbers_called=0;
char prefix[50]="3651", sufix[50]="", outfilename[50], genelist;
char  x, resume=0, outfile_id, cfgbuff[100], output_form=0, key; /* 0=txt, 1=htm */
int timeout=13, timeout2=4;

long pos;
unsigned int resume_pos;


int count_numbers(FILE *file_to_count)
{
    char number[20];
    char numbers_counted=0;
    
    while(fgets(number,30,file_to_count) != NULL)
    {
	numbers_counted++;
    }
    printf("There are %d numbers to scan.\n\n",numbers_counted);
    fseek(file_to_count,0,0);
    return(numbers_counted);
}

void get_cfg_file()
{
    config_file=fopen("eps.cfg","r");
    while(fgets(cfgbuff,96,config_file))
    {
	if(strstr(cfgbuff,"PREFIX="))
	{
	    for(x=0;x<strlen(cfgbuff)-6;x++)
		prefix[x]=cfgbuff[x+7];
		
	    prefix[strlen(prefix)-1]='\0';
	}
	if(strstr(cfgbuff,"SUFIX="))
	{
	    for(x=0;x<strlen(cfgbuff)-5;x++)
		sufix[x]=cfgbuff[x+6];
		
	    sufix[strlen(sufix)-1]='\0';
	}
	if(strstr(cfgbuff,"TIMEOUT="))
	{
	    for(x=0;x<strlen(cfgbuff)-7;x++)
		timeoutbuff[x]=cfgbuff[x+8];
		
	    timeoutbuff[strlen(timeoutbuff)-1]='\0';
	    timeout=atoi(timeoutbuff);
	}
	if(strstr(cfgbuff,"TIMEOUT2="))
	{
	    for(x=0;x<strlen(cfgbuff)-8;x++)
		timeoutbuff[x]=cfgbuff[x+9];
		
	    timeoutbuff[strlen(timeoutbuff)-1]='\0';
	    timeout2=atoi(timeoutbuff);
	}
    }
    fclose(config_file);
}

void get_cmd_line(int argc, char *argv[])
{
    for(x=1;x<argc;x++)
    {
	if(strstr(argv[x],"-d"))
	{    	
	    debug=1;
	}
    }
    
    if(argc < 2)
	bad_cmd_line();
    
    for(x=1;x<argc;x++)
    {	
	if(strstr(argv[x],"-r"))
	{    	
	    resume=1;
	}	
	if(strstr(argv[x],"-o"))
	{
	    ask=1;
	}
	if(strstr(argv[x],"-t"))
	{    	
	    timeout=atoi(argv[x+1]);
	}
	if(strstr(argv[x],"-p"))
	{    	
	    strcpy(prefix,argv[x+1]);
	}
	if(strstr(argv[x],"-s"))
	{    	
	    strcpy(sufix,argv[x+1]);
	}
	if(strstr(argv[x],"-z"))
	{    	
	    timeout2=atoi(argv[x+1]);
	}
	if(strstr(argv[x],"-g"))
	{    	
	    genelist=1;
	}
	if(strstr(argv[x],"-htm"))
	{
	    output_form=1;
	    ask=1;
	}
    }

}

int prepare_files(int argc, char *argv[])
{
    int ret;
    
    /* resume filename */
    strcpy(resume_filename,argv[1]);
    strcat(resume_filename,".resume");

    /* outfilename */
    strcpy(outfilename,argv[1]);
    if(output_form==0)
	strcat(outfilename,"_scan.txt");
	
    if(output_form==1)
	strcat(outfilename,"_scan.htm");
    
    /* opening outfile */
    if(resume==0)
    {
	if((outfile=fopen(outfilename,"r")) == NULL) /* check if already exist */
	{
	    if((outfile=fopen(outfilename,"w")) == NULL) /* open it if doesn't */
	    {						 /* exist */
		printf("\n\nCan't creat \"%s\".\n",outfilename);
		exit(0);
	    }
	}
	else /* if file exist : ask for overwrite it */
	{
	    cooked_term();
	    printf("\nFile already exist, overwrite ? (y/n) : \n");
	    if('y' == getch())
	    {
		raw_term();
		if((outfile=fopen(outfilename,"w")) == NULL) /* open outfile */
		{						 
		    printf("\n\nCan't creat \"%s\".\n",outfilename);
		    exit(0);
		}
	    }

	    else
	    {
		raw_term();
		exit(0);
	    }
	}
	
	if((resume_file=fopen(resume_filename,"w")) == NULL)
	{
	    printf("\n\nCan't creat \"%s\".\n", resume_filename);
	    exit(0);
	}
	
	if(output_form==1)
	{
	    fprintf(outfile,"<html><body text=#33FF33 bgcolor=#000066><center><table BORDER=1 COLS=2 WIDTH=500>\n");
	}
    }
    
    if(resume==1)
    {
	if((resume_file=fopen(resume_filename,"r")) == NULL)
	{
	    printf("\n\nCan't open \"%s\".\n", resume_filename);
	    exit(0);
	}
	
	fscanf(resume_file,"%d\n%d\n%s",&resume_pos,&numbers_called,&prefix);
	numbers_called--;
	fclose(resume_file);
	
	resume_file=fopen(resume_filename,"w");
	
	if((outfile=fopen(outfilename,"r+")) == NULL)
	{
	    printf("\n\nCan't open \"%s\".\n",outfilename);
	    exit(0);
	}
		
	if(output_form==0)	
	    fseek(outfile,0,2);
	    
	if(output_form==1)
	    fseek(outfile,-45,2);
    }
        
    if((numbers_file=fopen(argv[1],"r")) == NULL)
    {
	printf("\n\nCan't open \"%s\".\n", argv[1]);
	exit(0);
    }

    ret=count_numbers(numbers_file);
    
    if(resume==1)
    {	
	fseek(numbers_file,resume_pos-11,0);
    }

    system("cp ifup_cfg.dat /etc/sysconfig/network-scripts/ifcfg-ppp00"); 
    return(ret);
}

int get_scan_cmd()
{
    char cmd[20];
    int ret=0;
    
    enter_cmd:
    printf("Entrez la commande a effectuer : ");
    scanf("%s",cmd);

    /* aide pour les commandes */
    if(strstr(cmd,"help"))
    {
	scan_cmd_help();
	ret=1;
	goto enter_cmd;
    }
    
    /* commandes pendant le scan */
    /* changer le timeout de ifup */
    if(strstr(cmd,"to:"))
    {
	for(x=0;x<strlen(cmd)-3;x++)
	{
	    timeoutbuff[x]=cmd[x+3];		    
	}		
	timeoutbuff[strlen(cmd)-3]='\0';
	timeout=atoi(timeoutbuff);
	if(debug==1)
	    printf("\nTIMEOUT = \"%d\"\n",timeout);
    }
    
    if(strstr(cmd,"to2:"))
    {
	for(x=0;x<strlen(cmd)-4;x++)
	{
	    timeoutbuff[x]=cmd[x+4];		    
	}		
	timeoutbuff[strlen(cmd)-4]='\0';
	timeout2=atoi(timeoutbuff);
	
	if(debug==1)
	    printf("\nTIMEOUT2 = \"%d\"\n",timeout2);
    }
    
    /* debug mode = on */
    if(strstr(cmd,"don"))
    {
	debug=1;
    }
    
    /* debug mode = off */
    if(strstr(cmd,"doff"))
    {
	debug=0;
    }
    
    /* rappel du dernier numero scanne */
    if(strstr(cmd,"rec"))
	ret=1;	
	
    /* save and exit */
    if(strstr(cmd,"exit"))
    {
    	pos = ftell(numbers_file);
	fprintf(resume_file,"%d\n%d\n%s", pos, numbers_called, prefix);
	
        if(output_form==1)
	    fprintf(outfile,"</table></center></body></html>");
	    
	fcloseall();
	raw_term();
	exit(0);
    }
    return(ret); /* 0 = next, 1 = recall */
}


int print_state(char ch)
{

    int ret=0;
    char state[128];
    
    /* state ? */
    switch(ch) {
	case 'n':
    	    strcpy(state,"Non attribue");break;
	    
	case 'x':
    	    strcpy(state,"Non accessible");break;
	    
	case 'o':
	    strcpy(state,"Occupe");break;
	    
        case 's':
	    strcpy(state,"Sonne");break;
	    
	case 'r':
	    strcpy(state,"A rappeler");break;
	    
	case 'g':
	    strcpy(state,"Repond");break;

	case 'f':
	    strcpy(state,"Fax");break;
	
	case 'm':
	    strcpy(state,"Modem");break;

	case 'e':
	    strcpy(state,"Repondeur");break;
	    
	case 'a':		/* personalised comment */
	    raw_term();
	    printf("Enter your comments : ");
	    scanf("%s",state);
	    cooked_term();break;
	    	    
	case 'h':
	    scan_help();
	    ret=1;
	    
	default:
	    strcpy(state,"?");
    }
    if(ret != 1)
    {
	/* ecriture ds le fichier .scan */
	/* txt */
	if(output_form==0)
	    fprintf(outfile,"%s %s\n",numero, state);
	    	
	/* htm */
	if(output_form==1)
	    fprintf(outfile,"\n<tr>\n  <td with=250 BGCOLOR=#000000 NOSAVE>\n    <B><font size=+1>%s</font></B>\n  </td>\n  <td with=250 BGCOLOR=#000000 NOSAVE> <B><font size=+1>\n  %s</font></B>\n  </td>\n</tr>\n\n",numero,state);

	printf("%s : %s\n\n",numero, state);
    }
    return(ret);
}

void scanning(int numbers_count)
{
    while(fgets(numero,30,numbers_file) != NULL)
    {	
	numbers_called++;
	
	for(x=0;x<20;x++)
	    if(numero[x]==10)
		numero[x]='\0';
	    
	calling:
	/* ecriture du fichier de config de ifup */
	chat=fopen("/etc/sysconfig/network-scripts/chat-ppp00","w");
	fprintf(chat,"'' 'ATDT%s%s%s'\n'TIMEOUT' '%d'\n'BUSY' '+++ATA'", prefix, numero, sufix, timeout);
	fclose(chat);
	
	printf("Calling number : %s%s%s    %d/%d\n", prefix, numero, sufix, 
		numbers_called, numbers_count);
	
        system("ifup ppp00");
	
	if(ask==0)
	    wait(timeout);

	if(ask==1)
	{
	    enter_state:
	    printf("Enter state ('h' for help) : \n");
	    key = getch();
	    
	    /* kill the call */
	    system("killall -e ifup-ppp");
	    system("killall -e chat");
	    
	    /* c = commande pendant le scan */
	    if(key == 'c')		
	    {
		raw_term();
		
		switch(get_scan_cmd())
		{
		    case 1:
			cooked_term();
			goto calling;
		
		    case 0:
			cooked_term();
			goto enter_state;
		}
		
		cooked_term();
	    }
	    if(print_state(key)==1)
		goto enter_state;
		
	    /*sauvegarde le fichier scan */
	    if(output_form==1)
		fprintf(outfile,"</table></center></body></html>");
		
	    fclose(outfile);
	    outfile=fopen(outfilename,"r+");
	    
	    if(output_form==1)
		fseek(outfile,-45,2);
	    else
		fseek(outfile,0,2);
		
	    wait(timeout2);
	}
    }
}
void creat_list(int argc, char *argv[])
{
    char plage[8];
    char a,b;
    numbers_file=fopen(argv[1],"w");
    strcpy(plage,argv[1]);
    for(a=0;a<10;a++)
	for(b=0;b<10;b++)
	    fprintf(numbers_file,"0800%c%c%c%c%d%d\n",plage[0],plage[1],plage[2],plage[3],a,b);
    fclose(numbers_file);
}

void main(int argc, char *argv[])
{
    int numbers_count;

    clrscr();
    print_title();
    
    get_cfg_file();
    get_cmd_line(argc, argv);
    if(genelist == 1)
	creat_list(argc, argv);
    numbers_count=prepare_files(argc, argv);
    
    if(debug == 1)
    {
    	printf("Here is the config for scanning :\n");
	printf("PREFIX= \"%s\"\n",prefix);
	printf("SUFIX= \"%s\"\n",sufix);
	printf("TIMEOUT= \"%d\"\n",timeout);
	printf("TIMEOUT2= \"%d\"\n",timeout2);
    }

    cooked_term();    
    scanning(numbers_count);
    
    if(output_form==1)
	fprintf(outfile,"</table></center></body></html>");
	
    remove(resume_filename);
    fclose(outfile);
    if(genelist==1)
	remove(argv[1]);	
    
    raw_term();
}
