#include <stdlib.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/ip.h>
#include <netinet/ip_tcp.h>
#include <netdb.h>
#include "packet.h"

unsigned short in_cksum(addr, len)
    u_short *addr;
    int len;
{
    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;

    /*
     * Our algorithm is simple, using a 32 bit accumulator (sum), we add
     * sequential 16 bit words to it, and at the end, fold back all the
     * carry bits from the top 16 bits into the lower 16 bits.
     */
    while (nleft > 1)  {
        sum += *w++;
        nleft -= 2;
    }

    /* mop up an odd byte, if necessary */
    if (nleft == 1) {
        *(u_char *)(&answer) = *(u_char *)w ;
        sum += answer;
    }

    /* add back carry outs from top 16 bits to low 16 bits */
    sum = (sum >> 16) + (sum & 0xffff); /* add hi 16 to low 16 */
    sum += (sum >> 16);         /* add carry */
    answer = ~sum;              /* truncate to 16 bits */
    return(answer);
}

void gettcppkt(int s, char *buf, int size)
{
        struct sockaddr_in addr;
        struct iphdr *ip;
        struct tcphdr *tcp;
        int len, r;

        len = sizeof(addr);
        if ((r = recvfrom(s,buf,size,0,(struct sockaddr *) &addr,&len)) == -1)
        {
                perror("recvfrom");
                fprintf(stderr,"error: recvfrom returned %d\n",r);
                exit(1);
        }
}

void sendtcppkt(sock,src,dst,sprt,dprt,seq,ack,flagz,data,dlen)
unsigned long src,dst,seq,ack;
unsigned short sprt,dprt;
unsigned char flagz;
char *data;
int dlen,sock;
{
  struct iphdr ip;
  struct tcphdr tcp;
  char tcpbuf[8192];
  char packet[8192];
  char *ptr;
  struct sockaddr_in sin;
  unsigned short size=0;
  int i;

  ip.ihl=5;ip.version=4;ip.tos=0;ip.tot_len=htons(40+dlen);
  ip.id=htons(666+rand()%100);ip.frag_off=0;ip.ttl=255;
  ip.protocol=IPPROTO_TCP;ip.check=0;ip.saddr=src;ip.daddr=dst;
  
  ip.check=in_cksum((u_short *)&ip,sizeof(ip));

  tcp.th_sport=htons(sprt);tcp.th_dport=htons(dprt);
  tcp.th_ack=htonl(ack),tcp.th_seq=htonl(seq);tcp.th_x2=0;
  tcp.th_off=5;tcp.th_flags=flagz;tcp.th_win=htons(10052);
  tcp.th_sum=0;tcp.th_urp=0;

  memset(tcpbuf,0,8192);
  ptr=tcpbuf;
  memcpy(ptr,&(ip.saddr),8);
  ptr+=9;
  memcpy(ptr,&(ip.protocol),1);
  ptr+=1;
  size=htons(dlen+sizeof(tcp));
  memcpy(ptr,&(size),2);
  ptr+=2;
  memcpy(ptr,&tcp,sizeof(tcp)+dlen);
  ptr+=sizeof(tcp);
  memcpy(ptr,data,dlen);

  tcp.th_sum=in_cksum((u_short *)tcpbuf,sizeof(tcp)+12+dlen);
  
  memcpy(packet,(char *)&ip,sizeof(ip));
  memcpy(packet+sizeof(ip),(char *)&tcp,sizeof(tcp));
  memcpy(packet+sizeof(ip)+sizeof(tcp),(char *)data,dlen);

  sin.sin_family=AF_INET;
  sin.sin_port=dprt;
  sin.sin_addr.s_addr=dst;

  if(sendto(sock,packet,sizeof(ip)+sizeof(tcp)+dlen,0,(struct sockaddr *)&sin,
            sizeof(struct sockaddr_in)) == -1) {
              perror("sendto()");
              exit(1);
            }
}
