#!/bin/sh
. ./IDS.conf
######################
#   RUNNING !!!
######################

######################
# 0 - initialization
#####################
if [ -f $INSTALLLOG ]; then
   rm $INSTALLLOG
fi

if [ -f $ERRORLOG ]; then
   rm $ERRORLOG
fi

touch $INSTALLLOG
touch $ERRORLOG

#######################
#  1 - Parsing the arg
#######################

# yes this is the worst arg parsing function I've ever seen
# anyway... we're not elite, just big fucking lamers...

if [ "$1" != "" ]; then
   if [ "$1" = "-v" ]; then
      echo "Home Made IDS v" $VERSION
      echo "by" $AUTHOR "-" $EMAIL
   elif [ "$1" = "-h" ]; then
      echo "11/99 v 0.01 : first beta version"
      echo "               snort 1.3.1"
      echo "               locolorise 1.0.7"
      echo "               tailbeep 0.41"
   elif [ "$1" = "-t" ]; then
      more TODO
   else
      echo "usage :" $0
      echo "   -v : show version"
      echo "   -t : todo"
   fi
   exit 0
fi
   
#######################
#  2 - Extracting Files
#######################

echo "----[ * extracting files"
echo "        extracting SNORT"
tar -xvzf $SNORTFILE >> $INSTALLLOG 2>>$ERRORLOG
echo "        extracting logcolorise"
tar -xvzf $LOGCOLORISEFILE >> $INSTALLLOG 2>>$ERRORLOG
echo "        extracting tailbeep"
tar -xvzf $TAILBEEPFILE >> $INSTALLLOG 2>>$ERRORLOG
echo "        cleaning archives"
#rm $SNORTFILE $LOGCOLORISEFILE $TAILBEEPFILE
echo "----[ * done"

######################
# building files
######################

echo "----[ ** building binaries"
echo "         building SNORT"
cd $PROGDIR/$SNORTDIR
./configure >> $INSTALLLOG 2>>$ERRORLOG
make >> $INSTALLLOG 2>>$ERRORLOG
echo "         skipping logcolorise... perl script"
echo "         building tailbeep"
cd $PROGDIR/$TAILBEEPDIR
make >> $INSTALLLOG 2>>$ERRORLOG
echo "----[ ** done"

echo "----[ *** creating rule file :" $SNORTLIB 
if [ -f "$SNORTLIB" ]; then
   echo "          > removing old file <"
   rm $SNORTLIB
fi

if [ "$PORTSCAN" != "0" ]; then
   NBRULES=$[NBRULES+NBPS]
   echo "          adding portscan rules..." $NBPS "rules"
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"SYN FIN Scan\"; flags: SF;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"FIN Scan\"; flags: F;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"NULL Scan\"; flags: 0;)">>$SNORTLIB
   echo "alert tcp any !53 ->" $LOCALNET "any (msg:\"XMAS Scan\"; flags: FPU;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"Full XMAS Scan\"; flags: SRAFPU;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "any (flags: A; ack: 0; msg:\"NMAP TCP ping!\";)">>$SNORTLIB
fi

if [ "$TINYFRAGS" != "0" ]; then
   NBRULES=$[NBRULES+NBTF]
   echo "          adding tiny fragments rule..." $NBTF "rule"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any any (msg:"Tiny Fragments, possible hostile activity"; MinFrag: 128;)
EOF
fi

if [ "$FINGERPRINT" != "0" ]; then
   NBRULES=$[NBRULES+NBFG]
   echo "          adding fingerprinting rules..." $NBFG "rules"
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"Possible NMAP Fingerprint attempt\"; flags: SFPU;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "any (msg:\"Possible Queso Fingerprint attempt\"; flags: S12;)">>$SNORTLIB
fi

if [ "$TRACEROUTE" != "0" ]; then
   NBRULES=$[NBRULES+NBTR]
   echo "          adding traceroute rules..." $NBTR "rules"
   echo "alert icmp !"$LOCALNET "any ->" $LOCALNET "any (msg:\"Windows Traceroute\"; TTL: 1; itype: 8;)">>$SNORTLIB
   echo "alert icmp !"$LOCALNET "any ->" $LOCALNET "any (msg:\"Traceroute\"; TTL: 1;)">>$SNORTLIB
fi

if [ "$WINGATE" != "0" ]; then
   NBRULES=$[NBRULES+NBWG]
   echo "          adding wingate scanning rules..." $NBWG "rules"
   echo "alert tcp any any ->" $LOCALNET "1080 (msg:\"WinGate 1080 Attempt\"; flags: S;)">>$SNORTLIB
   echo "alert udp any any ->" $LOCALNET "1080 (msg:\"WinGate 1080 Attempt\"; flags: S;)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "8080 (msg:\"WinGate 8080 Attempt\"; flags: S;)">>$SNORTLIB
   echo "alert udp any any ->" $LOCALNET "8080 (msg:\"WinGate 8080 Attempt\"; flags: S;)">>$SNORTLIB
fi

if [ "$OVERFLOW" != "0" ]; then
   NBRULES=$[NBRULES+NBOV]
   echo "          adding buffer overflow rules..." $NBOV "rules"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any 143 (msg:"IMAP Buffer Overflow!"; content:"|E8 C0FF FFFF|/bin/sh"; flags: PA;)
alert tcp any any -> any 53 (msg:"named Buffer Overflow!"; content:"|CD80 E8D7 FFFF FF|/bin/sh"; flags: PA;)
alert tcp any any -> any 110 (msg:"QPOP Buffer Overflow!"; content:"|E8 D9FF FFFF|/bin/sh";  flags: PA;)
alert tcp any any -> any 21 (msg:"FTP Buffer Overflow-1!"; content:"|5057 440A 2F69|"; flags: PA;)
alert tcp any any -> any 21 (msg:"FTP Buffer Overflow-2!"; content:"|5858 5858 582F|"; flags: PA;)
alert tcp any any -> any 21 (msg:"FTP buffer overflow1!"; content:"|5057 440A 2F69|";)
EOF
fi

if [ "$WORMS" != "0" ]; then
   NBRULES=$[NBRULES+NBWO]
   echo "          adding worms rules..." $NBWO "rule"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any 25 (msg:"Happy 99 Virus"; content:"X-Spanska\: Yes"; flags: PA;)
EOF
fi

if [ "$WINNT" != "0" ]; then
   NBRULES=$[NBRULES+NBMS]
   echo "          adding M$ specific rules..." $NBMS "rules"
   echo "alert udp !"$LOCALNET "any ->" $LOCALNET "161 (msg:\"SNMP NT User List\"; content:\"|2b06 0104 014d 0102 19|\";)">>$SNORTLIB
   echo "alert udp !"$LOCALNET "any ->" $LOCALNET "137 (msg:\"SMB Name Wildcard\"; content:\"CKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA|0000|\";)">>$SNORTLIB
   echo "alert tcp !"$LOCALNET "any ->" $LOCALNET "139 (msg:\"Samba client access\"; content:\"|00|Unix|00|Samba\";)">>$SNORTLIB
   echo "alert tcp !"$LOCALNET "any ->" $LOCALNET "139 (msg:\"SMB CD...\"; content:\"...|00 00 00|\";)">>$SNORTLIB
   echo "alert tcp !"$LOCALNET "any ->" $LOCALNET "139 (msg:\"SMB CD..\"; content:\"..|2f 00 00 00|\";)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "139 (msg:\"SMB C$ access\"; content:\"C$|00 41 3a 00|\";)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "139 (msg:\"SMB D$ access\"; content:\"D$|00 41 3a 00|\";)">>$SNORTLIB
   echo "alert tcp any any ->" $LOCALNET "139 (msg:\"SMB ADMIN$ access\"; content:\"ADMIN$|00 41 3a 00|\";)">>$SNORTLIB
fi

if [ "$SOURCEPORT" != "0" ]; then
   NBRULES=$[NBRULES+NBSP]
   echo "          adding source port rules..." $NBSP "rules"
   echo "alert tcp any 53 ->" $LOCALNET ":1023 (msg:\"Source Port traffic\";)">>$SNORTLIB
   echo "alert udp any 53 ->" $LOCALNET ":1023 (msg:\"Source Port traffic\";)">>$SNORTLIB
   echo "alert tcp any 25 ->" $LOCALNET ":1023 (msg:\"Source Port traffic\";)">>$SNORTLIB
fi

if [ "$SUNRPC" != "0" ]; then
   NBRULES=$[NBRULES+NBSU]
   echo "          adding SUN RPC rules..." $NBSU "rules"
   echo "alert tcp any any ->" $LOCALNET "32771 (msg: \"Attempted Sun RPC high port access\";)">>$SNORTLIB
   echo "alert udp any any ->" $LOCALNET "32771 (msg: \"Attempted Sun RPC high port access\";)">>$SNORTLIB
fi

if [ "$SNMPACCESS" != "0" ]; then
   NBRULES=$[NBRULES+NBSN]
   echo "          adding SNMP acces rule..." $NBSN "rule"
   echo "alert udp !"$LOCALNET "any ->" $LOCALNET "161 (msg: \"SNMP access, public\"; content:\"public\";)">>$SNORTLIB
fi

if [ "$CGIPROBES" != "0" ]; then
   NBRULES=$[NBRULES+NBCG]
   echo "          adding CGI probes rules..." NBCG "rules"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any 80 (content:"/cgi-bin/test-cgi"; msg:"TEST-CGI probe!"; flags: PA;)
alert tcp any any -> any 80 (content:"/cgi-bin/handler"; msg:"HANDLER probe!"; flags: PA;)
alert tcp any any -> any 80 (content:"/cgi-bin/Count.cgi"; msg:"COUNT.cgi probe!"; flags: PA;)
alert tcp any any -> any 80 (content:"/cgi-bin/faxsurvey"; msg:"FAXSURVEY probe!"; flags: PA;)
alert tcp any any -> any 80 (msg:"PHF CGI access attempt"; content:"/cgi-bin/phf"; flags: PA;)
alert tcp any any -> any 80 (msg:"PHP CGI access attempt"; content:"/cgi-bin/php.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Webgais CGI access attempt"; content:"/cgi-bin/webgais"; flags: PA;)
alert tcp any any -> any 80 (msg:"Websendmail CGI access attempt"; content:"/cgi-bin/websendmail"; flags: PA;)
alert tcp any any -> any 80 (msg:"Webdist CGI access attempt"; content:"/cgi-bin/webdist.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Htmlscript CGI access attempt"; content:"/cgi-bin/htmlscript"; flags: PA;)
alert tcp any any -> any 80 (msg:"CGI pfdisplay access attempt"; content:"/cgi-bin/pfdisplay.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Cgichk Pfdispaly (sic) access attempt"; content:"/cgi-bin/pfdispaly.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"CGI Perl access attempt"; content:"/cgi-bin/perl.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"Wwwboard CGI access attempt"; content:"/cgi-bin/wwwboard.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"WWW-SQL CGI access attempt"; content:"/cgi-bin/www-sql"; flags: PA;)
alert tcp any any -> any 80 (msg:"Guestbook CGI access attempt"; content:"/cgi-bin/guestbook.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"CGI Man access attempt"; content:"/cgi-bin/man.sh"; flags: PA;)
alert tcp any any -> any 80 (msg:"CGI view-source access attempt"; content:"/cgi-bin/view-source?../../../../../../../etc/passwd"; flags: PA;)
alert tcp any any -> any 80 (msg:"Finger CGI access attempt"; content:"/cgi-bin/finger"; flags: PA;)
alert tcp any any -> any 80 (msg:"Campas CGI access attempt"; content:"/cgi-bin/campas"; flags: PA;)
alert tcp any any -> any 80 (msg:"NPH CGI access attempt"; content:"/cgi-bin/nph-test-cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"rwwwshell CGI access attempt"; content:"/cgi-bin/rwwwshell.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"NPH-publish CGI access attempt"; content:"/cgi-bin/nph-publish"; flags: PA;)
alert tcp any any -> any 80 (msg:"Aglimpse CGI access attempt"; content:"/cgi-bin/aglimpse"; flags: PA;)
alert tcp any any -> any 80 (msg:"Glimpse CGI access attempt"; content:"/cgi-bin/glimpse"; flags: PA;)
alert tcp any any -> any 80 (msg:"AT-admin CGI access attempt"; content:"/cgi-bin/AT-admin.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Filemail CGI access attempt"; content:"/cgi-bin/filemail.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"JJ CGI access attempt"; content:"/cgi-bin/jj"; flags: PA;)
alert tcp any any -> any 80 (msg:"Maillist CGI access attempt"; content:"/cgi-bin/maillist.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"Info2www CGI access attempt"; content:"/cgi-bin/info2www"; flags: PA;)
alert tcp any any -> any 80 (msg:"Files CGI access attempt"; content:"/cgi-bin/files.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"Bnbform CGI access attempt"; content:"/cgi-bin/bnbform.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Survey CGI access attempt"; content:"/cgi-bin/survey.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"AnyForm CGI access attempt"; content:"/cgi-bin/AnForm2"; flags: PA;)
alert tcp any any -> any 80 (msg:"Textcounter CGI access attempt"; content:"/cgi-bin/textcounter.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"Classifieds CGI access attempt"; content:"/cgi-bin/classifieds.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Environ CGI access attempt"; content:"/cgi-bin/environ.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Wrap CGI access attempt"; content:"/cgi-bin/wrap"; flags: PA;)
alert tcp any any -> any 80 (msg:"Cgiwrap CGI access attempt"; content:"/cgi-bin/cgiwrap"; flags: PA;)
alert tcp any any -> any 80 (msg:"Edit CGI access attempt"; content:"/cgi-bin/edit.pl"; flags: PA;)
alert tcp any any -> any 80 (msg:"Perlshop CGI access attempt"; content:"/cgi-bin/perlshop.cgi"; flags: PA;)
alert tcp any any -> any 80 (msg:"Args CGI access attempt"; content:"/cgi-dos/args.bat"; flags: PA;)
alert tcp any any -> any 80 (msg:"Upload CGI access attempt"; content:"/cgi-win/uploader.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"Rguest CGI access attempt"; content:"/cgi-bin/rguest.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"Wguest CGI access attempt"; content:"/cgi-bin/wguest.exe"; flags: PA;)
EOF
fi

if [ "$IISPROBES" != "0" ]; then
   NBRULES=$[NBRULES+NBII]
   echo "          adding IIS probes rules..." $NBII "rules"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any 80 (msg:"IIS vti_inf access attempt"; content:"/_vti_inf.html"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Codebrowser access attempt"; content:"/iissamples/exair/howitworks/codebrws.asp"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Codebrowser access attempt"; content:"/iissamples/sdk/asp/docs/codebrws.asp"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Showcode access attempt"; content:"/msads/Samples/SELECTOR/showcode.asp"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Bdir access attempt"; content:"/scripts/iisadmin/bdir.htr"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS CGImail access attempt"; content:"/scripts/CGImail.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS NewDSN access attempt"; content:"/scripts/tools/newdsn.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Fpcount access attempt"; content:"/scripts/fpcount.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Search97 access attempt"; content:"/search97.vts"; flags: PA;)
alert tcp any any -> any 80 (msg:"IIS Carbo.dll access attempt"; content:"/carbo.dll"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage Service PWD Scan"; content:"/_vti_pvt/service.pwd"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage User PWD Scan"; content:"/_vti_pvt/users.pwd"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage Author PWD Scan"; content:"/_vti_pvt/authors.pwd"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage Admin PWD Scan"; content:"/_vti_pvt/administrators.pwd"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage shtml.dll Scan"; content:"/_vti_pvt/shtml.dll"; flags: PA;)
alert tcp any any -> any 80 (msg:"FrontPage shtml.exe Scan"; content:"/_vti_pvt/shtml.exe"; flags: PA;)
alert tcp any any -> any 80 (msg:"cgi-dos/args.bat Scan"; content:"/cgi-dos/args.bat"; flags: PA;)
EOF
fi

if [ "$CFPROBES" != "0" ]; then
   NBRULES=$[NBRULES+NBCF]
   echo "          adding Cold Fusion probes..." $NBCF "rules"
cat >>$SNORTLIB <<EOF
alert tcp any any -> any 80 (msg:"Colf Fusion openfile Scan"; content:"/cfdocs/expelval/openfile.cfm"; flags: PA;)
alert tcp any any -> any 80 (msg:"Cold Fusion exprcalc Scan"; content:"/cfdocs/expelval/exprcalc.cfm"; flags: PA;)
alert tcp any any -> any 80 (msg:"Cold Fusion display Scan"; content:"/cfdocs/expelval/displayopenedfile.cfm"; flags: PA;)
alert tcp any any -> any 80 (msg:"Cold Fusion sendmail Scan"; content:"/cfdocs/expelval/sendmail.cfm"; flags: PA;)
EOF
fi

if [ "$BACKDOORS" != "0" ]; then
   NBRULES=$[NBRULES+NBBD]
   echo "          adding backdoor rules..." $NBBD "rules"
cat >>$SNORTLIB <<EOF
alert udp any any -> any 31 (msg:"Hackers Paradise";)
alert udp any any -> any 456 (msg:"Hackers Paradise";)
alert udp any any -> any 555 (msg:"iNi Killer/Phase Zero/Stealth Spy"; )
alert tcp any 555 -> any any (msg:"Phase Zero Server Active on Network"; content "phAse"; flags: PA;)
alert udp any any -> any 666 (msg:"Satanz Backdoor";)
alert udp any any -> any 1001 (msg:"Silencer, WebEX";)
alert udp any any -> any 1170 (msg:"Psyber Stream";)
alert udp any any -> any 1234 (msg:"Ultors Trojan";)
alert udp any any -> any 1245 (msg:"VooDoo Doll";)
alert udp any any -> any 1492 (msg:"FTP99cmp";)
alert udp any any -> any 1600 (msg:"Shivka-Burka";)
alert udp any any -> any 1807 (msg:"Spy Sender";)
alert udp any any -> any 1981 (msg:"ShockRave";)
alert udp any any -> any 1999 (msg:"Back Door";)
alert udp any any -> any 2001 (msg:"Trojan Cow";)
alert udp any any -> any 2023 (msg:"Ripper Pro";)
alert udp any any -> any 2115 (msg:"Bugs";)
alert udp any any -> any 2140 (msg:"Deep Throat/Invasor"; content:"00";)
alert udp any any -> any 2565 (msg:"Striker";)
alert udp any any -> any 2801 (msg:"Phineas Phucker";)
alert udp any any -> any 2989 (msg:"Rat backdoor";)
alert udp any any -> any 3024 (msg:"WinCrash";)
alert udp any any -> any 3150 (msg:"Deep Throat/Invasor";)
alert udp any any -> any 3700 (msg:"Portal Of Doom";)
alert udp any any -> any 4092 (msg:"WinCrash";)
alert udp any any -> any 4950 (msg:"ICQ Trojan";)
alert udp any any -> any 5000 (msg:"Sockets De Troie";)
alert udp any any -> any 5001 (msg:"Sockets De Troie";)
alert udp any any -> any 5321 (msg:"FireHotcker";)
alert udp any any -> any 5400 (msg:"Blade Runner";)
alert udp any any -> any 5401 (msg:"Blade Runner";)
alert udp any any -> any 5402 (msg:"Blade Runner";)
alert udp any any -> any 5569 (msg:"Robo-Hack";)
alert udp any any -> any 5742 (msg:"WinCrash";)
alert udp any any -> any 6670 (msg:"Deep Throat";)
alert udp any any -> any 6711 (msg:"Deep Throat/SubSeven";)
alert udp any any -> any 7000 (msg:"Remote Grab";)
alert udp any any -> any 7300 (msg:"Net Monitor";)
alert udp any any -> any 7301 (msg:"Net Monitor";)
alert udp any any -> any 7302 (msg:"Net Monitor";)
alert udp any any -> any 7303 (msg:"Net Monitor";)
alert udp any any -> any 7304 (msg:"Net Monitor";)
alert udp any any -> any 7305 (msg:"Net Monitor";)
alert udp any any -> any 7306 (msg:"Net Monitor";)
alert udp any any -> any 7307 (msg:"Net Monitor";)
alert udp any any -> any 7308 (msg:"Net Monitor";)
alert udp any any -> any 7789 (msg:"ICKiller";)
alert udp any any -> any 9872 (msg:"Portal Of Doom";)
alert udp any any -> any 10067 (msg:"Portal Of Doom"; content: "pod";)
alert tcp any any -> any 10752 (msg:"Linux mountd backdoor";)
alert udp any any -> any 11223 (msg:"Progenic Trojan";)
alert udp any any -> any 12223 (msg:"Hack99-Keylogger";)
alert tcp any any -> any 12345 (msg:"Netbus/GabanBus"; flags: S;)
alert tcp any any -> any 12346 (msg:"Netbus/GabanBus"; flags: S;)
alert tcp any any -> any 12361 (msg:"Whack-a-mole"; flags: S;)
alert tcp any any -> any 12362 (msg:"Whack-a-mole"; flags: S;)
alert udp any any -> any 16969 (msg:"Portal Of Doom/Priority";)
alert udp any any -> any 20000 (msg:"Millenium";)
alert udp any any -> any 20001 (msg:"Millenium";)
alert udp any any -> any 20034 (msg:"NetBus PRO";)
alert udp any any -> any 21544 (msg:"Girlfriend";)
alert udp any any -> any 22222 (msg:"Prosiak";)
alert udp any any -> any 26274 (msg:"Delta";)
alert udp any any -> any 31337 (msg:"Back Orifice";)
alert udp any any -> any 31338 (msg:"Deep Back Orifice";)
alert udp any any -> any 31339 (msg:"NetSpy";)
alert udp any any -> any 31666 (msg:"BOWhack";)
alert udp any any -> any 33333 (msg:"Prosiak";)
alert udp any any -> any 34324 (msg:"Big Gluck/TelnetSrv";)
alert udp any any -> any 40412 (msg:"The Spy";)
alert udp any any -> any 40421 (msg:"Masters Paradise";)
alert udp any any -> any 40422 (msg:"Masters Paradise";)
alert udp any any -> any 40423 (msg:"Masters Paradise";)
alert udp any any -> any 40426 (msg:"Masters Paradise";)
alert udp any any -> any 47262 (msg:"Delta";)
alert udp any any -> any 50505 (msg:"Sockets de Troie";)
alert udp any any -> any 50776 (msg:"Fore";)
alert udp any any -> any 53001 (msg:"Remote Win Shutdown";)
alert udp any any -> any 61446 (msg:"TeleCommando";)
alert udp any any -> any 65000 (msg:"Devil";)
alert tcp any any -> any 31337 (msg:"BIND Shell"; flags: S;)
alert udp any any -> any 5632 (msg:"PCAnywhere"; content:"ST";)
alert udp any any -> any 22 (msg:"PCAnywhere"; content:"ST";)
alert udp any any -> any 22 (msg:"PCAnywhere"; content:"NQ";)
alert udp any 2140 -> any any (content:"hhh My Mouth Is Open"; msg:"Deep Throat access";)
alert udp any any -> any 10067 (msg:"Possible Portal of Doom access"; content: "pod";)
alert udp any any -> any 10167 (msg:"Possible Portal of Doom access"; content: "pod";)
alert udp any 10067 -> any any (content:"KeepAliveee"; msg:"Portal of Doom access";)
alert udp any 10167 -> any any (content:"KeepAliveee"; msg:"Portal of Doom access";)
alert udp any any -> any 31789 (msg:"Possible Hack a Tack access"; content: "yourdomain.com";)
alert udp any any -> any 31791 (msg:"Possible Hack a Tack access"; content: "yourdomain.com";)
alert tcp any any -> any 31785 (msg:"Possible Hack a Tack access"; content: "yourdomain.com"; flags: PA;)
alert tcp any any -> any 30100 (msg:"Possible NetSphere access"; flags: S;)
alert tcp any 30100 -> any any (content:"<NetSphere"; msg:"NetSphere access"; flags: PA;)
alert tcp any any -> any 30102 (msg:"Possible NetSphere FTP acces"; flags: S;)
alert tcp any 30102 -> any any (content:"NetSphere Capture FTP"; msg:"NetSphere FTP acces"; flags: PA;)
alert tcp any any -> any 6969 (msg:"Possible GateCrasher access";)
alert tcp any 6969 -> any any (content:"GateCrasher"; msg:"GateCrasher access"; flags: PA;)
alert tcp any any -> any 21554 (msg:"Possible GirlFriend access"; flags: S;)
alert tcp any 21554 -> any any (content:"Girl"; msg:"GirlFriend access"; flags: PA;)
alert tcp any any -> any 23456 (msg:"Possible EvilFTP access"; flags: S;)
alert tcp any 23456 -> any any (content:"EvilFTP"; msg:"EvilFTP access"; flags: PA;)
alert tcp any any -> any 1243 (msg:"Possible SubSeven access"; flags: S;)
alert tcp any any -> any 6776 (msg:"Possible SubSeven access"; flags: S;)
EOF
fi
echo "----[ *** done :" $NBRULES "rules added"

$PROGDIR/$SNORTDIR/snort -Ds -l /var/log/snort -c $SNORTLIB >> $INSTALLLOG 2>>$ERRORLOG
$PROGDIR/$TAILBEEPDIR/tailbeep -f /var/log/secure -t $TTY -s snort &
tail -f /var/log/secure | $PROGDIR/$LOGCOLORISEDIR/logcolorise.pl