/* Fichier include pour  TheTrIaX'sSoundSystem  */

#ifndef TSS_H
#define TSS_H

#include "types.h"

/* Constantes */
#define TSS_LOOPON	0x0001	/* Looping activ */
#define TSS_ASKFORLOOP	0x4000	/* Demande de looping (interne) */
#define TSS_ACTIVE	0x8000	/* Canal activ */

/* Structure de sample */
typedef struct
{
        char            name[32];       /* Nom du sample */
	WORD            flags;          /* Infos sur le sample */
	BYTE            vol;            /* Volume du sample */
        WORD            freq;           /* Frquence du sample */
        WORD            length;         /* Longueur du sample */
        WORD            loopstart;      /* Dbut du looping */
        WORD            loopend;        /* Fin du looping */
        BYTE            *sample;        /* Pointeur sur le sample */
} SAMPLE;

/* Structure de canal */
typedef struct
{
        WORD            flags;          /* Infos sur le sample */
        BYTE            vol;            /* Volume du canal */
	WORD            freq;           /* Frquence du canal */
	WORD            length;         /* Longueur du sample */
	WORD            loopstart;      /* Dbut du looping */
	WORD            loopend;        /* Fin du looping */
	BYTE            *sample;        /* Pointeur sur le sample */
	BYTE		*pvol;          /* Index dans la table de volume */
        DWORD           start;          /* Dbut de la zone  mixer */
        DWORD           end;            /* Fin de la zone  mixer */ 
        DWORD           pos;            /* Position dans le sample */
        DWORD           incr;           /* Incrment de la position */
} CHANNEL;

/* Variables globales */
extern	CHANNEL	*tss_channels;		/* Pointeur sur les canaux */
extern	WORD	tss_nbrchannels;	/* Nombre de canaux */
extern	BYTE	tss_mainvol;		/* Volume de mixage */
extern	WORD	tss_mainfreq;		/* Frquence de mixage */

/* Fonctions */
int     tss_init (WORD nbrchn, WORD mainfreq);  /* Initialise TSS */
void    tss_done ();                            /* Uninitialise TSS */
int     tss_setnbrchn (WORD nbrchn);            /* Rgle nbr de canaux */
int     tss_setmainvol (BYTE mainvol);          /* Rgle vol de mixage */
int     tss_setmainfreq (WORD mainfreq);        /* Rgle freq de mixage */
void    tss_setchnvol (WORD chn, BYTE vol);     /* Rgle vol d'un canal */
void    tss_setchnfreq (WORD chn, WORD freq);   /* Rgle freq d'un canal */
void    tss_playsample (WORD chn, SAMPLE *smp); /* Sort un sample */
void    tss_stopsample (WORD chn);              /* Stoppe un sample */

#endif